/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops.saturationops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyTemperatureFlash;

public class DewPointPressureFlash
extends ConstantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;

    public DewPointPressureFlash(SystemInterface system) {
        super(system);
    }

    @Override
    public void run() {
        int i;
        if (this.system.getPhase(0).getNumberOfComponents() == 1 && this.system.getPressure() > this.system.getPhase(0).getComponent(0).getPC()) {
            this.setSuperCritical(true);
        }
        int iterations = 0;
        int maxNumberOfIterations = 5000;
        double xold = 0.0;
        double xtotal = 1.0;
        this.system.init(0);
        this.system.setBeta(0, 0.9999999999);
        this.system.setBeta(1, 1.0E-10);
        this.system.setNumberOfPhases(2);
        double oldPres = 0.0;
        if (this.system.isChemicalSystem()) {
            this.system.getChemicalReactionOperations().solveChemEq(0);
            this.system.getChemicalReactionOperations().solveChemEq(1);
        }
        for (i = 0; i < this.system.getPhases()[1].getNumberOfComponents(); ++i) {
            this.system.getPhases()[0].getComponent(i).setx(this.system.getPhases()[0].getComponent(i).getz());
            if (this.system.getPhases()[0].getComponent(i).getIonicCharge() != 0.0) {
                this.system.getPhases()[0].getComponent(i).setx(1.0E-40);
                continue;
            }
            this.system.getPhases()[1].getComponent(i).setx(1.0 / this.system.getPhases()[0].getComponent(i).getK() * this.system.getPhases()[1].getComponent(i).getz());
        }
        xtotal = 0.0;
        for (i = 0; i < this.system.getPhases()[1].getNumberOfComponents(); ++i) {
            xtotal += this.system.getPhases()[1].getComponent(i).getx();
        }
        double ktot = 0.0;
        do {
            int i2;
            ++iterations;
            for (i2 = 0; i2 < this.system.getPhases()[1].getNumberOfComponents(); ++i2) {
                this.system.getPhases()[1].getComponent(i2).setx(this.system.getPhases()[1].getComponent(i2).getx() / xtotal);
            }
            this.system.init(1);
            ktot = 0.0;
            oldPres = this.system.getPressure();
            for (i2 = 0; i2 < this.system.getPhases()[1].getNumberOfComponents(); ++i2) {
                do {
                    xold = this.system.getPhases()[1].getComponent(i2).getx();
                    if (this.system.getPhase(0).getComponent(i2).getIonicCharge() != 0.0) {
                        this.system.getPhases()[0].getComponent(i2).setK(1.0E-40);
                    } else {
                        this.system.getPhases()[0].getComponent(i2).setK(Math.exp(Math.log(this.system.getPhases()[1].getComponent(i2).getFugacityCoefficient()) - Math.log(this.system.getPhases()[0].getComponent(i2).getFugacityCoefficient())));
                    }
                    this.system.getPhases()[1].getComponent(i2).setK(this.system.getPhases()[0].getComponent(i2).getK());
                    this.system.getPhases()[1].getComponent(i2).setx(1.0 / this.system.getPhases()[0].getComponent(i2).getK() * this.system.getPhases()[1].getComponent(i2).getz());
                } while (Math.abs(this.system.getPhases()[1].getComponent(i2).getx() - xold) > 1.0E-4);
                ktot += Math.abs(this.system.getPhases()[1].getComponent(i2).getK() - 1.0);
            }
            xtotal = 0.0;
            for (i2 = 0; i2 < this.system.getPhases()[1].getNumberOfComponents(); ++i2) {
                xtotal += this.system.getPhases()[1].getComponent(i2).getx();
            }
            this.system.setPressure(oldPres + 0.1 * (this.system.getPressure() / xtotal - oldPres));
        } while ((Math.abs(xtotal) - 1.0 > 1.0E-10 || Math.abs(oldPres - this.system.getPressure()) / oldPres > 1.0E-9) && iterations < maxNumberOfIterations);
        if (Math.abs(xtotal - 1.0) >= 1.0E-5 || ktot < 0.001 && this.system.getPhase(0).getNumberOfComponents() > 1) {
            this.setSuperCritical(true);
        }
    }

    @Override
    public void printToFile(String name) {
    }
}

