/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.phaseenvelopeops.reactivecurves;

import java.awt.FlowLayout;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import neqsim.datapresentation.DataHandling;
import neqsim.datapresentation.jfreechart.Graph2b;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.BaseOperation;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.chart.JFreeChart;

public class PloadingCurve2
extends BaseOperation {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PloadingCurve2.class);
    SystemInterface system;
    int i;
    int j = 0;
    int nummer = 0;
    int iterations = 0;
    int maxNumberOfIterations = 10000;
    double gibbsEnergy = 0.0;
    double gibbsEnergyOld = 0.0;
    double Kold;
    double deviation = 0.0;
    double g0 = 0.0;
    double g1 = 0.0;
    double[] lnOldOldK;
    double[] lnK;
    double[] lnOldK;
    double[] oldDeltalnK;
    double[] deltalnK;
    double[] tm = new double[]{1.0, 1.0};
    double beta = 1.0E-5;
    int lowestGibbsEnergyPhase = 0;
    JProgressBar monitor;
    JFrame mainFrame;
    JPanel mainPanel;
    double temp = 0.0;
    double pres = 0.0;
    double startPres = 0.0;
    double[][] points = new double[35][];
    boolean moreLines = false;
    int np = 0;
    int speceq = 0;

    public PloadingCurve2(SystemInterface system) {
        this.system = system;
        this.lnOldOldK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.lnOldK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.lnK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.oldDeltalnK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.deltalnK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.mainFrame = new JFrame("Progress Bar");
        this.mainPanel = new JPanel();
        this.mainPanel.setSize(200, 100);
        this.mainFrame.getContentPane().setLayout(new FlowLayout());
        this.mainPanel.setLayout(new FlowLayout());
        this.mainFrame.setSize(200, 100);
        this.monitor = new JProgressBar(0, 1000);
        this.monitor.setSize(200, 100);
        this.monitor.setStringPainted(true);
        this.mainPanel.add(this.monitor);
        this.mainFrame.getContentPane().add(this.mainPanel);
        this.mainFrame.setVisible(true);
    }

    @Override
    public void run() {
        int numbPoints = 50;
        double inscr = 0.2103842275;
        this.points[0] = new double[numbPoints];
        this.points[1] = new double[numbPoints];
        this.points[2] = new double[numbPoints];
        ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
        for (int k = 0; k < this.system.getPhases()[1].getNumberOfComponents(); ++k) {
            this.points[k + 3] = new double[numbPoints];
            this.points[k + 3 + this.system.getPhases()[1].getNumberOfComponents()] = new double[numbPoints];
        }
        double molMDEA = this.system.getPhases()[1].getComponents()[2].getNumberOfMolesInPhase();
        this.system.getChemicalReactionOperations().solveChemEq(1);
        for (int i = 1; i < this.points[0].length; ++i) {
            this.system.initBeta();
            this.system.init_x_y();
            try {
                testOps.bubblePointPressureFlash(false);
            }
            catch (Exception ex) {
                logger.info(ex.toString());
            }
            logger.info("beta " + this.system.getBeta());
            this.points[0][i] = inscr * (double)(i - 1) / molMDEA;
            this.points[1][i] = this.system.getPressure();
            this.points[2][i] = this.system.getPressure() * this.system.getPhase(0).getComponent(0).getx();
            for (int k = 0; k < this.system.getPhases()[1].getNumberOfComponents(); ++k) {
                this.points[k + 3][i] = this.system.getPhases()[1].getComponent(k).getx();
                this.points[k + 3 + this.system.getPhases()[1].getNumberOfComponents()][i] = this.system.getPhase(1).getActivityCoefficient(k, 1);
            }
            logger.info("point: " + this.points[0][i] + " tot pres  " + this.points[1][i] + " CO2 pres  " + this.points[2][i]);
            this.system.setPressure(this.points[1][i]);
            logger.info("ph: " + this.system.getPhases()[1].getpH());
            this.system.addComponent("CO2", inscr);
        }
        this.mainFrame.setVisible(false);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(1);
        nf.applyPattern("####.#");
        double TC = this.system.getTC();
        double PC = this.system.getPC();
        logger.info("tc : " + TC + "  PC : " + PC);
        String[] navn = new String[]{"CO2 fugacity", "", "", ""};
        String title = "CO2 vapour pressure";
        Graph2b graph2 = new Graph2b(this.points, navn, title, "loading [-]", "Fugacity CO2 [bar]");
        graph2.setVisible(true);
    }

    @Override
    public void printToFile(String name) {
        DataHandling printDat = new DataHandling();
        printDat.printToFile(this.points, name);
    }

    @Override
    public double[][] getPoints(int i) {
        return this.points;
    }

    @Override
    public double[] get(String name) {
        return null;
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }

    @Override
    public String[][] getResultTable() {
        return null;
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.system;
    }
}

