/*
 * Decompiled with CFR 0.152.
 */
package neqsim.util.database;

import java.sql.Connection;
import java.sql.Statement;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NeqSimContractDataBase
extends NeqSimDataBase {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(NeqSimContractDataBase.class);
    public static String dataBasePath = "";
    private static boolean createTemporaryTables = false;
    private static String username = "remote";
    private static String password = "remote";
    private static String dataBaseType = "H2fromCSV";
    private static String connectionString = "jdbc:h2:mem:neqsimcontractdatabase";
    private static boolean h2IsInitialized = false;
    private static boolean h2IsInitalizing = false;
    private Statement statement = null;
    protected Connection databaseConnection = null;

    public NeqSimContractDataBase() {
        if ("H2fromCSV".equals(dataBaseType) && !h2IsInitialized && !h2IsInitalizing) {
            NeqSimContractDataBase.initH2DatabaseFromCSVfiles();
        }
        NeqSimContractDataBase.setDataBaseType(dataBaseType);
        try {
            this.databaseConnection = this.openConnection();
            this.statement = this.databaseConnection.createStatement();
        }
        catch (Exception ex) {
            logger.error("SQLException ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public static void updateTable(String tableName) {
        NeqSimContractDataBase.updateTable(tableName, "commercial/" + tableName + ".csv");
    }

    public static void initH2DatabaseFromCSVfiles() {
        h2IsInitalizing = true;
        connectionString = "jdbc:h2:mem:neqsimcontractdatabase;DB_CLOSE_DELAY=-1";
        dataBaseType = "H2";
        try {
            NeqSimContractDataBase.updateTable("GASCONTRACTSPECIFICATIONS");
            h2IsInitialized = true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

