/*
 * Decompiled with CFR 0.152.
 */
package neqsim.util.database;

import java.sql.Connection;
import java.sql.Statement;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NeqSimProcessDesignDataBase
extends NeqSimDataBase {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(NeqSimProcessDesignDataBase.class);
    public static String dataBasePath = "";
    private static boolean createTemporaryTables = false;
    private static String username = "remote";
    private static String password = "remote";
    private static String dataBaseType = "H2fromCSV";
    private static String connectionString = "jdbc:h2:mem:neqsimprocessdesigndatabase";
    private static boolean h2IsInitialized = false;
    private static boolean h2IsInitalizing = false;
    private Statement statement = null;
    protected Connection databaseConnection = null;

    public NeqSimProcessDesignDataBase() {
        if ("H2fromCSV".equals(dataBaseType) && !h2IsInitialized && !h2IsInitalizing) {
            NeqSimProcessDesignDataBase.initH2DatabaseFromCSVfiles();
        }
        NeqSimProcessDesignDataBase.setDataBaseType(dataBaseType);
        try {
            this.databaseConnection = this.openConnection();
            this.statement = this.databaseConnection.createStatement();
        }
        catch (Exception ex) {
            logger.error("SQLException ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public static void updateTable(String tableName) {
        NeqSimProcessDesignDataBase.updateTable(tableName, "designdata/" + tableName + ".csv");
    }

    public static void initH2DatabaseFromCSVfiles() {
        h2IsInitalizing = true;
        connectionString = "jdbc:h2:mem:neqsimprocessdesigndatabase;DB_CLOSE_DELAY=-1";
        dataBaseType = "H2";
        try {
            NeqSimProcessDesignDataBase.updateTable("TORG");
            NeqSimProcessDesignDataBase.updateTable("TechnicalRequirements_Process");
            NeqSimProcessDesignDataBase.updateTable("TechnicalRequirements_Piping");
            NeqSimProcessDesignDataBase.updateTable("TechnicalRequirements_Material");
            NeqSimProcessDesignDataBase.updateTable("TechnicalRequirements_Mechanical");
            NeqSimProcessDesignDataBase.updateTable("Packing");
            NeqSimProcessDesignDataBase.updateTable("MaterialPipeProperties");
            NeqSimProcessDesignDataBase.updateTable("MaterialPlateProperties");
            NeqSimProcessDesignDataBase.updateTable("Fittings");
            h2IsInitialized = true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

