/*
 * Decompiled with CFR 0.152.
 */
package neqsim.util.unit;

import neqsim.util.exception.InvalidInputException;
import neqsim.util.unit.BaseUnit;

public class EnergyUnit
extends BaseUnit {
    private static final long serialVersionUID = 1000L;

    public EnergyUnit(double value, String unit) {
        super(value, unit);
    }

    public double getConversionFactor(String name) {
        switch (name) {
            case "J": {
                return 1.0;
            }
            case "kJ": {
                return 1000.0;
            }
            case "MJ": {
                return 1000000.0;
            }
            case "Wh": {
                return 3600.0;
            }
            case "kWh": {
                return 3600000.0;
            }
            case "MWh": {
                return 3.6E9;
            }
            case "BTU": {
                return 1055.05585;
            }
            case "kcal": {
                return 4184.0;
            }
        }
        throw new RuntimeException(new InvalidInputException(this, "getConversionFactor", name, "unit not supported"));
    }

    @Override
    public double getValue(double val, String fromunit, String tounit) {
        this.invalue = val;
        return this.getConversionFactor(fromunit) / this.getConversionFactor(tounit) * this.invalue;
    }

    @Override
    public double getValue(String tounit) {
        return this.getConversionFactor(this.inunit) / this.getConversionFactor(tounit) * this.invalue;
    }
}

