/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flownode.fluidboundary.interphasetransportcoefficient;

import neqsim.fluidmechanics.flownode.FlowNodeInterface;
import neqsim.fluidmechanics.flownode.fluidboundary.interphasetransportcoefficient.InterphaseTransportCoefficientInterface;

public class InterphaseTransportCoefficientBaseClass
implements InterphaseTransportCoefficientInterface {
    public InterphaseTransportCoefficientBaseClass() {
    }

    public InterphaseTransportCoefficientBaseClass(FlowNodeInterface node) {
    }

    @Override
    public double calcWallFrictionFactor(FlowNodeInterface node) {
        return this.calcWallFrictionFactor(0, node);
    }

    @Override
    public double calcWallFrictionFactor(int phase, FlowNodeInterface node) {
        if (Math.abs(node.getReynoldsNumber()) < 2000.0) {
            return 64.0 / node.getReynoldsNumber(phase);
        }
        return Math.pow(1.0 / (-1.8 * Math.log10(6.9 / node.getReynoldsNumber(phase) + Math.pow(node.getGeometry().getRelativeRoughnes() / 3.7, 1.11))), 2.0);
    }

    @Override
    public double calcInterPhaseFrictionFactor(int phase, FlowNodeInterface node) {
        return (1.0 + 75.0 * node.getPhaseFraction(1)) * this.calcWallFrictionFactor(0, node);
    }

    @Override
    public double calcWallHeatTransferCoefficient(int phase, double prandtlNumber, FlowNodeInterface node) {
        return 0.0;
    }

    @Override
    public double calcWallHeatTransferCoefficient(int phase, FlowNodeInterface node) {
        return this.calcWallHeatTransferCoefficient(phase, node.getPrandtlNumber(phase), node);
    }

    @Override
    public double calcWallMassTransferCoefficient(int phase, double schmidtNumber, FlowNodeInterface node) {
        return 0.0;
    }

    @Override
    public double calcInterphaseHeatTransferCoefficient(int phase, double prandtlNumber, FlowNodeInterface node) {
        return 0.0;
    }

    @Override
    public double calcInterphaseMassTransferCoefficient(int phase, double schmidt, FlowNodeInterface node) {
        return 0.0;
    }
}

