/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flowsolver.twophaseflowsolver.twophasepipeflowsolver;

import Jama.Matrix;
import neqsim.fluidmechanics.flowsolver.twophaseflowsolver.twophasepipeflowsolver.TwoPhasePipeFlowSolver;
import neqsim.fluidmechanics.flowsystem.FlowSystemInterface;
import neqsim.mathlib.generalmath.TDMAsolve;
import neqsim.thermo.ThermodynamicConstantsInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TwoPhaseFixedStaggeredGridSolver
extends TwoPhasePipeFlowSolver
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(TwoPhaseFixedStaggeredGridSolver.class);
    Matrix diffMatrix;
    double[][] dn;
    int iter = 0;
    Matrix[] diff4Matrix;
    double[][][] xNew;
    protected double[][] oldMass;
    protected double[][] oldComp;
    protected double[][] oldDensity;
    protected double[][] oldVelocity;
    protected double[][][] oldComposition;
    protected double[][] oldInternalEnergy;
    protected double[][] oldImpuls;
    protected double[][] oldEnergy;

    public TwoPhaseFixedStaggeredGridSolver() {
    }

    public TwoPhaseFixedStaggeredGridSolver(FlowSystemInterface pipe, double length, int nodes) {
        super(pipe, length, nodes);
    }

    public TwoPhaseFixedStaggeredGridSolver(FlowSystemInterface pipe, double length, int nodes, boolean dynamic) {
        super(pipe, length, nodes);
        this.dynamic = dynamic;
        this.oldMass = new double[2][nodes];
        this.oldComp = new double[2][nodes];
        this.oldImpuls = new double[2][nodes];
        this.diff4Matrix = new Matrix[pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.oldEnergy = new double[2][nodes];
        this.oldVelocity = new double[2][nodes];
        this.oldDensity = new double[2][nodes];
        this.oldInternalEnergy = new double[2][nodes];
        this.oldComposition = new double[2][pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()][nodes];
        this.numberOfVelocityNodes = nodes;
    }

    @Override
    public TwoPhaseFixedStaggeredGridSolver clone() {
        TwoPhaseFixedStaggeredGridSolver clonedSystem = null;
        try {
            clonedSystem = (TwoPhaseFixedStaggeredGridSolver)super.clone();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return clonedSystem;
    }

    public void initProfiles() {
        double[][][] molDiff = new double[this.numberOfNodes][2][this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.pipe.getNode(0).getBulkSystem().initBeta();
        this.pipe.getNode(0).getBulkSystem().init_x_y();
        this.pipe.getNode(0).initFlowCalc();
        this.pipe.getNode(0).calcFluxes();
        for (int i = 1; i < this.numberOfNodes - 1; ++i) {
            this.pipe.getNode(i).getBulkSystem().initBeta();
            this.pipe.getNode(i).getBulkSystem().init_x_y();
            this.pipe.getNode(i).initFlowCalc();
            this.pipe.getNode(i).calcFluxes();
            double liquidHeatRate = this.pipe.getNode(i).getFluidBoundary().getInterphaseHeatFlux(1) * this.pipe.getNode(i).getInterphaseContactArea() * (this.pipe.getNode(i).getGeometry().getNodeLength() / this.pipe.getNode(i).getVelocity(1));
            double gasHeatRate = -this.pipe.getNode(i).getFluidBoundary().getInterphaseHeatFlux(0) * this.pipe.getNode(i).getInterphaseContactArea() * (this.pipe.getNode(i).getGeometry().getNodeLength() / this.pipe.getNode(i).getVelocity(0));
            double liquid_dT = liquidHeatRate / this.pipe.getNode(i).getBulkSystem().getPhase(1).getCp();
            double gas_dT = gasHeatRate / this.pipe.getNode(i).getBulkSystem().getPhase(0).getCp();
            this.pipe.getNode(i + 1).getBulkSystem().getPhase(0).setTemperature(this.pipe.getNode(i).getBulkSystem().getPhase(0).getTemperature() + gas_dT);
            this.pipe.getNode(i + 1).getBulkSystem().getPhase(1).setTemperature(this.pipe.getNode(i).getBulkSystem().getPhase(1).getTemperature() + liquid_dT);
            for (int componentNumber = 0; componentNumber < this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents(); ++componentNumber) {
                double liquidMolarRate = this.pipe.getNode(i).getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.pipe.getNode(i).getInterphaseContactArea() * (this.pipe.getNode(i).getGeometry().getNodeLength() / this.pipe.getNode(i).getVelocity(1));
                double gasMolarRate = -this.pipe.getNode(i).getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.pipe.getNode(i).getInterphaseContactArea() * (this.pipe.getNode(i).getGeometry().getNodeLength() / this.pipe.getNode(i).getVelocity(0));
                molDiff[i][0][componentNumber] = molDiff[i - 1][0][componentNumber] + gasMolarRate;
                molDiff[i][1][componentNumber] = molDiff[i - 1][1][componentNumber] + liquidMolarRate;
                this.pipe.getNode(i + 1).getBulkSystem().getPhases()[0].addMoles(componentNumber, molDiff[i - 1][0][componentNumber]);
                this.pipe.getNode(i + 1).getBulkSystem().getPhases()[1].addMoles(componentNumber, molDiff[i - 1][1][componentNumber]);
            }
        }
        this.pipe.getNode(this.numberOfNodes - 1).init();
        this.pipe.getNode(this.numberOfNodes - 1).calcFluxes();
        this.pipe.getNode(this.numberOfNodes - 1).getBulkSystem().initBeta();
        this.pipe.getNode(this.numberOfNodes - 1).getBulkSystem().init_x_y();
        this.initNodes();
        System.out.println("finisched initializing....");
    }

    public void initMatrix() {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).init();
            double enthalpy0 = this.pipe.getNode(i).getBulkSystem().getPhases()[0].getEnthalpy() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfMolesInPhase() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getMolarMass();
            double enthalpy1 = this.pipe.getNode(i).getBulkSystem().getPhases()[1].getEnthalpy() / this.pipe.getNode(i).getBulkSystem().getPhases()[1].getNumberOfMolesInPhase() / this.pipe.getNode(i).getBulkSystem().getPhases()[1].getMolarMass();
            this.solMatrix[0].set(i, 0, this.pipe.getNode(i).getVelocityIn(0).doubleValue());
            this.solMatrix[1].set(i, 0, this.pipe.getNode(i).getVelocityIn(1).doubleValue());
            this.sol3Matrix[0].set(i, 0, enthalpy0);
            this.sol3Matrix[1].set(i, 0, enthalpy1);
            this.solPhaseConsMatrix[0].set(i, 0, this.pipe.getNode(i).getBulkSystem().getPhases()[0].getPhysicalProperties().getDensity());
            this.solPhaseConsMatrix[1].set(i, 0, this.pipe.getNode(i).getPhaseFraction(1));
            for (int phaseNum = 0; phaseNum < 2; ++phaseNum) {
                for (int j = 0; j < this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfComponents(); ++j) {
                    this.solMolFracMatrix[phaseNum][j].set(i, 0, this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getComponent(j).getx() * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getComponent(j).getMolarMass() / this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getMolarMass());
                }
            }
        }
    }

    public void initPressure(int phaseNum) {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).init();
            this.pipe.getNode(i).getBulkSystem().setPressure(0.8 * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getdPdrho() * this.diffMatrix.get(i, 0) * 1.0E-5 + this.pipe.getNode(i).getBulkSystem().getPressure());
            this.pipe.getNode(i).init();
        }
    }

    public void initVelocity(int phase) {
        int i;
        for (i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).setVelocityIn(phase, this.pipe.getNode(i).getVelocityIn(phase).doubleValue() + 0.8 * (this.solMatrix[phase].get(i, 0) - this.pipe.getNode(i).getVelocityIn(phase).doubleValue()));
        }
        for (i = 0; i < this.numberOfNodes; ++i) {
            double meanVelocity = this.pipe.getNode(i).getVelocityIn(phase).doubleValue();
            this.pipe.getNode(i).setVelocity(phase, meanVelocity);
            this.pipe.getNode(i).init();
        }
    }

    public void initTemperature(int phaseNum) {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).init();
            this.pipe.getNode(i).getBulkSystem().setTemperature(this.pipe.getNode(i).getBulkSystem().getTemperature(phaseNum) + 0.8 * this.diffMatrix.get(i, 0) / (this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getCp() / this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getNumberOfMolesInPhase() / this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getMolarMass()), phaseNum);
            this.pipe.getNode(i).init();
        }
    }

    public void initPhaseFraction(int phase) {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).setPhaseFraction(phase, this.pipe.getNode(i).getPhaseFraction(phase) + 0.8 * this.diffMatrix.get(i, 0));
            this.pipe.getNode(i).setPhaseFraction(0, 1.0 - this.pipe.getNode(i).getPhaseFraction(phase));
            this.pipe.getNode(i).init();
        }
    }

    public void initComposition(int phaseNum, int comp) {
        for (int j = 0; j < this.numberOfNodes; ++j) {
            if (this.pipe.getNode(j).getBulkSystem().getPhase(phaseNum).getComponents()[comp].getx() + this.diffMatrix.get(j, 0) * this.pipe.getNode(j).getBulkSystem().getPhase(phaseNum).getMolarMass() / this.pipe.getNode(j).getBulkSystem().getPhase(phaseNum).getComponents()[comp].getMolarMass() > 1.0) {
                this.pipe.getNode(j).getBulkSystem().getPhase(phaseNum).getComponents()[comp].setx(1.0);
            } else if (this.pipe.getNode(j).getBulkSystem().getPhase(phaseNum).getComponents()[comp].getx() + this.diffMatrix.get(j, 0) * this.pipe.getNode(j).getBulkSystem().getPhase(phaseNum).getMolarMass() / this.pipe.getNode(j).getBulkSystem().getPhase(phaseNum).getComponents()[comp].getMolarMass() < 0.0) {
                this.pipe.getNode(j).getBulkSystem().getPhase(phaseNum).getComponents()[comp].setx(1.0E-30);
            } else {
                this.pipe.getNode(j).getBulkSystem().getPhase(phaseNum).getComponents()[comp].setx(this.pipe.getNode(j).getBulkSystem().getPhase(phaseNum).getComponents()[comp].getx() + this.diffMatrix.get(j, 0) * this.pipe.getNode(j).getBulkSystem().getPhase(phaseNum).getMolarMass() / this.pipe.getNode(j).getBulkSystem().getPhase(phaseNum).getComponents()[comp].getMolarMass());
            }
            double xSum = 0.0;
            for (int i = 0; i < this.pipe.getNode(j).getBulkSystem().getPhase(phaseNum).getNumberOfComponents() - 1; ++i) {
                xSum += this.pipe.getNode(j).getBulkSystem().getPhase(phaseNum).getComponent(i).getx();
            }
            this.pipe.getNode(j).getBulkSystem().getPhase(phaseNum).getComponents()[this.pipe.getNode(j).getBulkSystem().getPhase(phaseNum).getNumberOfComponents() - 1].setx(1.0 - xSum);
            this.pipe.getNode(j).init();
        }
    }

    public void setMassConservationMatrix(int phaseNum) {
        int i;
        if (!this.dynamic) {
            double SU = 0.0;
            this.a[0] = 0.0;
            this.b[0] = 1.0;
            this.c[0] = 0.0;
            this.r[0] = SU = this.pipe.getNode(0).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity();
        } else {
            this.oldMass[phaseNum][0] = 1.0 / this.timeStep * this.pipe.getNode(0).getGeometry().getArea() * this.pipe.getNode(0).getGeometry().getNodeLength();
            this.a[0] = 0.0;
            this.c[0] = 1.0;
            this.b[0] = 1.0;
            this.r[0] = 0.0;
            this.a[0] = -this.a[0];
            this.c[0] = -this.c[0];
        }
        for (i = 1; i < this.numberOfNodes - 1; ++i) {
            double Ae = this.pipe.getNode(i).getArea(phaseNum);
            double Aw = this.pipe.getNode(i - 1).getArea(phaseNum);
            double Fe = this.pipe.getNode(i).getVelocityOut(phaseNum).doubleValue() * Ae;
            double Fw = this.pipe.getNode(i).getVelocityIn(phaseNum).doubleValue() * Aw;
            this.oldMass[phaseNum][i] = this.dynamic ? 1.0 / this.timeStep * this.pipe.getNode(i).getArea(phaseNum) * this.pipe.getNode(i).getGeometry().getNodeLength() : 0.0;
            this.a[i] = Math.max(Fw, 0.0);
            this.c[i] = Math.max(-Fe, 0.0);
            this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) + this.oldMass[phaseNum][i];
            this.r[i] = this.oldMass[phaseNum][i] * this.oldDensity[phaseNum][i];
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
        }
        i = this.numberOfNodes - 1;
        this.oldMass[phaseNum][i] = this.dynamic ? 1.0 / this.timeStep * this.pipe.getNode(i).getArea(phaseNum) * this.pipe.getNode(i).getGeometry().getNodeLength() : 0.0;
        this.a[i] = 1.0;
        this.c[i] = 0.0;
        this.b[i] = 1.0;
        this.r[i] = 0.0;
        this.a[i] = -this.a[i];
        this.c[i] = -this.c[i];
    }

    public void setPhaseFractionMatrix(int phaseNum) {
        double Fw;
        double Fe;
        double Aw;
        double Ae;
        int i;
        if (!this.dynamic) {
            double SU = 0.0;
            this.a[0] = 0.0;
            this.b[0] = 1.0;
            this.c[0] = 0.0;
            this.r[0] = SU = this.pipe.getNode(0).getPhaseFraction(phaseNum);
        } else {
            this.oldMass[phaseNum][0] = 1.0 / this.timeStep * this.pipe.getNode(0).getGeometry().getArea() * this.pipe.getNode(0).getGeometry().getNodeLength();
            this.a[0] = 0.0;
            this.c[0] = 1.0;
            this.b[0] = 1.0;
            this.r[0] = 0.0;
            this.a[0] = -this.a[0];
            this.c[0] = -this.c[0];
        }
        for (i = 1; i < this.numberOfNodes - 1; ++i) {
            Ae = this.pipe.getNode(i).getGeometry().getArea();
            Aw = this.pipe.getNode(i - 1).getGeometry().getArea();
            Fe = this.pipe.getNode(i).getVelocityOut(phaseNum).doubleValue() * Ae * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity();
            Fw = this.pipe.getNode(i).getVelocityIn(phaseNum).doubleValue() * Aw * this.pipe.getNode(i - 1).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity();
            this.oldMass[phaseNum][i] = this.dynamic ? 1.0 / this.timeStep * this.pipe.getNode(i).getGeometry().getArea() * this.pipe.getNode(i).getGeometry().getNodeLength() : 0.0;
            this.a[i] = Math.max(Fw, 0.0);
            this.c[i] = Math.max(-Fe, 0.0);
            this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) + this.oldMass[phaseNum][i];
            this.r[i] = this.oldMass[phaseNum][i] * this.oldDensity[phaseNum][i];
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
        }
        i = this.numberOfNodes - 1;
        Ae = this.pipe.getNode(i).getGeometry().getArea();
        Aw = this.pipe.getNode(i - 1).getGeometry().getArea();
        Fe = this.pipe.getNode(i).getVelocity(phaseNum) * Ae * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity();
        Fw = this.pipe.getNode(i).getVelocityIn(phaseNum).doubleValue() * Aw * this.pipe.getNode(i - 1).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity();
        this.oldMass[phaseNum][i] = this.dynamic ? 1.0 / this.timeStep * this.pipe.getNode(i).getGeometry().getArea() * this.pipe.getNode(i).getGeometry().getNodeLength() : 0.0;
        this.a[i] = Math.max(Fw, 0.0);
        this.c[i] = Math.max(-Fe, 0.0);
        this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) + this.oldMass[phaseNum][i];
        this.r[i] = this.oldMass[phaseNum][i] * this.oldDensity[phaseNum][i];
        this.a[i] = -this.a[i];
        this.c[i] = -this.c[i];
    }

    public void setImpulsMatrixTDMA(int phaseNum) {
        double interfaceFricition;
        double nodeLength;
        double vertposchange;
        double meanVelocity;
        double oldMeanDensity;
        double meanDensity;
        double meanFrik;
        double Amean;
        double Aw;
        double Ae;
        int i;
        double sign = phaseNum == 0 ? 1.0 : -1.0;
        double SU = 0.0;
        double SP = 0.0;
        double Fw = 0.0;
        double Fe = 0.0;
        this.pipe.getNode(0).initFlowCalc();
        this.pipe.getNode(0).init();
        this.pipe.getNode(0).setVelocityIn(phaseNum, this.pipe.getNode(0).getVelocity(phaseNum));
        this.a[0] = 0.0;
        this.b[0] = 1.0;
        this.c[0] = 0.0;
        this.r[0] = this.pipe.getNode(0).getVelocityIn(phaseNum).doubleValue();
        this.a[1] = 0.0;
        this.b[1] = 1.0;
        this.c[1] = 0.0;
        this.r[1] = this.pipe.getNode(0).getVelocityIn(phaseNum).doubleValue();
        for (i = 2; i < this.numberOfNodes - 1; ++i) {
            Ae = this.pipe.getNode(i).getArea(phaseNum);
            Aw = this.pipe.getNode(i - 1).getArea(phaseNum);
            Amean = this.pipe.getNode(i - 1).getArea(phaseNum);
            meanFrik = this.pipe.getNode(i - 1).getWallFrictionFactor(phaseNum);
            meanDensity = this.pipe.getNode(i - 1).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity();
            oldMeanDensity = this.oldDensity[phaseNum][i];
            meanVelocity = this.pipe.getNode(i - 1).getVelocity(phaseNum);
            vertposchange = this.pipe.getNode(i).getVerticalPositionOfNode() - this.pipe.getNode(i - 1).getVerticalPositionOfNode();
            nodeLength = this.pipe.getNode(i - 1).getGeometry().getNodeLength();
            interfaceFricition = this.pipe.getNode(i - 1).getInterPhaseFrictionFactor();
            SU = -Amean * (this.pipe.getNode(i).getBulkSystem().getPressure() - this.pipe.getNode(i - 1).getBulkSystem().getPressure()) * 100000.0 + Amean * 9.80665 * meanDensity * vertposchange + this.pipe.getNode(i - 1).getWallContactLength(phaseNum) * nodeLength * meanDensity * meanFrik * Math.abs(meanVelocity) * meanVelocity / 8.0 - this.pipe.getNode(i - 1).getInterphaseContactLength(0) * nodeLength * meanDensity * interfaceFricition * Math.abs(this.pipe.getNode(i).getVelocity(0) - this.pipe.getNode(i).getVelocity(1)) * (this.pipe.getNode(i).getVelocity(0) - this.pipe.getNode(i).getVelocity(1)) / 8.0 * sign;
            SP = -this.pipe.getNode(i - 1).getWallContactLength(phaseNum) * nodeLength * meanDensity * meanFrik * meanVelocity / 4.0;
            Fw = Aw * this.pipe.getNode(i - 1).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity() * this.pipe.getNode(i - 1).getVelocity(phaseNum);
            Fe = Ae * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity() * this.pipe.getNode(i).getVelocity(phaseNum);
            this.oldImpuls[phaseNum][i] = this.dynamic ? 1.0 / this.timeStep * oldMeanDensity * nodeLength * Amean : 0.0;
            this.a[i] = Math.max(Fw, 0.0);
            this.c[i] = Math.max(-Fe, 0.0);
            this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) - SP + this.oldImpuls[phaseNum][i];
            this.r[i] = SU + this.oldImpuls[phaseNum][i] * this.oldVelocity[phaseNum][i];
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
        }
        i = this.numberOfNodes - 1;
        Ae = this.pipe.getNode(i - 1).getArea(phaseNum);
        Aw = this.pipe.getNode(i - 1).getArea(phaseNum);
        Amean = this.pipe.getNode(i - 1).getArea(phaseNum);
        meanFrik = this.pipe.getNode(i - 1).getWallFrictionFactor(phaseNum);
        meanDensity = this.pipe.getNode(i - 1).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity();
        oldMeanDensity = this.oldDensity[phaseNum][i];
        meanVelocity = this.pipe.getNode(i - 1).getVelocity(phaseNum);
        vertposchange = this.pipe.getNode(i).getVerticalPositionOfNode() - this.pipe.getNode(i - 1).getVerticalPositionOfNode();
        nodeLength = this.pipe.getNode(i - 1).getGeometry().getNodeLength();
        interfaceFricition = this.pipe.getNode(i - 1).getInterPhaseFrictionFactor();
        SU = -Amean * (this.pipe.getNode(i).getBulkSystem().getPressure() - this.pipe.getNode(i - 1).getBulkSystem().getPressure()) * 100000.0 - Amean * 9.80665 * meanDensity * vertposchange + this.pipe.getNode(i - 1).getWallContactLength(phaseNum) * nodeLength * meanDensity * meanFrik * Math.abs(meanVelocity) * meanVelocity / 8.0 - this.pipe.getNode(i - 1).getInterphaseContactLength(0) * nodeLength * meanDensity * interfaceFricition * Math.abs(this.pipe.getNode(i).getVelocity(0) - this.pipe.getNode(i).getVelocity(1)) * (this.pipe.getNode(i).getVelocity(0) - this.pipe.getNode(i).getVelocity(1)) / 8.0 * sign;
        SP = -this.pipe.getNode(i - 1).getWallContactLength(phaseNum) * nodeLength * meanDensity * meanFrik * meanVelocity / 4.0;
        Fw = Aw * this.pipe.getNode(i - 1).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity() * this.pipe.getNode(i).getVelocityIn(phaseNum).doubleValue();
        Fe = Ae * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity() * this.pipe.getNode(i).getVelocity(phaseNum);
        this.oldImpuls[phaseNum][i] = this.dynamic ? 1.0 / this.timeStep * oldMeanDensity * nodeLength * Amean : 0.0;
        this.a[i] = Math.max(Fw, 0.0);
        this.c[i] = Math.max(-Fe, 0.0);
        this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) - SP + this.oldImpuls[phaseNum][i];
        this.r[i] = SU + this.oldImpuls[phaseNum][i] * this.oldVelocity[phaseNum][i];
        this.a[this.numberOfNodes - 1] = -this.a[this.numberOfNodes - 1];
        this.c[this.numberOfNodes - 1] = -this.c[this.numberOfNodes - 1];
    }

    public void setEnergyMatrixTDMA(int phaseNum) {
        int i;
        double SU;
        double sign = phaseNum == 0 ? 1.0 : -1.0;
        this.a[0] = 0.0;
        this.b[0] = 1.0;
        this.c[0] = 0.0;
        this.r[0] = SU = this.pipe.getNode(0).getBulkSystem().getPhase(phaseNum).getEnthalpy() / this.pipe.getNode(0).getBulkSystem().getPhase(phaseNum).getNumberOfMolesInPhase() / this.pipe.getNode(0).getBulkSystem().getPhase(phaseNum).getMolarMass();
        for (i = 1; i < this.numberOfNodes - 1; ++i) {
            double fe = this.pipe.getNode(i + 1).getGeometry().getNodeLength() / (this.pipe.getNode(i).getGeometry().getNodeLength() + this.pipe.getNode(i + 1).getGeometry().getNodeLength());
            double fw = this.pipe.getNode(i - 1).getGeometry().getNodeLength() / (this.pipe.getNode(i).getGeometry().getNodeLength() + this.pipe.getNode(i - 1).getGeometry().getNodeLength());
            double Ae = this.pipe.getNode(i).getArea(phaseNum);
            double Aw = this.pipe.getNode(i - 1).getArea(phaseNum);
            double vertposchange = (1.0 - fe) * (this.pipe.getNode(i + 1).getVerticalPositionOfNode() - this.pipe.getNode(i).getVerticalPositionOfNode()) + (1.0 - fw) * (this.pipe.getNode(i).getVerticalPositionOfNode() - this.pipe.getNode(i - 1).getVerticalPositionOfNode());
            SU = -this.pipe.getNode(i).getArea(phaseNum) * 9.80665 * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getDensity() * this.pipe.getNode(i).getVelocity(phaseNum) * vertposchange + this.pipe.getNode(i).getArea(phaseNum) * 4.0 * 0.02 * (278.0 - this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getTemperature()) / this.pipe.getNode(i).getGeometry().getDiameter() * this.pipe.getNode(i).getGeometry().getNodeLength() + sign * this.pipe.getNode(i).getFluidBoundary().getInterphaseHeatFlux(phaseNum) * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getInterphaseContactLength(phaseNum) * (this.pipe.getNode(i).getGeometry().getNodeLength() / this.pipe.getNode(i).getVelocity(phaseNum));
            double SP = 0.0;
            double Fw = Aw * this.pipe.getNode(i - 1).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity() * this.pipe.getNode(i).getVelocityIn(phaseNum).doubleValue();
            double Fe = Ae * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity() * this.pipe.getNode(i).getVelocityOut(phaseNum).doubleValue();
            this.oldEnergy[phaseNum][i] = this.dynamic ? 1.0 / this.timeStep * this.oldDensity[phaseNum][i] * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getArea(phaseNum) : 0.0;
            this.a[i] = Math.max(Fw, 0.0);
            this.c[i] = Math.max(-Fe, 0.0);
            this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) - SP + this.oldEnergy[phaseNum][i];
            this.r[i] = SU + this.oldEnergy[phaseNum][i] * this.oldInternalEnergy[phaseNum][i];
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
        }
        i = this.numberOfNodes - 1;
        double fw = this.pipe.getNode(i - 1).getGeometry().getNodeLength() / (this.pipe.getNode(i).getGeometry().getNodeLength() + this.pipe.getNode(i - 1).getGeometry().getNodeLength());
        double Ae = this.pipe.getNode(i).getArea(phaseNum);
        double Aw = this.pipe.getNode(i - 1).getArea(phaseNum);
        double vertposchange = (1.0 - fw) * (this.pipe.getNode(i).getVerticalPositionOfNode() - this.pipe.getNode(i - 1).getVerticalPositionOfNode());
        SU = -this.pipe.getNode(i).getArea(phaseNum) * 9.80665 * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getDensity() * this.pipe.getNode(i).getVelocity(phaseNum) * vertposchange + this.pipe.getNode(i).getWallContactLength(phaseNum) / this.pipe.getNode(i).getGeometry().getCircumference() * this.pipe.getNode(i).getArea(phaseNum) * 4.0 * 0.02 * (278.0 - this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getTemperature()) / this.pipe.getNode(i).getGeometry().getDiameter() * this.pipe.getNode(i).getGeometry().getNodeLength() + sign * this.pipe.getNode(i).getFluidBoundary().getInterphaseHeatFlux(phaseNum) * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getInterphaseContactLength(phaseNum) * (this.pipe.getNode(i).getGeometry().getNodeLength() / this.pipe.getNode(i).getVelocity(phaseNum));
        double SP = 0.0;
        double Fw = Aw * this.pipe.getNode(i - 1).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity() * this.pipe.getNode(i).getVelocityIn(phaseNum).doubleValue();
        double Fe = Ae * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity() * this.pipe.getNode(i).getVelocity(phaseNum);
        this.oldEnergy[phaseNum][i] = this.dynamic ? 1.0 / this.timeStep * this.oldDensity[phaseNum][i] * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getArea(phaseNum) : 0.0;
        this.a[i] = Math.max(Fw, 0.0);
        this.c[i] = Math.max(-Fe, 0.0);
        this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) - SP + this.oldEnergy[phaseNum][i];
        this.r[i] = SU + this.oldEnergy[phaseNum][i] * this.oldInternalEnergy[phaseNum][i];
        this.a[i] = -this.a[i];
        this.c[i] = -this.c[i];
    }

    public void setComponentConservationMatrix2(int phaseNum, int componentNumber) {
        double SU = 0.0;
        double sign = phaseNum == 0 ? 1.0 : 1.0;
        this.a[0] = 0.0;
        this.b[0] = 1.0;
        this.c[0] = 0.0;
        this.r[0] = SU = this.pipe.getNode(0).getBulkSystem().getPhase(phaseNum).getComponents()[componentNumber].getx();
        for (int i = 1; i < this.numberOfNodes - 1; ++i) {
            double fe = this.pipe.getNode(i + 1).getGeometry().getNodeLength() / (this.pipe.getNode(i).getGeometry().getNodeLength() + this.pipe.getNode(i + 1).getGeometry().getNodeLength());
            double fw = this.pipe.getNode(i - 1).getGeometry().getNodeLength() / (this.pipe.getNode(i).getGeometry().getNodeLength() + this.pipe.getNode(i - 1).getGeometry().getNodeLength());
            double Ae = 1.0 / ((1.0 - fe) / this.pipe.getNode(i).getArea(phaseNum) + fe / this.pipe.getNode(i + 1).getArea(phaseNum));
            double Aw = 1.0 / ((1.0 - fw) / this.pipe.getNode(i).getArea(phaseNum) + fw / this.pipe.getNode(i - 1).getArea(phaseNum));
            double Fe = this.pipe.getNode(i).getVelocityOut(phaseNum).doubleValue() * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity() * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getComponents()[componentNumber].getMolarMass() / this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getMolarMass() * Ae;
            double Fw = this.pipe.getNode(i).getVelocityIn(phaseNum).doubleValue() * this.pipe.getNode(i - 1).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity() * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getComponents()[componentNumber].getMolarMass() / this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getMolarMass() * Aw;
            this.a[i] = Math.max(Fw, 0.0);
            this.c[i] = Math.max(-Fe, 0.0);
            this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) - sign * this.pipe.getNode(i).getArea(phaseNum) * this.pipe.getNode(i).getFluidBoundary().getInterphaseMolarFlux(componentNumber) / this.pipe.getNode(i).getVelocity() * this.pipe.getNode(i).getGeometry().getNodeLength();
            this.r[i] = 0.0;
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
        }
        this.a[this.numberOfNodes - 1] = -1.0;
        this.b[this.numberOfNodes - 1] = 1.0;
        this.c[this.numberOfNodes - 1] = 0.0;
        SU = this.pipe.getNode(this.numberOfNodes - 2).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity() * this.pipe.getNode(this.numberOfNodes - 2).getVelocityIn(phaseNum).doubleValue() * this.pipe.getNode(this.numberOfNodes - 2).getBulkSystem().getPhase(phaseNum).getComponents()[componentNumber].getx() / (this.pipe.getNode(this.numberOfNodes - 1).getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity() * this.pipe.getNode(this.numberOfNodes - 1).getVelocityIn(phaseNum).doubleValue());
        this.r[this.numberOfNodes - 1] = 0.0;
    }

    public void setComponentConservationMatrix(int phaseNum, int componentNumber) {
        int i;
        double sign = phaseNum == 0 ? -1.0 : 1.0;
        double SU = 0.0;
        this.a[0] = 0.0;
        this.b[0] = 1.0;
        this.c[0] = 0.0;
        this.r[0] = SU = this.pipe.getNode(0).getBulkSystem().getPhase(phaseNum).getComponents()[componentNumber].getx() * this.pipe.getNode(0).getBulkSystem().getPhase(phaseNum).getComponents()[componentNumber].getMolarMass() / this.pipe.getNode(0).getBulkSystem().getPhase(phaseNum).getMolarMass();
        for (i = 1; i < this.numberOfNodes - 1; ++i) {
            double Ae = this.pipe.getNode(i).getArea(phaseNum);
            double Aw = this.pipe.getNode(i - 1).getArea(phaseNum);
            double Fe = this.pipe.getNode(i).getVelocityOut(phaseNum).doubleValue() * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getDensity() * Ae;
            double Fw = this.pipe.getNode(i).getVelocityIn(phaseNum).doubleValue() * this.pipe.getNode(i - 1).getBulkSystem().getPhase(phaseNum).getDensity() * Aw;
            this.oldComp[phaseNum][i] = this.dynamic ? 1.0 / this.timeStep * this.pipe.getNode(i).getArea(phaseNum) * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getDensity() : 0.0;
            SU = sign * this.pipe.getNode(i).getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getComponents()[componentNumber].getMolarMass() * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getInterphaseContactLength(phaseNum) * (this.pipe.getNode(i).getGeometry().getNodeLength() / this.pipe.getNode(i).getVelocity(phaseNum));
            this.a[i] = Math.max(Fw, 0.0);
            this.c[i] = Math.max(-Fe, 0.0);
            this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) + this.oldComp[phaseNum][i];
            this.r[i] = SU + this.oldComp[phaseNum][i] * this.oldComposition[phaseNum][componentNumber][i];
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
        }
        i = this.numberOfNodes - 1;
        SU = sign * this.pipe.getNode(i).getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getComponents()[componentNumber].getMolarMass() * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getInterphaseContactLength(phaseNum) * (this.pipe.getNode(i).getGeometry().getNodeLength() / this.pipe.getNode(i).getVelocity(phaseNum));
        this.oldComp[phaseNum][i] = this.dynamic ? 1.0 / this.timeStep * this.pipe.getNode(i).getArea(phaseNum) * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getBulkSystem().getPhase(phaseNum).getDensity() : 0.0;
        this.a[i] = 1.0;
        this.c[i] = 0.0;
        this.b[i] = 1.0;
        this.r[i] = 0.0;
        this.a[i] = -this.a[i];
        this.c[i] = -this.c[i];
    }

    public void initFinalResults(int phase) {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.oldVelocity[phase][i] = this.pipe.getNode(i).getVelocityIn().doubleValue();
            this.oldDensity[phase][i] = this.pipe.getNode(i).getBulkSystem().getPhases()[0].getPhysicalProperties().getDensity();
            this.oldInternalEnergy[phase][i] = this.pipe.getNode(i).getBulkSystem().getPhases()[0].getEnthalpy() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfMolesInPhase() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getMolarMass();
            for (int j = 0; j < this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfComponents(); ++j) {
                this.oldComposition[phase][j][i] = this.xNew[phase][j][i];
            }
        }
    }

    public void calcFluxes() {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).calcFluxes();
        }
    }

    public void initNodes() {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).init();
        }
    }

    @Override
    public void solveTDMA() {
        int iter = 0;
        int iterTop = 0;
        double maxDiff = 1.0E10;
        double diff = 0.0;
        System.out.println("starting...:");
        this.initProfiles();
        this.dn = new double[this.numberOfNodes][this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.xNew = new double[2][this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()][this.numberOfNodes];
        this.initMatrix();
        do {
            double[] d;
            Matrix solOld;
            int phaseNum;
            maxDiff = 0.0;
            ++iterTop;
            iter = 0;
            if (this.solverType >= 5) {
                for (phaseNum = 0; phaseNum < 2; ++phaseNum) {
                    do {
                        ++iter;
                        this.setImpulsMatrixTDMA(phaseNum);
                        solOld = this.solMatrix[phaseNum].copy();
                        d = TDMAsolve.solve(this.a, this.b, this.c, this.r);
                        this.solMatrix[phaseNum] = new Matrix(d, 1).transpose();
                        this.solMatrix[phaseNum].print(10, 10);
                        this.diffMatrix = this.solMatrix[phaseNum].minus(solOld);
                        diff = Math.abs(this.diffMatrix.norm1() / this.solMatrix[phaseNum].norm1());
                        if (diff > maxDiff) {
                            maxDiff = diff;
                        }
                        this.initVelocity(phaseNum);
                    } while (diff > 1.0E-10 && iter < 100);
                }
            }
            iter = 0;
            if (this.solverType >= 5) {
                for (phaseNum = 1; phaseNum < 2; ++phaseNum) {
                    do {
                        ++iter;
                        this.setPhaseFractionMatrix(phaseNum);
                        solOld = this.solPhaseConsMatrix[phaseNum].copy();
                        d = TDMAsolve.solve(this.a, this.b, this.c, this.r);
                        this.solPhaseConsMatrix[phaseNum] = new Matrix(d, 1).transpose();
                        this.diffMatrix = this.solPhaseConsMatrix[phaseNum].minus(solOld);
                        diff = Math.abs(this.diffMatrix.norm1() / this.solPhaseConsMatrix[phaseNum].norm1());
                        if (diff > maxDiff) {
                            maxDiff = diff;
                        }
                        this.initPhaseFraction(phaseNum);
                    } while (diff > 1.0E-15 && iter < 100);
                }
                int phase = 0;
                do {
                    ++iter;
                    this.setMassConservationMatrix(phase);
                    solOld = this.solPhaseConsMatrix[phase].copy();
                    d = TDMAsolve.solve(this.a, this.b, this.c, this.r);
                    this.solPhaseConsMatrix[phase] = new Matrix(d, 1).transpose();
                    this.diffMatrix = this.solPhaseConsMatrix[phase].minus(solOld);
                    diff = Math.abs(this.diffMatrix.norm1() / this.solPhaseConsMatrix[phase].norm1());
                    if (diff > maxDiff) {
                        maxDiff = diff;
                    }
                    this.initPressure(phase);
                } while (diff > 1.0E-15 && iter < 100);
            }
            if (this.solverType >= 5) {
                for (phaseNum = 0; phaseNum < 2; ++phaseNum) {
                    iter = 0;
                    do {
                        ++iter;
                        Matrix sol3Old = this.sol3Matrix[phaseNum].copy();
                        this.setEnergyMatrixTDMA(phaseNum);
                        d = TDMAsolve.solve(this.a, this.b, this.c, this.r);
                        this.sol3Matrix[phaseNum] = new Matrix(d, 1).transpose();
                        this.diffMatrix = this.sol3Matrix[phaseNum].minus(sol3Old);
                        diff = Math.abs(this.diffMatrix.norm1() / this.sol3Matrix[phaseNum].norm1());
                        if (diff > maxDiff) {
                            maxDiff = diff;
                        }
                        this.initTemperature(phaseNum);
                    } while (diff > 1.0E-15 && iter < 100);
                }
            }
            if (this.solverType >= 5) {
                double compDiff = 0.0;
                int compIter = 0;
                do {
                    this.calcFluxes();
                    ++compIter;
                    for (int phaseNum2 = 0; phaseNum2 < 2; ++phaseNum2) {
                        iter = 0;
                        for (int p = 0; p < this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents() - 1; ++p) {
                            do {
                                ++iter;
                                this.setComponentConservationMatrix(phaseNum2, p);
                                Matrix solOld2 = this.solMolFracMatrix[phaseNum2][p].copy();
                                this.xNew[phaseNum2][p] = TDMAsolve.solve(this.a, this.b, this.c, this.r);
                                this.solMolFracMatrix[phaseNum2][p] = new Matrix(this.xNew[phaseNum2][p], 1).transpose();
                                this.diffMatrix = this.solMolFracMatrix[phaseNum2][p].minus(solOld2);
                                diff = Math.abs(this.diffMatrix.norm2() / this.solMolFracMatrix[phaseNum2][p].norm2());
                                if (diff > maxDiff) {
                                    maxDiff = diff;
                                }
                                if (diff > compDiff) {
                                    compDiff = diff;
                                }
                                System.out.println("diff molfrac: " + this.diffMatrix.norm2() / this.solMolFracMatrix[phaseNum2][p].norm2());
                                this.initComposition(phaseNum2, p);
                            } while (diff > 1.0E-12 && iter < 10);
                        }
                    }
                } while (compDiff > 1.0E-10 && compIter < 10);
                this.initNodes();
            }
            System.out.println("iter: " + iterTop + " maxdiff " + maxDiff);
        } while (Math.abs(maxDiff) > 1.0E-7 && iterTop < 1);
        for (int phaseNum = 0; phaseNum < 2; ++phaseNum) {
            for (int p = 0; p < this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents() - 1; ++p) {
                Matrix dmat = new Matrix(this.xNew[phaseNum][p], 1);
                dmat.print(10, 10);
            }
        }
    }
}

