/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties;

import java.io.Serializable;
import neqsim.physicalproperties.mixingrule.PhysicalPropertyMixingRule;
import neqsim.physicalproperties.system.PhysicalProperties;
import neqsim.physicalproperties.system.PhysicalPropertyModel;
import neqsim.physicalproperties.system.commonphasephysicalproperties.DefaultPhysicalProperties;
import neqsim.physicalproperties.system.gasphysicalproperties.GasPhysicalProperties;
import neqsim.physicalproperties.system.liquidphysicalproperties.AminePhysicalProperties;
import neqsim.physicalproperties.system.liquidphysicalproperties.CO2waterPhysicalProperties;
import neqsim.physicalproperties.system.liquidphysicalproperties.GlycolPhysicalProperties;
import neqsim.physicalproperties.system.liquidphysicalproperties.LiquidPhysicalProperties;
import neqsim.physicalproperties.system.liquidphysicalproperties.WaterPhysicalProperties;
import neqsim.physicalproperties.system.solidphysicalproperties.SolidPhysicalProperties;
import neqsim.thermo.phase.PhaseInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhysicalPropertyHandler
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PhysicalPropertyHandler.class);
    private PhysicalProperties gasPhysicalProperties = null;
    private PhysicalProperties oilPhysicalProperties = null;
    private PhysicalProperties aqueousPhysicalProperties = null;
    private PhysicalProperties solidPhysicalProperties = null;
    private PhysicalPropertyMixingRule mixingRule = null;

    public void setPhysicalProperties(PhaseInterface phase, PhysicalPropertyModel ppm) {
        switch (ppm) {
            case DEFAULT: {
                this.gasPhysicalProperties = new GasPhysicalProperties(phase, 0, 0);
                this.oilPhysicalProperties = new LiquidPhysicalProperties(phase, 0, 0);
                this.aqueousPhysicalProperties = new WaterPhysicalProperties(phase, 0, 0);
                break;
            }
            case WATER: {
                this.gasPhysicalProperties = new GasPhysicalProperties(phase, 0, 0);
                this.oilPhysicalProperties = new LiquidPhysicalProperties(phase, 0, 0);
                this.aqueousPhysicalProperties = new WaterPhysicalProperties(phase, 0, 0);
                break;
            }
            case GLYCOL: {
                this.gasPhysicalProperties = new GasPhysicalProperties(phase, 0, 0);
                this.oilPhysicalProperties = new LiquidPhysicalProperties(phase, 0, 0);
                this.aqueousPhysicalProperties = new GlycolPhysicalProperties(phase, 0, 0);
                break;
            }
            case AMINE: {
                this.gasPhysicalProperties = new GasPhysicalProperties(phase, 0, 0);
                this.oilPhysicalProperties = new LiquidPhysicalProperties(phase, 0, 0);
                this.aqueousPhysicalProperties = new AminePhysicalProperties(phase, 0, 0);
                break;
            }
            case CO2WATER: {
                this.gasPhysicalProperties = new GasPhysicalProperties(phase, 0, 0);
                this.oilPhysicalProperties = new LiquidPhysicalProperties(phase, 0, 0);
                this.aqueousPhysicalProperties = new CO2waterPhysicalProperties(phase, 0, 0);
                break;
            }
            case BASIC: {
                this.gasPhysicalProperties = new DefaultPhysicalProperties(phase, 0, 0);
                this.oilPhysicalProperties = new DefaultPhysicalProperties(phase, 0, 0);
                this.aqueousPhysicalProperties = new DefaultPhysicalProperties(phase, 0, 0);
                break;
            }
            default: {
                logger.error("error selecting physical properties model.\n Continue using default model...");
                this.setPhysicalProperties(phase, PhysicalPropertyModel.DEFAULT);
            }
        }
        this.solidPhysicalProperties = new SolidPhysicalProperties(phase);
        this.mixingRule = new PhysicalPropertyMixingRule();
        this.mixingRule.initMixingRules(phase);
        this.gasPhysicalProperties.setMixingRule(this.mixingRule);
        this.oilPhysicalProperties.setMixingRule(this.mixingRule);
        this.aqueousPhysicalProperties.setMixingRule(this.mixingRule);
    }

    public PhysicalProperties getPhysicalProperties(PhaseInterface phase) {
        switch (phase.getType()) {
            case GAS: {
                return this.gasPhysicalProperties;
            }
            case LIQUID: 
            case OIL: {
                return this.oilPhysicalProperties;
            }
            case AQUEOUS: {
                return this.aqueousPhysicalProperties;
            }
            case WAX: 
            case HYDRATE: 
            case SOLID: 
            case SOLIDCOMPLEX: {
                return this.solidPhysicalProperties;
            }
        }
        return this.gasPhysicalProperties;
    }

    public PhysicalPropertyHandler clone() {
        PhysicalPropertyHandler clonedHandler = null;
        try {
            clonedHandler = (PhysicalPropertyHandler)super.clone();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        try {
            if (this.gasPhysicalProperties != null) {
                clonedHandler.gasPhysicalProperties = this.gasPhysicalProperties.clone();
            }
            if (this.oilPhysicalProperties != null) {
                clonedHandler.oilPhysicalProperties = this.oilPhysicalProperties.clone();
            }
            if (this.aqueousPhysicalProperties != null) {
                clonedHandler.aqueousPhysicalProperties = this.aqueousPhysicalProperties.clone();
            }
            if (this.solidPhysicalProperties != null) {
                clonedHandler.solidPhysicalProperties = this.solidPhysicalProperties.clone();
            }
            if (this.mixingRule != null) {
                clonedHandler.mixingRule = this.mixingRule.clone();
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return clonedHandler;
    }
}

