/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.interfaceproperties.surfacetension;

import neqsim.physicalproperties.interfaceproperties.surfacetension.SurfaceTension;
import neqsim.thermo.system.SystemInterface;

public class ParachorSurfaceTension
extends SurfaceTension {
    private static final long serialVersionUID = 1000L;

    public ParachorSurfaceTension() {
    }

    public ParachorSurfaceTension(SystemInterface system) {
        super(system);
    }

    @Override
    public double calcPureComponentSurfaceTension(int componentNumber) {
        return 0.001 * Math.pow(this.system.getPhases()[0].getComponents()[componentNumber].getParachorParameter() * 1.0E-6 * (this.system.getPhases()[1].getPhysicalProperties().getDensity() / this.system.getPhases()[1].getMolarMass() * this.system.getPhases()[1].getComponents()[componentNumber].getx() - this.system.getPhases()[0].getPhysicalProperties().getDensity() / this.system.getPhases()[0].getMolarMass() * this.system.getPhases()[0].getComponents()[componentNumber].getx()), 4.0);
    }

    @Override
    public double calcSurfaceTension(int interface1, int interface2) {
        double temp = 0.0;
        if (this.system.getNumberOfPhases() < 2) {
            return 0.0;
        }
        try {
            for (int i = 0; i < this.system.getPhases()[0].getNumberOfComponents(); ++i) {
                temp += this.system.getPhase(interface1).getComponent(i).getParachorParameter() * 1.0E-6 * (this.system.getPhase(interface2).getPhysicalProperties().getDensity() / this.system.getPhase(interface2).getMolarMass() * this.system.getPhase(interface2).getComponent(i).getx() - this.system.getPhase(interface1).getPhysicalProperties().getDensity() / this.system.getPhase(interface1).getMolarMass() * this.system.getPhase(interface1).getComponent(i).getx());
            }
        }
        catch (Exception ex) {
            temp = 0.0;
        }
        return Math.pow(temp, 4.0) / 1000.0;
    }
}

