/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.commonphasephysicalproperties.diffusivity;

import neqsim.physicalproperties.methods.commonphasephysicalproperties.diffusivity.Diffusivity;
import neqsim.physicalproperties.system.PhysicalProperties;
import neqsim.thermo.phase.PhaseType;

public class CorrespondingStatesDiffusivity
extends Diffusivity {
    private static final long serialVersionUID = 1000L;
    double[][] binaryDiffusionCoefficients;
    double[][] binaryLennardJonesOmega;

    public CorrespondingStatesDiffusivity(PhysicalProperties phase) {
        super(phase);
        this.binaryDiffusionCoefficients = new double[phase.getPhase().getNumberOfComponents()][phase.getPhase().getNumberOfComponents()];
    }

    @Override
    public double calcBinaryDiffusionCoefficient(int i, int j, int method) {
        if (this.phase.getPhase().getType() == PhaseType.LIQUID) {
            this.binaryDiffusionCoefficients[i][j] = 9.890000000000001E-12 * Math.pow(this.phase.getViscosity() * 1000.0, -0.907) * Math.pow(1.0 / this.phase.getPhase().getComponent(i).getNormalLiquidDensity() * this.phase.getPhase().getComponent(i).getMolarMass() * 1000.0, -0.45) * Math.pow(1.0 / this.phase.getPhase().getComponent(j).getNormalLiquidDensity() * this.phase.getPhase().getComponent(j).getMolarMass() * 1000.0, 0.265) * this.phase.getPhase().getTemperature();
            return this.binaryDiffusionCoefficients[i][j];
        }
        this.binaryDiffusionCoefficients[i][j] = 1.8E-5 / this.phase.getPhase().getPressure();
        return this.binaryDiffusionCoefficients[i][j];
    }
}

