/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.liquidphysicalproperties.viscosity;

import neqsim.physicalproperties.methods.liquidphysicalproperties.LiquidPhysicalPropertyMethod;
import neqsim.physicalproperties.methods.methodinterface.ViscosityInterface;
import neqsim.physicalproperties.system.PhysicalProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Viscosity
extends LiquidPhysicalPropertyMethod
implements ViscosityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Viscosity.class);
    public double[] pureComponentViscosity;

    public Viscosity(PhysicalProperties liquidPhase) {
        super(liquidPhase);
        this.pureComponentViscosity = new double[liquidPhase.getPhase().getNumberOfComponents()];
    }

    @Override
    public Viscosity clone() {
        Viscosity properties = null;
        try {
            properties = (Viscosity)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return properties;
    }

    @Override
    public double calcViscosity() {
        int i;
        double tempVar = 0.0;
        double tempVar2 = 0.0;
        this.calcPureComponentViscosity();
        for (i = 0; i < this.liquidPhase.getPhase().getNumberOfComponents(); ++i) {
            tempVar += this.liquidPhase.getPhase().getWtFrac(i) * Math.log(this.pureComponentViscosity[i]);
        }
        tempVar2 = 0.0;
        for (i = 0; i < this.liquidPhase.getPhase().getNumberOfComponents(); ++i) {
            double wigthFraci = this.liquidPhase.getPhase().getWtFrac(i);
            for (int j = 0; j < this.liquidPhase.getPhase().getNumberOfComponents(); ++j) {
                double wigthFracj = this.liquidPhase.getPhase().getWtFrac(j);
                if (i == j) continue;
                tempVar2 += wigthFraci * wigthFracj * this.liquidPhase.getMixingRule().getViscosityGij(i, j);
            }
        }
        double viscosity = Math.exp(tempVar + tempVar2) / 1000.0;
        return viscosity;
    }

    public void calcPureComponentViscosity() {
        this.pureComponentViscosity = new double[this.liquidPhase.getPhase().getNumberOfComponents()];
        for (int i = 0; i < this.liquidPhase.getPhase().getNumberOfComponents(); ++i) {
            this.pureComponentViscosity[i] = this.liquidPhase.getPhase().getTemperature() > this.liquidPhase.getPhase().getComponent(i).getTC() ? 0.5 : (this.liquidPhase.getPhase().getComponent(i).getLiquidViscosityModel() == 1 ? this.liquidPhase.getPhase().getComponent(i).getLiquidViscosityParameter(0) * Math.pow(this.liquidPhase.getPhase().getTemperature(), this.liquidPhase.getPhase().getComponent(i).getLiquidViscosityParameter(1)) : (this.liquidPhase.getPhase().getComponent(i).getLiquidViscosityModel() == 2 ? Math.exp(this.liquidPhase.getPhase().getComponent(i).getLiquidViscosityParameter(0) + this.liquidPhase.getPhase().getComponent(i).getLiquidViscosityParameter(1) / this.liquidPhase.getPhase().getTemperature()) : (this.liquidPhase.getPhase().getComponent(i).getLiquidViscosityModel() == 3 ? Math.exp(this.liquidPhase.getPhase().getComponent(i).getLiquidViscosityParameter(0) + this.liquidPhase.getPhase().getComponent(i).getLiquidViscosityParameter(1) / this.liquidPhase.getPhase().getTemperature() + this.liquidPhase.getPhase().getComponent(i).getLiquidViscosityParameter(2) * this.liquidPhase.getPhase().getTemperature() + this.liquidPhase.getPhase().getComponent(i).getLiquidViscosityParameter(3) * Math.pow(this.liquidPhase.getPhase().getTemperature(), 2.0)) : (this.liquidPhase.getPhase().getComponent(i).getLiquidViscosityModel() == 4 ? Math.pow(10.0, this.liquidPhase.getPhase().getComponent(i).getLiquidViscosityParameter(0) * (1.0 / this.liquidPhase.getPhase().getTemperature() - 1.0 / this.liquidPhase.getPhase().getComponent(i).getLiquidViscosityParameter(1))) : 0.7))));
            int n = i;
            this.pureComponentViscosity[n] = this.pureComponentViscosity[n] * ((this.getViscosityPressureCorrection(i) + 1.0) / 2.0);
        }
    }

    @Override
    public double getPureComponentViscosity(int i) {
        return this.pureComponentViscosity[i];
    }

    public double getViscosityPressureCorrection(int i) {
        double TR = this.liquidPhase.getPhase().getTemperature() / this.liquidPhase.getPhase().getComponent(i).getTC();
        if (TR > 1.0) {
            return 1.0;
        }
        double deltaPr = (this.liquidPhase.getPhase().getPressure() - 0.0) / this.liquidPhase.getPhase().getComponent(i).getPC();
        double A = 0.9991 - 4.674000000000001E-4 / (1.0523 * Math.pow(TR, -0.03877) - 1.0513);
        double D = 0.3257 / Math.pow(1.0039 - Math.pow(TR, 2.573), 0.2906) - 0.2086;
        double C = -0.07921 + 2.1616 * TR - 13.404 * TR * TR + 44.1706 * Math.pow(TR, 3.0) - 84.8291 * Math.pow(TR, 4.0) + 96.1209 * Math.pow(TR, 5.0) - 59.8127 * Math.pow(TR, 6.0) + 15.6719 * Math.pow(TR, 7.0);
        return (1.0 + D * Math.pow(deltaPr / 2.118, A)) / (1.0 + C * this.liquidPhase.getPhase().getComponent(i).getAcentricFactor() * deltaPr);
    }
}

