/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment;

import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.TwoPortInterface;
import neqsim.process.equipment.stream.StreamInterface;

public abstract class TwoPortEquipment
extends ProcessEquipmentBaseClass
implements TwoPortInterface {
    private static final long serialVersionUID = 1000L;
    protected StreamInterface inStream;
    protected StreamInterface outStream;

    public TwoPortEquipment(String name) {
        super(name);
    }

    public TwoPortEquipment(String name, StreamInterface stream) {
        this(name);
        this.setInletStream(stream);
    }

    @Override
    public double getInletPressure() {
        return this.getInletStream().getPressure();
    }

    @Override
    public StreamInterface getInletStream() {
        return this.inStream;
    }

    @Override
    public double getInletTemperature() {
        return this.getInletStream().getTemperature();
    }

    @Override
    public double getOutletPressure() {
        return this.getOutletStream().getPressure();
    }

    @Override
    public StreamInterface getOutletStream() {
        return this.outStream;
    }

    @Override
    public double getOutletTemperature() {
        return this.getOutletStream().getTemperature();
    }

    @Override
    public void setInletPressure(double pressure) {
        this.inStream.setPressure(pressure);
    }

    @Override
    public void setInletStream(StreamInterface stream) {
        this.inStream = stream;
        this.outStream = this.inStream.clone(this.getName() + " out stream");
    }

    @Override
    public void setInletTemperature(double temperature) {
        this.inStream.setTemperature(temperature, "unit");
    }

    @Override
    public void setOutletPressure(double pressure) {
        this.outStream.setPressure(pressure);
    }

    @Override
    public void setOutletStream(StreamInterface stream) {
        this.outStream = stream;
    }

    @Override
    public void setOutletTemperature(double temperature) {
        this.outStream.setTemperature(temperature, "unit");
    }

    @Override
    public String toJson() {
        return null;
    }
}

