/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.compressor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import neqsim.process.equipment.compressor.CompressorChartAlternativeMapLookupExtrapolate;
import neqsim.process.equipment.compressor.CompressorCurve;
import neqsim.process.equipment.compressor.SafeSplineStoneWallCurve;
import neqsim.process.equipment.compressor.SafeSplineSurgeCurve;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompressorChartKhader2015
extends CompressorChartAlternativeMapLookupExtrapolate {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(CompressorChartKhader2015.class);
    SystemInterface fluid = null;
    SystemInterface ref_fluid = null;
    StreamInterface stream = null;
    private double impellerOuterDiameter = 0.3;
    List<RealCurve> realCurves = new ArrayList<RealCurve>();

    public CompressorChartKhader2015(SystemInterface fluid, double impellerdiam) {
        this.fluid = fluid;
        this.impellerOuterDiameter = impellerdiam;
    }

    public CompressorChartKhader2015(SystemInterface fluid, SystemInterface referenceFluid, double impellerdiam) {
        this.fluid = fluid;
        this.ref_fluid = referenceFluid;
        this.impellerOuterDiameter = impellerdiam;
    }

    public CompressorChartKhader2015(StreamInterface stream, double impellerdiam) {
        this.stream = stream;
        this.impellerOuterDiameter = impellerdiam;
    }

    @Override
    public void setCurves(double[] chartConditions, double[] speed, double[][] flow, double[][] head, double[][] flowPolyEff, double[][] polyEff) {
        if (this.fluid == null && this.stream != null) {
            this.fluid = this.stream.getFluid();
        }
        if (this.ref_fluid == null) {
            this.ref_fluid = this.createDefaultFluid(chartConditions);
        }
        this.ref_fluid.setTemperature(chartConditions[0], "C");
        this.ref_fluid.setPressure(chartConditions[1], "bara");
        ThermodynamicOperations ops = new ThermodynamicOperations(this.ref_fluid);
        ops.TPflash();
        this.ref_fluid.initThermoProperties();
        double fluidSoundSpeed = this.ref_fluid.getPhase(0).getSoundSpeed();
        for (int i = 0; i < speed.length; ++i) {
            double[] machNumberCorrectedHeadFactor = new double[flow[i].length];
            double[] machNumberCorrectedFlowFactor = new double[flow[i].length];
            double[] machNumberCorrectedFlowFactorEfficiency = new double[flow[i].length];
            double[] polEff = new double[flow[i].length];
            for (int j = 0; j < flow[i].length; ++j) {
                machNumberCorrectedHeadFactor[j] = head[i][j] / fluidSoundSpeed / fluidSoundSpeed;
                machNumberCorrectedFlowFactor[j] = flow[i][j] / 3600.0 / fluidSoundSpeed / this.impellerOuterDiameter / this.impellerOuterDiameter;
                machNumberCorrectedFlowFactorEfficiency[j] = flowPolyEff[i][j] / fluidSoundSpeed / this.impellerOuterDiameter / this.impellerOuterDiameter;
                polEff[j] = polyEff[i][j];
            }
            double machineMachNumber = speed[i] / 60.0 * this.impellerOuterDiameter / fluidSoundSpeed;
            CompressorCurve curve = new CompressorCurve(machineMachNumber, machNumberCorrectedFlowFactor, machNumberCorrectedHeadFactor, machNumberCorrectedFlowFactorEfficiency, polEff);
            this.chartValues.add(curve);
            this.chartSpeeds.add(speed[i]);
        }
        this.generateRealCurvesForFluid();
        this.setUseCompressorChart(true);
    }

    public List<CorrectedCurve> getCorrectedCurves(double[] chartConditions, double[] speed, double[][] flow, double[][] head, double[][] flowPolyEff, double[][] polyEff) {
        if (this.ref_fluid == null) {
            this.ref_fluid = this.createDefaultFluid(chartConditions);
        }
        this.ref_fluid.setTemperature(chartConditions[0], "C");
        this.ref_fluid.setPressure(chartConditions[1], "bara");
        ThermodynamicOperations ops = new ThermodynamicOperations(this.ref_fluid);
        ops.TPflash();
        this.ref_fluid.initThermoProperties();
        double fluidSoundSpeed = this.ref_fluid.getPhase(0).getSoundSpeed();
        ArrayList<CorrectedCurve> correctedCurves = new ArrayList<CorrectedCurve>();
        for (int i = 0; i < speed.length; ++i) {
            double[] machNumberCorrectedHeadFactor = new double[flow[i].length];
            double[] machNumberCorrectedFlowFactor = new double[flow[i].length];
            double[] machNumberCorrectedFlowFactorEfficiency = new double[flow[i].length];
            double[] polEff = new double[flow[i].length];
            for (int j = 0; j < flow[i].length; ++j) {
                machNumberCorrectedHeadFactor[j] = head[i][j] / fluidSoundSpeed / fluidSoundSpeed;
                machNumberCorrectedFlowFactor[j] = flow[i][j] / 3600.0 / fluidSoundSpeed / this.impellerOuterDiameter / this.impellerOuterDiameter;
                machNumberCorrectedFlowFactorEfficiency[j] = flowPolyEff[i][j] / fluidSoundSpeed / this.impellerOuterDiameter / this.impellerOuterDiameter;
                polEff[j] = polyEff[i][j];
            }
            double machineMachNumber = speed[i] / 60.0 * this.impellerOuterDiameter / fluidSoundSpeed;
            correctedCurves.add(new CorrectedCurve(machineMachNumber, machNumberCorrectedFlowFactor, machNumberCorrectedHeadFactor, machNumberCorrectedFlowFactorEfficiency, polEff));
        }
        return correctedCurves;
    }

    public void generateRealCurvesForFluid() {
        double fluidSoundSpeed = this.fluid.getSoundSpeed();
        this.realCurves = new ArrayList<RealCurve>();
        for (int i = 0; i < this.chartValues.size(); ++i) {
            CompressorCurve corr = (CompressorCurve)this.chartValues.get(i);
            double[] flow = new double[corr.flow.length];
            double[] head = new double[corr.head.length];
            double[] flowPolyEff = new double[corr.flowPolytropicEfficiency.length];
            double[] polEff = new double[corr.polytropicEfficiency.length];
            for (int j = 0; j < flow.length; ++j) {
                flow[j] = 3600.0 * corr.flow[j] * fluidSoundSpeed * this.impellerOuterDiameter * this.impellerOuterDiameter;
                head[j] = corr.head[j] * fluidSoundSpeed * fluidSoundSpeed;
                flowPolyEff[j] = 3600.0 * corr.flowPolytropicEfficiency[j] * fluidSoundSpeed * this.impellerOuterDiameter * this.impellerOuterDiameter;
                polEff[j] = corr.polytropicEfficiency[j];
            }
            this.realCurves.add(new RealCurve((Double)this.chartSpeeds.get(i), flow, head, flowPolyEff, polEff));
        }
        if (this.chartValues.size() > 1) {
            this.generateSurgeCurve();
            this.generateStoneWallCurve();
        }
    }

    public void prettyPrintRealCurvesForFluid() {
        System.out.println("All RealCurve objects for current fluid:");
        for (RealCurve curve : this.realCurves) {
            System.out.println("RealCurve:");
            System.out.println("  Speed: " + curve.speed);
            System.out.println("  Flow: " + Arrays.toString(curve.flow));
            System.out.println("  Head: " + Arrays.toString(curve.head));
            System.out.println("  Flow Poly Eff: " + Arrays.toString(curve.flowPolyEff));
            System.out.println("  Polytropic Efficiency: " + Arrays.toString(curve.polytropicEfficiency));
        }
    }

    private SystemInterface createDefaultFluid(double[] chartConditions) {
        double methaneFrac = 0.9;
        double ethaneFrac = 0.05;
        double propaneFrac = 0.05;
        double targetMolWeight = chartConditions.length > 3 ? chartConditions[3] : -1.0;
        double mwMethane = 16.043;
        double mwEthane = 30.07;
        double mwPropane = 44.097;
        double x1 = methaneFrac;
        double x2 = ethaneFrac;
        double x3 = 1.0 - x1 - x2;
        if (targetMolWeight > 0.0) {
            double a = (targetMolWeight - mwPropane) / (methaneFrac * (mwMethane - mwPropane) + ethaneFrac * (mwEthane - mwPropane));
            x1 = a * methaneFrac;
            x2 = a * ethaneFrac;
            x3 = 1.0 - x1 - x2;
            if (x3 < 0.0 || x3 > 1.0) {
                logger.warn("Target molecular weight not achievable with given component ratios.");
                x3 = Math.max(0.0, Math.min(1.0, x3));
                double total = x1 + x2 + x3;
                x1 /= total;
                x2 /= total;
                x3 /= total;
            }
            methaneFrac = x1;
            ethaneFrac = x2;
            propaneFrac = x3;
        }
        SystemInterface localfluid = null;
        try {
            localfluid = (SystemInterface)this.fluid.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.error("Error creating fluid instance: ", (Throwable)e);
            throw new RuntimeException("Failed to create fluid instance", e);
        }
        localfluid.addComponent("methane", methaneFrac);
        localfluid.addComponent("ethane", ethaneFrac);
        localfluid.addComponent("propane", propaneFrac);
        localfluid.setMixingRule("classic");
        localfluid.init(0);
        localfluid.setTemperature(chartConditions[0], "C");
        localfluid.setPressure(chartConditions[1], "bara");
        ThermodynamicOperations ops = new ThermodynamicOperations(localfluid);
        ops.TPflash();
        localfluid.initThermoProperties();
        return localfluid;
    }

    @Override
    public double getPolytropicHead(double flow, double speed) {
        if (this.fluid == null) {
            this.fluid = this.stream.getFluid();
        }
        double machNumberCorrectedFlowFactor = flow / 3600.0 / this.fluid.getSoundSpeed() / this.impellerOuterDiameter / this.impellerOuterDiameter;
        double machineMachNumber = speed / 60.0 * this.impellerOuterDiameter / this.fluid.getSoundSpeed();
        return super.getPolytropicHead(machNumberCorrectedFlowFactor, machineMachNumber) * this.fluid.getSoundSpeed() * this.fluid.getSoundSpeed();
    }

    @Override
    public double getPolytropicEfficiency(double flow, double speed) {
        if (this.fluid == null) {
            this.fluid = this.stream.getFluid();
        }
        double machNumberCorrectedFlowFactor = flow / 3600.0 / this.fluid.getSoundSpeed() / this.impellerOuterDiameter / this.impellerOuterDiameter;
        double machineMachNumber = speed / 60.0 * this.impellerOuterDiameter / this.fluid.getSoundSpeed();
        return super.getPolytropicEfficiency(machNumberCorrectedFlowFactor, machineMachNumber);
    }

    public double getImpellerOuterDiameter() {
        return this.impellerOuterDiameter;
    }

    public void setImpellerOuterDiameter(double impellerOuterDiameter) {
        this.impellerOuterDiameter = impellerOuterDiameter;
    }

    public SystemInterface getReferenceFluid() {
        return this.ref_fluid;
    }

    public void setReferenceFluid(SystemInterface ref_fluid) {
        this.ref_fluid = ref_fluid;
    }

    @Override
    public void generateSurgeCurve() {
        TreeMap<Double, Double> uniqueSurgePoints = new TreeMap<Double, Double>();
        for (RealCurve curve : this.getRealCurves()) {
            int minFlowIdx = 0;
            double minFlow = curve.flow[0];
            for (int i = 1; i < curve.flow.length; ++i) {
                if (!(curve.flow[i] < minFlow)) continue;
                minFlow = curve.flow[i];
                minFlowIdx = i;
            }
            double flowVal = curve.flow[minFlowIdx];
            double headVal = curve.head[minFlowIdx];
            if (uniqueSurgePoints.containsKey(flowVal)) continue;
            uniqueSurgePoints.put(flowVal, headVal);
        }
        double[] surgeFlow = new double[uniqueSurgePoints.size()];
        double[] surgeHead = new double[uniqueSurgePoints.size()];
        int idx = 0;
        for (Map.Entry entry : uniqueSurgePoints.entrySet()) {
            surgeFlow[idx] = (Double)entry.getKey();
            surgeHead[idx] = (Double)entry.getValue();
            ++idx;
        }
        this.setSurgeCurve(new SafeSplineSurgeCurve(surgeFlow, surgeHead));
    }

    @Override
    public void generateStoneWallCurve() {
        TreeMap<Double, Double> uniqueStoneWallPoints = new TreeMap<Double, Double>();
        for (RealCurve curve : this.getRealCurves()) {
            int maxFlowIdx = 0;
            double maxFlow = curve.flow[0];
            for (int i = 1; i < curve.flow.length; ++i) {
                if (!(curve.flow[i] > maxFlow)) continue;
                maxFlow = curve.flow[i];
                maxFlowIdx = i;
            }
            double flowVal = curve.flow[maxFlowIdx];
            double headVal = curve.head[maxFlowIdx];
            if (uniqueStoneWallPoints.containsKey(flowVal)) continue;
            uniqueStoneWallPoints.put(flowVal, headVal);
        }
        double[] stoneFlow = new double[uniqueStoneWallPoints.size()];
        double[] stoneHead = new double[uniqueStoneWallPoints.size()];
        int idx = 0;
        for (Map.Entry entry : uniqueStoneWallPoints.entrySet()) {
            stoneFlow[idx] = (Double)entry.getKey();
            stoneHead[idx] = (Double)entry.getValue();
            ++idx;
        }
        this.setStoneWallCurve(new SafeSplineStoneWallCurve(stoneFlow, stoneHead));
    }

    public List<RealCurve> getRealCurves() {
        return this.realCurves;
    }

    public static class CorrectedCurve {
        public final double machineMachNumber;
        public final double[] correctedFlowFactor;
        public final double[] correctedHeadFactor;
        public final double[] correctedFlowFactorEfficiency;
        public final double[] polytropicEfficiency;

        public CorrectedCurve(double machineMachNumber, double[] correctedFlowFactor, double[] correctedHeadFactor, double[] correctedFlowFactorEfficiency, double[] polytropicEfficiency) {
            this.machineMachNumber = machineMachNumber;
            this.correctedFlowFactor = correctedFlowFactor;
            this.correctedHeadFactor = correctedHeadFactor;
            this.correctedFlowFactorEfficiency = correctedFlowFactorEfficiency;
            this.polytropicEfficiency = polytropicEfficiency;
        }
    }

    public static class RealCurve {
        public final double speed;
        public final double[] flow;
        public final double[] head;
        public final double[] flowPolyEff;
        public final double[] polytropicEfficiency;

        public RealCurve(double speed, double[] flow, double[] head, double[] flowPolyEff, double[] polytropicEfficiency) {
            this.speed = speed;
            this.flow = flow;
            this.head = head;
            this.flowPolyEff = flowPolyEff;
            this.polytropicEfficiency = polytropicEfficiency;
        }
    }
}

