/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.compressor;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import neqsim.process.equipment.compressor.SurgeCurve;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SafeSplineSurgeCurve
extends SurgeCurve {
    private static final long serialVersionUID = 1001L;
    static Logger logger = LogManager.getLogger(SafeSplineSurgeCurve.class);
    private double[] sortedHead;
    private double[] sortedFlow;
    private transient UnivariateFunction headFromFlow;
    private transient UnivariateFunction flowFromHead;

    public SafeSplineSurgeCurve() {
    }

    public SafeSplineSurgeCurve(double[] flow, double[] head) {
        this.setCurve(null, flow, head);
    }

    public double[] getSortedHead() {
        return this.sortedHead;
    }

    public double[] getSortedFlow() {
        return this.sortedFlow;
    }

    @Override
    public void setCurve(double[] chartConditions, double[] flow, double[] head) {
        int i;
        if (flow.length != head.length || flow.length < 2) {
            throw new IllegalArgumentException("Flow and head arrays must have the same length and at least 2 points.");
        }
        int n = flow.length;
        Double[][] flowHeadPairs = new Double[n][2];
        for (i = 0; i < n; ++i) {
            flowHeadPairs[i][0] = flow[i];
            flowHeadPairs[i][1] = head[i];
        }
        Arrays.sort(flowHeadPairs, Comparator.comparingDouble(p -> p[0]));
        this.flow = new double[n];
        this.head = new double[n];
        for (i = 0; i < n; ++i) {
            this.flow[i] = flowHeadPairs[i][0];
            this.head[i] = flowHeadPairs[i][1];
        }
        this.chartConditions = chartConditions == null ? null : Arrays.copyOf(chartConditions, chartConditions.length);
        SplineInterpolator interpolator = new SplineInterpolator();
        this.headFromFlow = interpolator.interpolate(this.flow, this.head);
        TreeMap<Double, Double> uniqueHeadFlow = new TreeMap<Double, Double>();
        for (int i2 = 0; i2 < n; ++i2) {
            uniqueHeadFlow.put(this.head[i2], this.flow[i2]);
        }
        int m = uniqueHeadFlow.size();
        this.sortedHead = new double[m];
        this.sortedFlow = new double[m];
        int i3 = 0;
        for (Map.Entry entry : uniqueHeadFlow.entrySet()) {
            this.sortedHead[i3] = (Double)entry.getKey();
            this.sortedFlow[i3] = (Double)entry.getValue();
            ++i3;
        }
        if (m < 2) {
            throw new IllegalArgumentException("Not enough distinct head values for spline interpolation.");
        }
        this.flowFromHead = interpolator.interpolate(this.sortedHead, this.sortedFlow);
        this.setActive(true);
    }

    @Override
    public double getFlow(double headValue) {
        if (!this.isActive()) {
            return 0.0;
        }
        if (this.flowFromHead == null) {
            this.setCurve(this.chartConditions, this.flow, this.head);
        }
        try {
            double extrapolated;
            double minHead = this.sortedHead[0];
            double maxHead = this.sortedHead[this.sortedHead.length - 1];
            if (headValue >= minHead && headValue <= maxHead) {
                return Math.max(0.0, this.flowFromHead.value(headValue));
            }
            if (headValue < minHead) {
                double slope = (this.sortedFlow[1] - this.sortedFlow[0]) / (this.sortedHead[1] - this.sortedHead[0]);
                extrapolated = this.sortedFlow[0] + slope * (headValue - this.sortedHead[0]);
            } else {
                double slope = (this.sortedFlow[this.sortedFlow.length - 1] - this.sortedFlow[this.sortedFlow.length - 2]) / (this.sortedHead[this.sortedHead.length - 1] - this.sortedHead[this.sortedHead.length - 2]);
                extrapolated = this.sortedFlow[this.sortedFlow.length - 1] + slope * (headValue - this.sortedHead[this.sortedHead.length - 1]);
            }
            return Math.max(0.0, extrapolated);
        }
        catch (Exception e) {
            logger.error("Error evaluating surge flow from head = " + headValue, (Throwable)e);
            return 0.0;
        }
    }

    @Override
    public double getSurgeFlow(double headValue) {
        return this.getFlow(headValue);
    }

    public double getSurgeHead(double flowValue) {
        if (!this.isActive()) {
            return 0.0;
        }
        if (this.headFromFlow == null) {
            this.setCurve(this.chartConditions, this.flow, this.head);
        }
        try {
            double extrapolated;
            double minFlow = this.flow[0];
            double maxFlow = this.flow[this.flow.length - 1];
            if (minFlow > maxFlow) {
                double temp = minFlow;
                minFlow = maxFlow;
                maxFlow = temp;
            }
            if (flowValue >= minFlow && flowValue <= maxFlow) {
                return this.headFromFlow.value(flowValue);
            }
            if (flowValue < minFlow) {
                slope = (this.head[1] - this.head[0]) / (this.flow[1] - this.flow[0]);
                extrapolated = this.head[0] + slope * (flowValue - this.flow[0]);
            } else {
                slope = (this.head[this.head.length - 1] - this.head[this.head.length - 2]) / (this.flow[this.flow.length - 1] - this.flow[this.flow.length - 2]);
                extrapolated = this.head[this.head.length - 1] + slope * (flowValue - this.flow[this.flow.length - 1]);
            }
            return Math.max(0.0, extrapolated);
        }
        catch (Exception e) {
            logger.error("Error evaluating surge head from flow = " + flowValue, (Throwable)e);
            return 0.0;
        }
    }

    @Override
    public boolean isSurge(double headValue, double flowValue) {
        return this.isLimit(headValue, flowValue);
    }
}

