/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.heatexchanger;

import com.google.gson.GsonBuilder;
import java.util.UUID;
import neqsim.process.equipment.TwoPortEquipment;
import neqsim.process.equipment.heatexchanger.HeaterInterface;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.util.monitor.HeaterResponse;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import neqsim.util.unit.PowerUnit;

public class Heater
extends TwoPortEquipment
implements HeaterInterface {
    private static final long serialVersionUID = 1000L;
    boolean setTemperature = false;
    boolean setOutPressure = false;
    SystemInterface system;
    protected double temperatureOut = 0.0;
    protected double dT = 0.0;
    protected double pressureOut = 0.0;
    private boolean setEnergyInput = false;
    private double energyInput = 0.0;
    private double pressureDrop = 0.0;
    private String temperatureUnit = "K";
    private String pressureUnit = "bara";
    double coolingMediumTemperature = 278.15;
    protected double lastTemperature = 0.0;
    protected double lastPressure = 0.0;
    protected double lastFlowRate = 0.0;
    protected double lastOutPressure = 0.0;
    protected double lastOutTemperature = 0.0;
    protected double lastDuty = 0.0;
    protected double lastPressureDrop = 0.0;

    public Heater(String name) {
        super(name);
    }

    public Heater(String name, StreamInterface inStream) {
        super(name);
        this.inStream = inStream;
        this.system = inStream.getThermoSystem().clone();
        this.outStream = new Stream("outStream", this.system);
    }

    @Override
    public void setdT(double dT) {
        this.setTemperature = false;
        this.setEnergyInput = false;
        this.dT = dT;
    }

    public void setOutPressure(double pressure) {
        this.setOutPressure = true;
        this.pressureUnit = "bara";
        this.pressureOut = pressure;
    }

    @Override
    public void setOutPressure(double pressure, String unit) {
        this.setOutPressure = true;
        this.pressureOut = pressure;
        this.pressureUnit = unit;
    }

    public void setOutTemperature(double temperature) {
        this.setTemperature = true;
        this.setEnergyInput = false;
        this.temperatureUnit = "K";
        this.temperatureOut = temperature;
    }

    @Override
    public void setOutTemperature(double temperature, String unit) {
        this.setTemperature = true;
        this.setEnergyInput = false;
        this.temperatureUnit = unit;
        this.temperatureOut = temperature;
    }

    @Override
    public void setOutTP(double temperature, double pressure) {
        this.setTemperature = true;
        this.setEnergyInput = false;
        this.temperatureOut = temperature;
        this.temperatureUnit = "K";
        this.pressureUnit = "bara";
        this.setOutPressure = true;
        this.pressureOut = pressure;
    }

    @Override
    public boolean needRecalculation() {
        if (this.inStream == null) {
            return true;
        }
        return this.inStream.getFluid().getTemperature() != this.lastTemperature || this.inStream.getFluid().getPressure() != this.lastPressure || !(Math.abs(this.inStream.getFluid().getFlowRate("kg/hr") - this.lastFlowRate) / this.inStream.getFluid().getFlowRate("kg/hr") < 1.0E-6) || this.lastDuty != this.getDuty() || this.lastOutPressure != this.pressureOut || this.lastOutTemperature != this.temperatureOut || this.getPressureDrop() != this.lastPressureDrop;
    }

    @Override
    public void run(UUID id) {
        this.system = this.inStream.getThermoSystem().clone();
        this.isActive(true);
        if (this.inStream.getFlowRate("kg/hr") < this.getMinimumFlow()) {
            this.isActive(false);
            this.getOutletStream().setThermoSystem(this.system);
            this.lastTemperature = this.inStream.getFluid().getTemperature();
            this.lastPressure = this.inStream.getFluid().getPressure();
            this.lastFlowRate = this.inStream.getFluid().getFlowRate("kg/hr");
            this.lastDuty = this.getDuty();
            this.lastOutPressure = this.pressureOut;
            this.lastOutTemperature = this.temperatureOut;
            this.lastPressureDrop = this.pressureDrop;
            this.setCalculationIdentifier(id);
            return;
        }
        this.system.init(3);
        double oldH = this.system.getEnthalpy();
        if (this.isSetEnergyStream()) {
            this.energyInput = -this.energyStream.getDuty();
        }
        double newEnthalpy = this.energyInput + oldH;
        this.system.setPressure(this.system.getPressure() - this.pressureDrop, this.pressureUnit);
        if (this.setOutPressure) {
            this.system.setPressure(this.pressureOut, this.pressureUnit);
        }
        ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
        if (this.getSpecification().equals("out stream")) {
            this.getOutletStream().setFlowRate(this.getInletStream().getFlowRate("kg/sec"), "kg/sec");
            this.getOutletStream().run(id);
            this.temperatureOut = this.getOutletStream().getTemperature();
            this.system = this.getOutletStream().getThermoSystem().clone();
        } else if (this.setTemperature) {
            this.system.setTemperature(this.temperatureOut, this.temperatureUnit);
            testOps.TPflash();
        } else if (this.setEnergyInput || this.isSetEnergyStream()) {
            testOps.PHflash(newEnthalpy, 0);
        } else {
            this.system.setTemperature(this.inStream.getTemperature() + this.dT, this.temperatureUnit);
            testOps.TPflash();
        }
        this.system.init(3);
        double newH = this.system.getEnthalpy();
        this.energyInput = newH - oldH;
        if (!this.isSetEnergyStream()) {
            this.getEnergyStream().setDuty(this.energyInput);
        }
        this.system.initProperties();
        this.getOutletStream().setThermoSystem(this.system);
        this.lastTemperature = this.inStream.getFluid().getTemperature();
        this.lastPressure = this.inStream.getFluid().getPressure();
        this.lastFlowRate = this.inStream.getFluid().getFlowRate("kg/hr");
        this.lastDuty = this.getDuty();
        this.lastOutPressure = this.pressureOut;
        this.lastOutTemperature = this.temperatureOut;
        this.lastPressureDrop = this.pressureDrop;
        this.setCalculationIdentifier(id);
    }

    @Override
    public void runTransient(double dt, UUID id) {
        if (this.getCalculateSteadyState()) {
            this.run(id);
            this.increaseTime(dt);
        } else {
            this.inStream.setPressure(this.outStream.getPressure());
            this.inStream.run();
            this.run(id);
            this.increaseTime(dt);
        }
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
        this.getOutletStream().displayResult();
    }

    public double getEnergyInput() {
        return this.energyInput;
    }

    public double getDuty() {
        return this.energyInput;
    }

    public double getDuty(String unit) {
        PowerUnit powerUnit = new PowerUnit(this.energyInput, "W");
        return powerUnit.getValue(unit);
    }

    public void setEnergyInput(double energyInput) {
        this.energyInput = energyInput;
        this.setTemperature = false;
        this.setEnergyInput = true;
    }

    public void setDuty(double energyInput) {
        this.setEnergyInput(energyInput);
    }

    public boolean isSetEnergyInput() {
        return this.setEnergyInput;
    }

    public void setSetEnergyInput(boolean setEnergyInput) {
        this.setEnergyInput = setEnergyInput;
    }

    public double getPressureDrop() {
        return this.pressureDrop;
    }

    public void setPressureDrop(double pressureDrop) {
        this.pressureDrop = pressureDrop;
    }

    @Deprecated
    public void setOutStream(StreamInterface outStream) {
        this.setOutletStream(outStream);
    }

    @Override
    public double getEntropyProduction(String unit) {
        UUID id = UUID.randomUUID();
        this.inStream.run(id);
        this.inStream.getFluid().init(3);
        this.outStream.run(id);
        this.outStream.getFluid().init(3);
        double entrop = this.outStream.getThermoSystem().getEntropy(unit) - this.inStream.getThermoSystem().getEntropy(unit);
        return entrop;
    }

    @Override
    public double getExergyChange(String unit, double surroundingTemperature) {
        UUID id = UUID.randomUUID();
        this.inStream.run(id);
        this.inStream.getFluid().init(3);
        this.outStream.run(id);
        this.outStream.getFluid().init(3);
        return this.outStream.getThermoSystem().getExergy(surroundingTemperature, unit) - this.inStream.getThermoSystem().getExergy(surroundingTemperature, unit);
    }

    @Override
    public String toJson() {
        return new GsonBuilder().create().toJson(new HeaterResponse(this));
    }
}

