/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.heatexchanger;

import java.util.UUID;
import neqsim.physicalproperties.system.PhysicalPropertyModel;
import neqsim.process.equipment.heatexchanger.Cooler;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.util.steam.Iapws_if97;
import neqsim.util.unit.PressureUnit;
import neqsim.util.unit.RateUnit;
import neqsim.util.unit.TemperatureUnit;

public class WaterCooler
extends Cooler {
    private static final long serialVersionUID = 1000L;
    private double waterInletTemperature = 298.15;
    private double waterOutletTemperature = 308.15;
    private double waterPressure = 1.0;
    private double coolingWaterFlowRate = 0.0;

    public WaterCooler(String name) {
        super(name);
    }

    public WaterCooler(String name, StreamInterface inStream) {
        super(name, inStream);
        this.setWaterModel();
    }

    public void setWaterInletTemperature(double temperature, String unit) {
        this.waterInletTemperature = new TemperatureUnit(temperature, unit).getValue("K");
    }

    public void setWaterOutletTemperature(double temperature, String unit) {
        this.waterOutletTemperature = new TemperatureUnit(temperature, unit).getValue("K");
    }

    public void setWaterPressure(double pressure, String unit) {
        this.waterPressure = new PressureUnit(pressure, unit).getValue("bara");
    }

    public double getCoolingWaterFlowRate(String unit) {
        return new RateUnit(this.coolingWaterFlowRate, "kg/sec", 1.0, 1.0, 0.0).getValue(unit);
    }

    private void setWaterModel() {
        if (this.inStream != null) {
            this.inStream.getThermoSystem().setPhysicalPropertyModel(PhysicalPropertyModel.WATER);
        }
        if (this.outStream != null) {
            this.outStream.getThermoSystem().setPhysicalPropertyModel(PhysicalPropertyModel.WATER);
        }
    }

    @Override
    public void setInletStream(StreamInterface stream) {
        super.setInletStream(stream);
        this.setWaterModel();
    }

    @Override
    public void run(UUID id) {
        super.run(id);
        this.calculateCoolingWaterFlowRate();
    }

    private void calculateCoolingWaterFlowRate() {
        double pinMPa = this.waterPressure / 10.0;
        double hin = Iapws_if97.h_pt(pinMPa, this.waterInletTemperature);
        double hout = Iapws_if97.h_pt(pinMPa, this.waterOutletTemperature);
        double deltaH = hout - hin;
        if (Math.abs(deltaH) < 1.0E-6) {
            this.coolingWaterFlowRate = 0.0;
            return;
        }
        this.coolingWaterFlowRate = -this.getEnergyInput() / (deltaH * 1000.0);
    }
}

