/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.pipeline;

import com.google.gson.GsonBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import neqsim.process.equipment.pipeline.Pipeline;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.util.monitor.PipeBeggsBrillsResponse;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import neqsim.util.database.NeqSimDataBase;
import neqsim.util.exception.InvalidInputException;
import neqsim.util.exception.InvalidOutputException;

public class PipeBeggsAndBrills
extends Pipeline {
    private static final long serialVersionUID = 1001L;
    int iteration;
    private double nominalDiameter;
    private Boolean PipeSpecSet = false;
    private double inletPressure = Double.NaN;
    private double totalPressureDrop = 0.0;
    protected double temperatureOut = 270.0;
    protected double pressureOut = 0.0;
    String maxflowunit = "kg/hr";
    private double insideDiameter = Double.NaN;
    private double pipeThickness = Double.NaN;
    private double pipeWallRoughness = 1.0E-5;
    private boolean runIsothermal = true;
    private FlowRegime regime;
    private double inputVolumeFractionLiquid;
    private double mixtureFroudeNumber;
    private String pipeSpecification = "LD201";
    private double A;
    private double area;
    private double supGasVel;
    private double supLiquidVel;
    private double mixtureDensity;
    private double hydrostaticPressureDrop;
    private double El = 0.0;
    private double supMixVel;
    private double frictionPressureLoss;
    private double pressureDrop;
    private int numberOfIncrements = 5;
    private double totalLength = Double.NaN;
    private double totalElevation = Double.NaN;
    private double angle = Double.NaN;
    private double mixtureLiquidDensity;
    private double mixtureLiquidViscosity;
    private double mixtureOilMassFraction;
    private double mixtureOilVolumeFraction;
    private double cumulativeLength;
    private double cumulativeElevation;
    double length;
    double elevation;
    private List<Double> pressureProfile;
    private List<Double> temperatureProfile;
    private List<Double> pressureDropProfile;
    private List<FlowRegime> flowRegimeProfile;
    private List<Double> liquidSuperficialVelocityProfile;
    private List<Double> gasSuperficialVelocityProfile;
    private List<Double> mixtureSuperficialVelocityProfile;
    private List<Double> mixtureViscosityProfile;
    private List<Double> mixtureDensityProfile;
    private List<Double> liquidDensityProfile;
    private List<Double> liquidHoldupProfile;
    private List<Double> mixtureReynoldsNumber;
    private List<Double> lengthProfile;
    private List<Double> elevationProfile;
    private List<Integer> incrementsProfile;
    private boolean runAdiabatic = true;
    private boolean runConstantSurfaceTemperature = false;
    private double constantSurfaceTemperature;
    private double heatTransferCoefficient;
    private String heatTransferCoefficientMethod = "Estimated";
    double Tmi;
    double Tmo;
    double Ts;
    double error;
    double iterationT;
    double dTlm;
    double cp;
    double q1;
    double q2;
    double ReNoSlip;
    double S = 0.0;
    double rhoNoSlip = 0.0;
    double muNoSlip = 0.0;
    double thermalConductivity;
    double Pr;
    double frictionFactor;
    double frictionTwoPhase;
    double Nu;
    double criticalPressure;
    double hmax;
    double X;

    public PipeBeggsAndBrills(String name) {
        super(name);
    }

    public PipeBeggsAndBrills(String name, StreamInterface inStream) {
        super(name, inStream);
    }

    public void setPipeSpecification(double nominalDiameter, String pipeSec) {
        this.pipeSpecification = pipeSec;
        this.nominalDiameter = nominalDiameter;
        this.PipeSpecSet = true;
        try (NeqSimDataBase database = new NeqSimDataBase();){
            ResultSet dataSet = database.getResultSet("SELECT * FROM pipedata where Size='" + nominalDiameter + "'");
            try {
                if (dataSet.next()) {
                    this.pipeThickness = Double.parseDouble(dataSet.getString(this.pipeSpecification)) / 1000.0;
                    this.insideDiameter = Double.parseDouble(dataSet.getString("OD")) / 1000.0 - 2.0 * this.pipeThickness;
                }
            }
            catch (NumberFormatException e) {
                logger.error(e.getMessage());
            }
            catch (SQLException e) {
                logger.error(e.getMessage());
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.outStream.getThermoSystem();
    }

    public void setElevation(double elevation) {
        this.totalElevation = elevation;
    }

    public void setLength(double length) {
        this.totalLength = length;
    }

    public void setDiameter(double diameter) {
        this.insideDiameter = diameter;
    }

    public void setThickness(double pipeThickness) {
        this.pipeThickness = pipeThickness;
    }

    public double getThickness() {
        return this.pipeThickness;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public void setPipeWallRoughness(double pipeWallRoughness) {
        this.pipeWallRoughness = pipeWallRoughness;
    }

    public void setNumberOfIncrements(int numberOfIncrements) {
        this.numberOfIncrements = numberOfIncrements;
    }

    public void setRunIsothermal(boolean runIsothermal) {
        this.runIsothermal = runIsothermal;
    }

    public void setConstantSurfaceTemperature(double temperature, String unit) {
        if (unit.equals("K")) {
            this.constantSurfaceTemperature = temperature;
        } else if (unit.equals("C")) {
            this.constantSurfaceTemperature = temperature + 273.15;
        } else {
            throw new RuntimeException("unit not supported " + unit);
        }
        this.runIsothermal = false;
        this.runAdiabatic = false;
        this.runConstantSurfaceTemperature = true;
    }

    public void setHeatTransferCoefficient(double heatTransferCoefficient) {
        this.heatTransferCoefficient = heatTransferCoefficient;
        this.heatTransferCoefficientMethod = "Defined";
    }

    public void convertSystemUnitToImperial() {
        this.insideDiameter *= 3.2808399;
        this.angle = 0.01745329 * this.angle;
        this.elevation *= 3.2808399;
        this.length *= 3.2808399;
        this.pipeWallRoughness *= 3.2808399;
    }

    public void convertSystemUnitToMetric() {
        this.insideDiameter /= 3.2808399;
        this.angle /= 0.01745329;
        this.elevation /= 3.2808399;
        this.length /= 3.2808399;
        this.pipeWallRoughness /= 3.2808399;
        this.pressureDrop *= 1.48727E-5;
    }

    public void calculateMissingValue() {
        if (Double.isNaN(this.totalLength)) {
            this.totalLength = this.calculateLength();
        } else if (Double.isNaN(this.totalElevation)) {
            this.totalElevation = this.calculateElevation();
        } else if (Double.isNaN(this.angle)) {
            this.angle = this.calculateAngle();
        }
        if (Math.abs(this.totalElevation) > Math.abs(this.totalLength)) {
            throw new RuntimeException(new InvalidInputException("PipeBeggsAndBrills", "calcMissingValue", "elevation", "- cannot be higher than length of the pipe" + this.length));
        }
        if (Double.isNaN(this.totalElevation) || Double.isNaN(this.totalLength) || Double.isNaN(this.angle) || Double.isNaN(this.insideDiameter)) {
            throw new RuntimeException(new InvalidInputException("PipeBeggsAndBrills", "calcMissingValue", "elevation or length or angle or inlet diameter", "cannot be null"));
        }
    }

    private double calculateLength() {
        return this.totalElevation / Math.sin(Math.toRadians(this.angle));
    }

    private double calculateElevation() {
        return this.totalLength * Math.sin(Math.toRadians(this.angle));
    }

    private double calculateAngle() {
        return Math.toDegrees(Math.asin(this.totalElevation / this.totalLength));
    }

    public FlowRegime calcFlowRegime() {
        this.area = 0.7853981633974483 * Math.pow(this.insideDiameter, 2.0);
        if (this.system.getNumberOfPhases() != 1) {
            this.supLiquidVel = this.system.getNumberOfPhases() == 3 ? (this.system.getPhase(1).getFlowRate("ft3/sec") + this.system.getPhase(2).getFlowRate("ft3/sec")) / this.area : this.system.getPhase(1).getFlowRate("ft3/sec") / this.area;
            this.supGasVel = this.system.getPhase(0).getFlowRate("ft3/sec") / this.area;
            this.supMixVel = this.supLiquidVel + this.supGasVel;
            this.mixtureFroudeNumber = Math.pow(this.supMixVel, 2.0) / (32.174 * this.insideDiameter);
            this.inputVolumeFractionLiquid = this.supLiquidVel / this.supMixVel;
        } else if (this.system.hasPhaseType("gas")) {
            this.supMixVel = this.supGasVel = this.system.getPhase(0).getFlowRate("ft3/sec") / this.area;
            this.inputVolumeFractionLiquid = 0.0;
            this.regime = FlowRegime.SINGLE_PHASE;
        } else {
            this.supMixVel = this.supLiquidVel = this.system.getPhase(1).getFlowRate("ft3/sec") / this.area;
            this.inputVolumeFractionLiquid = 1.0;
            this.regime = FlowRegime.SINGLE_PHASE;
        }
        this.liquidSuperficialVelocityProfile.add(this.supLiquidVel / 3.2808399);
        this.gasSuperficialVelocityProfile.add(this.supGasVel / 3.2808399);
        this.mixtureSuperficialVelocityProfile.add(this.supMixVel / 3.2808399);
        double L1 = 316.0 * Math.pow(this.inputVolumeFractionLiquid, 0.302);
        double L2 = 9.252E-4 * Math.pow(this.inputVolumeFractionLiquid, -2.4684);
        double L3 = 0.1 * Math.pow(this.inputVolumeFractionLiquid, -1.4516);
        double L4 = 0.5 * Math.pow(this.inputVolumeFractionLiquid, -6.738);
        if (this.regime != FlowRegime.SINGLE_PHASE) {
            if (this.inputVolumeFractionLiquid < 0.01 && this.mixtureFroudeNumber < L1 || this.inputVolumeFractionLiquid >= 0.01 && this.mixtureFroudeNumber < L2) {
                this.regime = FlowRegime.SEGREGATED;
            } else if (this.inputVolumeFractionLiquid < 0.4 && this.inputVolumeFractionLiquid >= 0.01 && this.mixtureFroudeNumber <= L1 && this.mixtureFroudeNumber > L3 || this.inputVolumeFractionLiquid >= 0.4 && this.mixtureFroudeNumber <= L4 && this.mixtureFroudeNumber > L3) {
                this.regime = FlowRegime.INTERMITTENT;
            } else if (this.inputVolumeFractionLiquid < 0.4 && this.mixtureFroudeNumber >= L4 || this.inputVolumeFractionLiquid >= 0.4 && this.mixtureFroudeNumber > L4) {
                this.regime = FlowRegime.DISTRIBUTED;
            } else if (this.mixtureFroudeNumber > L2 && this.mixtureFroudeNumber < L3) {
                this.regime = FlowRegime.TRANSITION;
            } else if (this.inputVolumeFractionLiquid < 0.1 || this.inputVolumeFractionLiquid > 0.9) {
                this.regime = FlowRegime.INTERMITTENT;
            } else if (this.mixtureFroudeNumber > 110.0) {
                this.regime = FlowRegime.INTERMITTENT;
            } else {
                throw new RuntimeException(new InvalidOutputException("PipeBeggsAndBrills", "run: calcFlowRegime", "FlowRegime", "Flow regime is not found"));
            }
        }
        this.A = (L3 - this.mixtureFroudeNumber) / (L3 - L2);
        this.flowRegimeProfile.add(this.regime);
        return this.regime;
    }

    public double calcHydrostaticPressureDifference() {
        double B = 1.0 - this.A;
        if (this.regime == FlowRegime.SEGREGATED) {
            this.El = 0.98 * Math.pow(this.inputVolumeFractionLiquid, 0.4846) / Math.pow(this.mixtureFroudeNumber, 0.0868);
        } else if (this.regime == FlowRegime.INTERMITTENT) {
            this.El = 0.845 * Math.pow(this.inputVolumeFractionLiquid, 0.5351) / Math.pow(this.mixtureFroudeNumber, 0.0173);
        } else if (this.regime == FlowRegime.DISTRIBUTED) {
            this.El = 1.065 * Math.pow(this.inputVolumeFractionLiquid, 0.5824) / Math.pow(this.mixtureFroudeNumber, 0.0609);
        } else if (this.regime == FlowRegime.TRANSITION) {
            this.El = this.A * 0.98 * Math.pow(this.inputVolumeFractionLiquid, 0.4846) / Math.pow(this.mixtureFroudeNumber, 0.0868) + B * 0.845 * Math.pow(this.inputVolumeFractionLiquid, 0.5351) / Math.pow(this.mixtureFroudeNumber, 0.0173);
        } else if (this.regime == FlowRegime.SINGLE_PHASE) {
            this.El = this.inputVolumeFractionLiquid < 0.1 ? this.inputVolumeFractionLiquid : 1.0 - this.inputVolumeFractionLiquid;
        }
        if (this.regime != FlowRegime.SINGLE_PHASE) {
            double SG;
            if (this.system.getNumberOfPhases() == 3) {
                this.mixtureOilMassFraction = this.system.getPhase(1).getFlowRate("kg/hr") / (this.system.getPhase(1).getFlowRate("kg/hr") + this.system.getPhase(2).getFlowRate("kg/hr"));
                this.mixtureOilVolumeFraction = this.system.getPhase(1).getVolume() / (this.system.getPhase(1).getVolume() + this.system.getPhase(2).getVolume());
                this.mixtureLiquidViscosity = this.system.getPhase(1).getViscosity("cP") * this.mixtureOilVolumeFraction + this.system.getPhase(2).getViscosity("cP") * (1.0 - this.mixtureOilVolumeFraction);
                this.mixtureLiquidDensity = this.system.getPhase(1).getDensity("lb/ft3") * this.mixtureOilMassFraction + this.system.getPhase(2).getDensity("lb/ft3") * (1.0 - this.mixtureOilMassFraction);
                SG = this.mixtureLiquidDensity / 62.4279606;
            } else {
                SG = this.system.getPhase(1).getDensity("lb/ft3") / 62.4279606;
            }
            double APIgrav = 141.5 / SG - 131.0;
            double sigma68 = 39.0 - 0.2571 * APIgrav;
            double sigma100 = 37.5 - 0.2571 * APIgrav;
            double sigma = this.system.getTemperature("C") * 1.8 + 32.0 > 100.0 ? sigma100 : (this.system.getTemperature("C") * 1.8 + 32.0 < 68.0 ? sigma68 : sigma68 + (this.system.getTemperature("C") * 1.8 + 32.0 - 68.0) * (sigma100 - sigma68) / 32.0);
            double pressureCorrection = 1.0 - 0.024 * Math.pow(this.system.getPressure("psi"), 0.45);
            double Nvl = 1.938 * this.supLiquidVel * Math.pow(this.system.getPhase(1).getDensity() * 0.0624279606 / (32.2 * (sigma *= pressureCorrection)), 0.25);
            double betta = 0.0;
            if (this.elevation > 0.0) {
                if (this.regime == FlowRegime.SEGREGATED) {
                    betta = (1.0 - this.inputVolumeFractionLiquid) * Math.log(0.011 * Math.pow(Nvl, 3.539) / (Math.pow(this.inputVolumeFractionLiquid, 3.768) * Math.pow(this.mixtureFroudeNumber, 1.614)));
                } else if (this.regime == FlowRegime.INTERMITTENT) {
                    betta = (1.0 - this.inputVolumeFractionLiquid) * Math.log(2.96 * Math.pow(this.inputVolumeFractionLiquid, 0.305) * Math.pow(this.mixtureFroudeNumber, 0.0978) / Math.pow(Nvl, 0.4473));
                } else if (this.regime == FlowRegime.DISTRIBUTED) {
                    betta = 0.0;
                }
            } else {
                betta = (1.0 - this.inputVolumeFractionLiquid) * Math.log(4.7 * Math.pow(Nvl, 0.1244) / (Math.pow(this.inputVolumeFractionLiquid, 0.3692) * Math.pow(this.mixtureFroudeNumber, 0.5056)));
            }
            betta = betta > 0.0 ? betta : 0.0;
            double BThetta = 1.0 + betta * (Math.sin(1.8 * this.angle * 0.01745329) - 0.3333333333333333 * Math.pow(Math.sin(1.8 * this.angle * 0.01745329), 3.0));
            this.El = BThetta * this.El;
            this.mixtureDensity = this.system.getNumberOfPhases() == 3 ? this.mixtureLiquidDensity * this.El + this.system.getPhase(0).getDensity("lb/ft3") * (1.0 - this.El) : this.system.getPhase(1).getDensity("lb/ft3") * this.El + this.system.getPhase(0).getDensity("lb/ft3") * (1.0 - this.El);
        } else {
            this.mixtureDensity = this.system.hasPhaseType("gas") ? this.system.getPhase(0).getDensity("lb/ft3") : this.system.getPhase(1).getDensity("lb/ft3");
        }
        this.hydrostaticPressureDrop = this.mixtureDensity * 32.2 * this.elevation;
        this.liquidHoldupProfile.add(this.El);
        return this.hydrostaticPressureDrop;
    }

    public double calcFrictionPressureLoss() {
        double S = 0.0;
        double rhoNoSlip = 0.0;
        double muNoSlip = 0.0;
        if (this.system.getNumberOfPhases() != 1) {
            if (this.regime != FlowRegime.SINGLE_PHASE) {
                double y = this.inputVolumeFractionLiquid / Math.pow(this.El, 2.0);
                S = 1.0 < y && y < 1.2 ? Math.log(2.2 * y - 1.2) : Math.log(y) / (-0.0523 + 3.18 * Math.log(y) - 0.872 * Math.pow(Math.log(y), 2.0) + 0.01853 * Math.pow(Math.log(y), 4.0));
                if (this.system.getNumberOfPhases() == 3) {
                    rhoNoSlip = this.mixtureLiquidDensity * this.inputVolumeFractionLiquid + this.system.getPhase(0).getDensity("lb/ft3") * (1.0 - this.inputVolumeFractionLiquid);
                    muNoSlip = this.mixtureLiquidViscosity * this.inputVolumeFractionLiquid + this.system.getPhase(0).getViscosity("cP") * (1.0 - this.inputVolumeFractionLiquid);
                    this.liquidDensityProfile.add(this.mixtureLiquidDensity * 16.01846);
                } else {
                    rhoNoSlip = this.system.getPhase(1).getDensity("lb/ft3") * this.inputVolumeFractionLiquid + this.system.getPhase(0).getDensity("lb/ft3") * (1.0 - this.inputVolumeFractionLiquid);
                    muNoSlip = this.system.getPhase(1).getViscosity("cP") * this.inputVolumeFractionLiquid + this.system.getPhase(0).getViscosity("cP") * (1.0 - this.inputVolumeFractionLiquid);
                    this.liquidDensityProfile.add(this.system.getPhase(1).getDensity("lb/ft3") * 16.01846);
                }
            } else {
                rhoNoSlip = this.system.getPhase(1).getDensity("lb/ft3") * this.inputVolumeFractionLiquid + this.system.getPhase(0).getDensity("lb/ft3") * (1.0 - this.inputVolumeFractionLiquid);
                muNoSlip = this.system.getPhase(1).getViscosity("cP") * this.inputVolumeFractionLiquid + this.system.getPhase(0).getViscosity("cP") * (1.0 - this.inputVolumeFractionLiquid);
                this.liquidDensityProfile.add(this.system.getPhase(1).getDensity("lb/ft3") * 16.01846);
            }
        } else if (this.system.hasPhaseType("gas")) {
            rhoNoSlip = this.system.getPhase(0).getDensity("lb/ft3");
            muNoSlip = this.system.getPhase(0).getViscosity("cP");
            this.liquidDensityProfile.add(0.0);
        } else {
            rhoNoSlip = this.system.getPhase(1).getDensity("lb/ft3");
            muNoSlip = this.system.getPhase(1).getViscosity("cP");
            this.liquidDensityProfile.add(rhoNoSlip * 16.01846);
        }
        this.mixtureViscosityProfile.add(muNoSlip);
        this.mixtureDensityProfile.add(rhoNoSlip * 16.01846);
        this.ReNoSlip = rhoNoSlip * this.supMixVel * this.insideDiameter * 1.4872099940511603 / (0.001 * muNoSlip);
        this.mixtureReynoldsNumber.add(this.ReNoSlip);
        double E = this.pipeWallRoughness / this.insideDiameter;
        this.frictionFactor = Math.pow(1.0 / (-1.8 * Math.log10(E / 3.7 + 6.9 / this.ReNoSlip)), 2.0);
        this.frictionTwoPhase = this.frictionFactor * Math.exp(S);
        this.frictionPressureLoss = this.frictionTwoPhase * Math.pow(this.supMixVel, 2.0) * rhoNoSlip * this.length / (2.0 * this.insideDiameter);
        return this.frictionPressureLoss;
    }

    public double calcPressureDrop() {
        this.convertSystemUnitToImperial();
        this.regime = FlowRegime.UNKNOWN;
        this.calcFlowRegime();
        this.hydrostaticPressureDrop = this.calcHydrostaticPressureDifference();
        this.frictionPressureLoss = this.calcFrictionPressureLoss();
        this.pressureDrop = this.hydrostaticPressureDrop + this.frictionPressureLoss;
        this.convertSystemUnitToMetric();
        ++this.iteration;
        return this.pressureDrop;
    }

    @Override
    public void run(UUID id) {
        this.iteration = 0;
        this.pressureProfile = new ArrayList<Double>();
        this.temperatureProfile = new ArrayList<Double>();
        this.pressureDropProfile = new ArrayList<Double>();
        this.flowRegimeProfile = new ArrayList<FlowRegime>();
        this.liquidSuperficialVelocityProfile = new ArrayList<Double>();
        this.gasSuperficialVelocityProfile = new ArrayList<Double>();
        this.mixtureSuperficialVelocityProfile = new ArrayList<Double>();
        this.mixtureViscosityProfile = new ArrayList<Double>();
        this.mixtureDensityProfile = new ArrayList<Double>();
        this.liquidDensityProfile = new ArrayList<Double>();
        this.liquidHoldupProfile = new ArrayList<Double>();
        this.mixtureReynoldsNumber = new ArrayList<Double>();
        this.lengthProfile = new ArrayList<Double>();
        this.elevationProfile = new ArrayList<Double>();
        this.incrementsProfile = new ArrayList<Integer>();
        this.calculateMissingValue();
        double enthalpyInlet = Double.NaN;
        this.length = this.totalLength / (double)this.numberOfIncrements;
        this.elevation = this.totalElevation / (double)this.numberOfIncrements;
        this.system = this.inStream.getThermoSystem().clone();
        ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
        testOps.TPflash();
        this.system.initProperties();
        if (!this.runIsothermal) {
            enthalpyInlet = this.system.getEnthalpy();
        }
        double pipeInletPressure = this.system.getPressure();
        this.cumulativeLength = 0.0;
        this.cumulativeElevation = 0.0;
        this.pressureProfile.add(this.system.getPressure());
        this.temperatureProfile.add(this.system.getTemperature());
        this.pressureDropProfile.add(0.0);
        for (int i = 1; i <= this.numberOfIncrements; ++i) {
            this.lengthProfile.add(this.cumulativeLength);
            this.elevationProfile.add(this.cumulativeElevation);
            this.incrementsProfile.add(i - 1);
            this.cumulativeLength += this.length;
            this.cumulativeElevation += this.elevation;
            this.inletPressure = this.system.getPressure();
            this.pressureDrop = this.calcPressureDrop();
            this.pressureDropProfile.add(this.pressureDrop);
            this.pressureOut = this.inletPressure - this.pressureDrop;
            this.pressureProfile.add(this.pressureOut);
            if (this.pressureOut < 0.0) {
                throw new RuntimeException(new InvalidOutputException("PipeBeggsAndBrills", "run: calcOutletPressure", "pressure out", "- Outlet pressure is negative" + this.pressureOut));
            }
            this.system.setPressure(this.pressureOut);
            if (!this.runIsothermal) {
                enthalpyInlet = this.calcHeatBalance(enthalpyInlet, this.system, testOps);
                this.temperatureProfile.add(this.system.getTemperature());
            } else {
                testOps.TPflash();
            }
            this.system.initProperties();
        }
        this.totalPressureDrop = pipeInletPressure - this.system.getPressure();
        this.calcPressureDrop();
        this.lengthProfile.add(this.cumulativeLength);
        this.elevationProfile.add(this.cumulativeElevation);
        this.incrementsProfile.add(this.getNumberOfIncrements());
        this.system.initProperties();
        this.outStream.setThermoSystem(this.system);
        this.outStream.setCalculationIdentifier(id);
    }

    public double estimateHeatTransferCoefficent(SystemInterface system) {
        this.cp = system.getCp("J/kgK");
        this.thermalConductivity = system.getThermalConductivity();
        this.Pr = 0.001 * system.getViscosity("cP") * this.cp / this.thermalConductivity;
        if (this.ReNoSlip < 3000.0) {
            this.Nu = 3.66;
        } else if (this.Pr < 2000.0 && this.Pr > 0.5 && this.ReNoSlip < 5000000.0) {
            this.Nu = this.frictionTwoPhase / 8.0 * (this.ReNoSlip - 1000.0) * this.Pr / (1.0 + 12.7 * Math.pow(this.frictionTwoPhase, 0.5) * (Math.pow(this.Pr, 0.66) - 1.0));
        }
        this.heatTransferCoefficient = this.Nu * this.thermalConductivity / this.insideDiameter;
        if (system.getNumberOfPhases() > 1) {
            this.X = system.getPhase(0).getFlowRate("kg/sec") / system.getFlowRate("kg/sec");
            this.heatTransferCoefficient = (-31.469 * Math.pow(this.X, 2.0) + 31.469 * this.X + 0.007) * this.heatTransferCoefficient;
        }
        return this.heatTransferCoefficient;
    }

    public double calcTemperatureDifference(SystemInterface system) {
        double cp = system.getCp("J/kgK");
        double Tmi = system.getTemperature("C");
        double Ts = this.constantSurfaceTemperature - 273.15;
        double TmoLower = Tmi;
        double TmoUpper = Ts;
        double Tmo = (TmoLower + TmoUpper) / 2.0;
        double error = 999.0;
        double tolerance = 0.01;
        int maxIterations = 100;
        if (this.heatTransferCoefficientMethod.equals("Estimated")) {
            this.heatTransferCoefficient = this.estimateHeatTransferCoefficent(system);
        }
        for (int i = 0; i < maxIterations; ++i) {
            double dTlm = (Ts - Tmo - (Ts - Tmi)) / Math.log((Ts - Tmo) / (Ts - Tmi));
            error = this.heatTransferCoefficient - system.getFlowRate("kg/sec") * cp * (Tmo - Tmi) / (3.1415 * this.insideDiameter * this.length * dTlm);
            if (Math.abs(error) < tolerance) break;
            if (error > 0.0) {
                TmoLower = Tmo;
            } else {
                TmoUpper = Tmo;
            }
            Tmo = (TmoLower + TmoUpper) / 2.0;
        }
        return Tmo - Tmi;
    }

    public double calcHeatBalance(double enthalpy, SystemInterface system, ThermodynamicOperations testOps) {
        double Cp = system.getCp("J/kgK");
        if (!this.runAdiabatic) {
            enthalpy += system.getFlowRate("kg/sec") * Cp * this.calcTemperatureDifference(system);
        }
        testOps.PHflash(enthalpy);
        return enthalpy;
    }

    @Override
    public void runTransient(double dt, UUID id) {
        this.run(id);
        this.increaseTime(dt);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
        this.system.display();
    }

    public double getInletSuperficialVelocity() {
        return this.getInletStream().getThermoSystem().getFlowRate("kg/sec") / this.getInletStream().getThermoSystem().getDensity("kg/m3") / (0.7853981633974483 * Math.pow(this.insideDiameter, 2.0));
    }

    public double getHeatTransferCoefficient() {
        return this.heatTransferCoefficient;
    }

    public double getOutletSuperficialVelocity() {
        return this.getSegmentMixtureSuperficialVelocity(this.numberOfIncrements);
    }

    public int getNumberOfIncrements() {
        return this.numberOfIncrements;
    }

    public double getAngle() {
        return this.angle;
    }

    public double getLength() {
        return this.cumulativeLength;
    }

    public double getElevation() {
        return this.cumulativeElevation;
    }

    public double getDiameter() {
        return this.insideDiameter;
    }

    public FlowRegime getFlowRegime() {
        return this.regime;
    }

    public double getLastSegmentPressureDrop() {
        return this.pressureDrop;
    }

    public double getPressureDrop() {
        return this.totalPressureDrop;
    }

    public List<Double> getPressureProfile() {
        return new ArrayList<Double>(this.pressureProfile);
    }

    public Double getSegmentPressure(int index) {
        if (index >= 0 && index < this.pressureProfile.size()) {
            return this.pressureProfile.get(index);
        }
        throw new IndexOutOfBoundsException("Index is out of bounds.");
    }

    public List<Double> getPressureDropProfile() {
        return new ArrayList<Double>(this.pressureDropProfile);
    }

    public Double getSegmentPressureDrop(int index) {
        if (index >= 0 && index < this.pressureDropProfile.size()) {
            return this.pressureDropProfile.get(index);
        }
        throw new IndexOutOfBoundsException("Index is out of bounds.");
    }

    public List<Double> getTemperatureProfile() {
        return new ArrayList<Double>(this.temperatureProfile);
    }

    public Double getSegmentTemperature(int index) {
        if (index >= 0 && index < this.temperatureProfile.size()) {
            return this.temperatureProfile.get(index);
        }
        throw new IndexOutOfBoundsException("Index is out of bounds.");
    }

    public List<FlowRegime> getFlowRegimeProfile() {
        return new ArrayList<FlowRegime>(this.flowRegimeProfile);
    }

    public FlowRegime getSegmentFlowRegime(int index) {
        if (index >= 0 && index < this.flowRegimeProfile.size()) {
            return this.flowRegimeProfile.get(index);
        }
        throw new IndexOutOfBoundsException("Index is out of bounds.");
    }

    public List<Double> getLiquidSuperficialVelocityProfile() {
        return new ArrayList<Double>(this.liquidSuperficialVelocityProfile);
    }

    public List<Double> getGasSuperficialVelocityProfile() {
        return new ArrayList<Double>(this.gasSuperficialVelocityProfile);
    }

    public List<Double> getMixtureSuperficialVelocityProfile() {
        return new ArrayList<Double>(this.mixtureSuperficialVelocityProfile);
    }

    public List<Double> getMixtureViscosityProfile() {
        return new ArrayList<Double>(this.mixtureViscosityProfile);
    }

    public List<Double> getMixtureDensityProfile() {
        return new ArrayList<Double>(this.mixtureDensityProfile);
    }

    public List<Double> getLiquidDensityProfile() {
        return new ArrayList<Double>(this.liquidDensityProfile);
    }

    public List<Double> getLiquidHoldupProfile() {
        return new ArrayList<Double>(this.liquidHoldupProfile);
    }

    public List<Double> getMixtureReynoldsNumber() {
        return new ArrayList<Double>(this.mixtureReynoldsNumber);
    }

    public List<Double> getLengthProfile() {
        return new ArrayList<Double>(this.lengthProfile);
    }

    public List<Integer> getIncrementsProfile() {
        return new ArrayList<Integer>(this.incrementsProfile);
    }

    public List<Double> getElevationProfile() {
        return new ArrayList<Double>(this.elevationProfile);
    }

    public Double getSegmentLiquidSuperficialVelocity(int index) {
        if (index >= 0 && index < this.liquidSuperficialVelocityProfile.size()) {
            return this.liquidSuperficialVelocityProfile.get(index);
        }
        throw new IndexOutOfBoundsException("Index is out of bounds.");
    }

    public Double getSegmentGasSuperficialVelocity(int index) {
        if (index >= 0 && index < this.gasSuperficialVelocityProfile.size()) {
            return this.gasSuperficialVelocityProfile.get(index);
        }
        throw new IndexOutOfBoundsException("Index is out of bounds.");
    }

    public Double getSegmentMixtureSuperficialVelocity(int index) {
        if (index >= 0 && index < this.mixtureSuperficialVelocityProfile.size()) {
            return this.mixtureSuperficialVelocityProfile.get(index);
        }
        throw new IndexOutOfBoundsException("Index is out of bounds.");
    }

    public Double getSegmentMixtureViscosity(int index) {
        if (index >= 0 && index < this.mixtureViscosityProfile.size()) {
            return this.mixtureViscosityProfile.get(index);
        }
        throw new IndexOutOfBoundsException("Index is out of bounds.");
    }

    public Double getSegmentMixtureDensity(int index) {
        if (index >= 0 && index < this.mixtureDensityProfile.size()) {
            return this.mixtureDensityProfile.get(index);
        }
        throw new IndexOutOfBoundsException("Index is out of bounds.");
    }

    public Double getSegmentLiquidDensity(int index) {
        if (index >= 0 && index < this.liquidDensityProfile.size()) {
            return this.liquidDensityProfile.get(index);
        }
        throw new IndexOutOfBoundsException("Index is out of bounds.");
    }

    public Double getSegmentLiquidHoldup(int index) {
        if (index >= 0 && index < this.liquidHoldupProfile.size()) {
            return this.liquidHoldupProfile.get(index);
        }
        throw new IndexOutOfBoundsException("Index is out of bounds.");
    }

    public Double getSegmentMixtureReynoldsNumber(int index) {
        if (index >= 0 && index < this.mixtureReynoldsNumber.size()) {
            return this.mixtureReynoldsNumber.get(index);
        }
        throw new IndexOutOfBoundsException("Index is out of bounds.");
    }

    public Double getSegmentLength(int index) {
        if (index >= 0 && index < this.lengthProfile.size()) {
            return this.lengthProfile.get(index);
        }
        throw new IndexOutOfBoundsException("Index is out of bounds.");
    }

    public Double getSegmentElevation(int index) {
        if (index >= 0 && index < this.elevationProfile.size()) {
            return this.elevationProfile.get(index);
        }
        throw new IndexOutOfBoundsException("Index is out of bounds.");
    }

    @Override
    public String toJson() {
        return new GsonBuilder().serializeSpecialFloatingPointValues().create().toJson(new PipeBeggsBrillsResponse(this));
    }

    public static enum FlowRegime {
        SEGREGATED,
        INTERMITTENT,
        DISTRIBUTED,
        TRANSITION,
        SINGLE_PHASE,
        UNKNOWN;

    }
}

