/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.reservoir;

import java.util.UUID;
import neqsim.process.equipment.TwoPortEquipment;
import neqsim.process.equipment.valve.ThrottlingValve;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.exception.InvalidInputException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WellFlow
extends TwoPortEquipment {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ThrottlingValve.class);
    SystemInterface thermoSystem;
    private double wellProductionIndex = 0.0;
    double pressureOut = 1.0;
    String pressureUnit = "bara";
    boolean useWellProductionIndex = false;
    boolean calcpressure = true;
    InflowPerformanceModel inflowModel = InflowPerformanceModel.PRODUCTION_INDEX;
    double vogelQmax = 0.0;
    double vogelRefPres = 0.0;
    double fetkovichC = 0.0;
    double fetkovichN = 1.0;

    public WellFlow(String name) {
        super(name);
    }

    @Override
    public void run(UUID id) {
        this.thermoSystem = this.getInletStream().getThermoSystem().clone();
        this.thermoSystem.setPressure(this.pressureOut, this.pressureUnit);
        this.outStream.setThermoSystem(this.thermoSystem);
        double presRes = this.getInletStream().getPressure("bara");
        switch (this.inflowModel.ordinal()) {
            case 1: {
                if (this.calcpressure) {
                    double b = 0.2;
                    double a = 0.8;
                    double q = this.getInletStream().getFlowRate("MSm3/day");
                    double term = q / this.vogelQmax;
                    double c = term - 1.0;
                    double disc = b * b - 4.0 * a * c;
                    if (disc < 0.0) {
                        logger.error("pressure lower that 0");
                        throw new RuntimeException(new InvalidInputException("WellFlow", "run:calcOutletPressure", "pressure", "- Outlet pressure is negative" + this.pressureOut));
                    }
                    double x = (-b + Math.sqrt(disc)) / (2.0 * a);
                    this.outStream.setPressure(presRes * x, "bara");
                    break;
                }
                double pwf = this.thermoSystem.getPressure("bara");
                double term = 1.0 - 0.2 * (pwf / presRes) - 0.8 * Math.pow(pwf / presRes, 2.0);
                double flow = this.vogelQmax * term;
                this.outStream.setFlowRate(flow, "MSm3/day");
                break;
            }
            case 2: {
                if (this.calcpressure) {
                    double q = this.getInletStream().getFlowRate("MSm3/day");
                    double delta = Math.pow(q / this.fetkovichC, 1.0 / this.fetkovichN);
                    if (Math.pow(presRes, 2.0) - delta < 0.0) {
                        logger.error("pressure lower that 0");
                        throw new RuntimeException(new InvalidInputException("WellFlow", "run:calcOutletPressure", "pressure", "- Outlet pressure is negative" + this.pressureOut));
                    }
                    this.outStream.setPressure(Math.sqrt(Math.pow(presRes, 2.0) - delta), "bara");
                    break;
                }
                double pwf = this.thermoSystem.getPressure("bara");
                double flow = this.fetkovichC * Math.pow(Math.pow(presRes, 2.0) - Math.pow(pwf, 2.0), this.fetkovichN);
                this.outStream.setFlowRate(flow, "MSm3/day");
                break;
            }
            default: {
                if (this.useWellProductionIndex) {
                    if (this.calcpressure) {
                        if (!(Math.pow(presRes, 2.0) - this.getInletStream().getFlowRate("MSm3/day") / this.wellProductionIndex > 0.0)) {
                            logger.error("pressure lower that 0");
                            throw new RuntimeException(new InvalidInputException("WellFlow", "run:calcOutletPressure", "pressure", "- Outlet pressure is negative" + this.pressureOut));
                        }
                        double presout = Math.sqrt(Math.pow(presRes, 2.0) - this.getInletStream().getFlowRate("MSm3/day") / this.wellProductionIndex);
                        this.outStream.setPressure(presout, "bara");
                        break;
                    }
                    double flow = this.wellProductionIndex * (Math.pow(presRes, 2.0) - Math.pow(this.thermoSystem.getPressure("bara"), 2.0));
                    this.outStream.setFlowRate(flow, "MSm3/day");
                    break;
                }
                this.wellProductionIndex = this.getInletStream().getFlowRate("MSm3/day") / (Math.pow(presRes, 2.0) - Math.pow(this.thermoSystem.getPressure("bara"), 2.0));
            }
        }
        this.outStream.run();
    }

    @Override
    public void runTransient(double dt, UUID id) {
        if (this.getCalculateSteadyState()) {
            this.run(id);
            this.increaseTime(dt);
            return;
        }
        double flow = this.wellProductionIndex * (Math.pow(this.getInletStream().getPressure("bara"), 2.0) - Math.pow(this.thermoSystem.getPressure("bara"), 2.0));
        this.outStream.setFlowRate(flow, "MSm3/day");
        this.outStream.run();
    }

    public double getWellProductionIndex() {
        return this.wellProductionIndex;
    }

    public void setWellProductionIndex(double wellProductionIndex) {
        this.useWellProductionIndex = true;
        this.wellProductionIndex = wellProductionIndex;
    }

    public void setVogelParameters(double qTest, double pwfTest, double reservoirPressure) {
        this.inflowModel = InflowPerformanceModel.VOGEL;
        this.useWellProductionIndex = false;
        this.vogelRefPres = reservoirPressure;
        this.vogelQmax = qTest / (1.0 - 0.2 * (pwfTest / reservoirPressure) - 0.8 * Math.pow(pwfTest / reservoirPressure, 2.0));
    }

    public void setFetkovichParameters(double c, double n, double reservoirPressure) {
        this.inflowModel = InflowPerformanceModel.FETKOVICH;
        this.useWellProductionIndex = false;
        this.fetkovichC = c;
        this.fetkovichN = n;
        this.vogelRefPres = reservoirPressure;
    }

    public void setDarcyLawParameters(double permeability, double thickness, double viscosity, double reservoirRadius, double wellRadius, double skinFactor) {
        double numerator = 0.00708 * permeability * thickness;
        double denominator = viscosity * (Math.log(reservoirRadius / wellRadius) + skinFactor);
        this.setWellProductionIndex(numerator / denominator);
    }

    public static enum InflowPerformanceModel {
        PRODUCTION_INDEX,
        VOGEL,
        FETKOVICH;

    }
}

