/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.separator;

import com.google.gson.GsonBuilder;
import java.util.UUID;
import neqsim.process.equipment.separator.Separator;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.util.monitor.SeparatorResponse;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;

public class ThreePhaseSeparator
extends Separator {
    private static final long serialVersionUID = 1000L;
    StreamInterface waterOutStream;
    String specifiedStream;
    double gasInAqueous;
    String gasInAqueousSpec;
    double gasInOil;
    String gasInOilSpec;
    double oilInGas;
    String oilInGasSpec;
    double oilInAqueous;
    String oilInAqueousSpec;
    double aqueousInGas;
    String aqueousInGasSpec;
    double aqueousInOil;
    String aqueousInOilSpec;
    boolean useTempMultiPhaseCheck;
    private double lastEnthalpy;
    private double lastFlowRate;
    private double lastPressure;

    public ThreePhaseSeparator(String name) {
        super(name);
        this.waterOutStream = new Stream("waterOutStream", this.waterSystem);
        this.specifiedStream = "feed";
        this.gasInAqueous = 0.0;
        this.gasInAqueousSpec = "mole";
        this.gasInOil = 0.0;
        this.gasInOilSpec = "mole";
        this.oilInGas = 0.0;
        this.oilInGasSpec = "mole";
        this.oilInAqueous = 0.0;
        this.oilInAqueousSpec = "mole";
        this.aqueousInGas = 0.0;
        this.aqueousInGasSpec = "mole";
        this.aqueousInOil = 0.0;
        this.aqueousInOilSpec = "mole";
        this.useTempMultiPhaseCheck = false;
    }

    public ThreePhaseSeparator(String name, StreamInterface inletStream) {
        super(name, inletStream);
        this.waterOutStream = new Stream("waterOutStream", this.waterSystem);
        this.specifiedStream = "feed";
        this.gasInAqueous = 0.0;
        this.gasInAqueousSpec = "mole";
        this.gasInOil = 0.0;
        this.gasInOilSpec = "mole";
        this.oilInGas = 0.0;
        this.oilInGasSpec = "mole";
        this.oilInAqueous = 0.0;
        this.oilInAqueousSpec = "mole";
        this.aqueousInGas = 0.0;
        this.aqueousInGasSpec = "mole";
        this.aqueousInOil = 0.0;
        this.aqueousInOilSpec = "mole";
        this.useTempMultiPhaseCheck = false;
    }

    public void setEntrainment(double val, String specType, String specifiedStream, String phaseFrom, String phaseTo) {
        this.specifiedStream = specifiedStream;
        if (phaseFrom.equals("gas") && phaseTo.equals("aqueous")) {
            this.gasInAqueous = val;
            this.gasInAqueousSpec = specType;
        }
        if (phaseFrom.equals("gas") && phaseTo.equals("oil")) {
            this.gasInOil = val;
            this.gasInOilSpec = specType;
        }
        if (phaseFrom.equals("oil") && phaseTo.equals("aqueous")) {
            this.oilInAqueous = val;
            this.oilInAqueousSpec = specType;
        }
        if (phaseFrom.equals("oil") && phaseTo.equals("gas")) {
            this.oilInGas = val;
            this.oilInGasSpec = specType;
        }
        if (phaseFrom.equals("aqueous") && phaseTo.equals("gas")) {
            this.aqueousInGas = val;
            this.aqueousInGasSpec = specType;
        }
        if (phaseFrom.equals("aqueous") && phaseTo.equals("oil")) {
            this.aqueousInOil = val;
            this.aqueousInOilSpec = specType;
        }
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        super.setInletStream(inletStream);
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.waterSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[1]);
        this.waterOutStream = new Stream("waterOutStream", this.waterSystem);
    }

    public StreamInterface getWaterOutStream() {
        return this.waterOutStream;
    }

    public StreamInterface getOilOutStream() {
        return this.liquidOutStream;
    }

    @Override
    public void run(UUID id) {
        this.inletStreamMixer.run(id);
        double enthalpy = this.inletStreamMixer.getOutletStream().getFluid().getEnthalpy();
        double flow = this.inletStreamMixer.getOutletStream().getFlowRate("kg/hr");
        double pres = this.inletStreamMixer.getOutletStream().getPressure();
        if (Math.abs((this.lastEnthalpy - enthalpy) / enthalpy) < 1.0E-6 && Math.abs((this.lastFlowRate - flow) / flow) < 1.0E-6 && Math.abs((this.lastPressure - pres) / pres) < 1.0E-6) {
            return;
        }
        this.lastEnthalpy = this.inletStreamMixer.getOutletStream().getFluid().getEnthalpy();
        this.lastFlowRate = this.inletStreamMixer.getOutletStream().getFlowRate("kg/hr");
        this.lastPressure = this.inletStreamMixer.getOutletStream().getPressure();
        this.thermoSystem = this.inletStreamMixer.getOutletStream().getThermoSystem().clone();
        if (!this.thermoSystem.doMultiPhaseCheck()) {
            this.useTempMultiPhaseCheck = true;
            this.thermoSystem.setMultiPhaseCheck(true);
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        thermoOps.TPflash();
        if (this.useTempMultiPhaseCheck) {
            this.thermoSystem.setMultiPhaseCheck(false);
        }
        this.thermoSystem.addPhaseFractionToPhase(this.gasInAqueous, this.gasInAqueousSpec, this.specifiedStream, "gas", "aqueous");
        this.thermoSystem.addPhaseFractionToPhase(this.gasInOil, this.gasInOilSpec, this.specifiedStream, "gas", "oil");
        this.thermoSystem.addPhaseFractionToPhase(this.oilInAqueous, this.oilInAqueousSpec, this.specifiedStream, "oil", "aqueous");
        this.thermoSystem.addPhaseFractionToPhase(this.oilInGas, this.oilInGasSpec, this.specifiedStream, "oil", "gas");
        this.thermoSystem.addPhaseFractionToPhase(this.aqueousInGas, this.aqueousInGasSpec, this.specifiedStream, "aqueous", "gas");
        this.thermoSystem.addPhaseFractionToPhase(this.aqueousInOil, this.aqueousInOilSpec, this.specifiedStream, "aqueous", "oil");
        if (this.thermoSystem.hasPhaseType("gas")) {
            this.gasOutStream.setThermoSystemFromPhase(this.thermoSystem, "gas");
            this.gasOutStream.run(id);
        } else {
            this.gasOutStream.setThermoSystem(this.thermoSystem.getEmptySystemClone());
        }
        if (this.thermoSystem.hasPhaseType("oil")) {
            this.liquidOutStream.setThermoSystemFromPhase(this.thermoSystem, "oil");
            this.liquidOutStream.run(id);
        } else {
            this.liquidOutStream.setThermoSystem(this.thermoSystem.getEmptySystemClone());
        }
        if (this.thermoSystem.hasPhaseType("aqueous")) {
            this.waterOutStream.setThermoSystemFromPhase(this.thermoSystem, "aqueous");
            this.waterOutStream.run(id);
        } else {
            this.waterOutStream.setThermoSystem(this.thermoSystem.getEmptySystemClone());
        }
        this.setCalculationIdentifier(id);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
        this.thermoSystem.display("from here " + this.getName());
    }

    @Override
    public double getEntropyProduction(String unit) {
        double entrop = 0.0;
        for (int i = 0; i < this.numberOfInputStreams; ++i) {
            this.inletStreamMixer.getStream(i).getFluid().init(3);
            entrop += this.inletStreamMixer.getStream(i).getFluid().getEntropy(unit);
        }
        this.getWaterOutStream().getThermoSystem().init(3);
        this.getOilOutStream().getThermoSystem().init(3);
        this.getGasOutStream().getThermoSystem().init(3);
        return this.getWaterOutStream().getThermoSystem().getEntropy(unit) + this.getOilOutStream().getThermoSystem().getEntropy(unit) + this.getGasOutStream().getThermoSystem().getEntropy(unit) - entrop;
    }

    @Override
    public double getExergyChange(String unit, double surroundingTemperature) {
        double entrop = 0.0;
        for (int i = 0; i < this.numberOfInputStreams; ++i) {
            this.inletStreamMixer.getStream(i).getFluid().init(3);
            entrop += this.inletStreamMixer.getStream(i).getFluid().getExergy(surroundingTemperature, unit);
        }
        this.getWaterOutStream().getThermoSystem().init(3);
        this.getOilOutStream().getThermoSystem().init(3);
        this.getGasOutStream().getThermoSystem().init(3);
        return this.getWaterOutStream().getThermoSystem().getExergy(surroundingTemperature, unit) + this.getOilOutStream().getThermoSystem().getEntropy(unit) + this.getGasOutStream().getThermoSystem().getExergy(surroundingTemperature, unit) - entrop;
    }

    @Override
    public String toJson() {
        return new GsonBuilder().create().toJson(new SeparatorResponse(this));
    }
}

