/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.splitter;

import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentSplitter
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ComponentSplitter.class);
    SystemInterface thermoSystem;
    StreamInterface inletStream;
    StreamInterface[] splitStream;
    protected int splitNumber = 1;
    double[] splitFactor = new double[1];

    public ComponentSplitter(String name) {
        super(name);
    }

    public ComponentSplitter(String name, StreamInterface inletStream) {
        this(name);
        this.setInletStream(inletStream);
    }

    public void setSplitFactors(double[] factors) {
        this.splitFactor = factors;
    }

    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        this.splitStream = new Stream[2];
        try {
            for (int i = 0; i < this.splitStream.length; ++i) {
                this.splitStream[i] = new Stream("Split Stream_" + i, inletStream.getThermoSystem().clone());
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public StreamInterface getSplitStream(int i) {
        return this.splitStream[i];
    }

    @Override
    public void run(UUID id) {
        for (int i = 0; i < 2; ++i) {
            this.thermoSystem = this.inletStream.getThermoSystem().clone();
            this.thermoSystem.setEmptyFluid();
            if (i == 0) {
                for (k = 0; k < this.thermoSystem.getNumberOfComponents(); ++k) {
                    this.thermoSystem.addComponent(k, this.inletStream.getThermoSystem().getComponent(k).getNumberOfmoles() * this.splitFactor[k]);
                }
            } else {
                for (k = 0; k < this.thermoSystem.getNumberOfComponents(); ++k) {
                    this.thermoSystem.addComponent(k, this.inletStream.getThermoSystem().getComponent(k).getNumberOfmoles() * (1.0 - this.splitFactor[k]));
                }
            }
            this.thermoSystem.init(0);
            this.splitStream[i].setThermoSystem(this.thermoSystem);
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.splitStream[i].getThermoSystem());
            thermoOps.TPflash();
        }
        this.setCalculationIdentifier(id);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
    }
}

