/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.util;

import java.util.UUID;
import neqsim.physicalproperties.PhysicalPropertyType;
import neqsim.process.equipment.TwoPortEquipment;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MPFMfitter
extends TwoPortEquipment {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(MPFMfitter.class);
    double pressure = 1.01325;
    double temperature = 15.0;
    private String referenceConditions = "standard";
    private boolean fitAsGVF = false;
    private double GOR = 120.0;
    private double GVF;
    String unitT = "C";
    String unitP = "bara";
    SystemInterface referenceFluidPackage = null;

    @Deprecated
    public MPFMfitter() {
        super("MPFMfitter fitter");
    }

    @Deprecated
    public MPFMfitter(StreamInterface stream) {
        this("MPFMfitter", stream);
    }

    public MPFMfitter(String name, StreamInterface stream) {
        super(name, stream);
    }

    public double getGFV() {
        return this.GVF;
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inStream = inletStream;
        try {
            this.outStream = inletStream.clone();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public double getPressure() {
        return this.pressure;
    }

    public void setPressure(double pressure, String unitP) {
        this.pressure = pressure;
        this.unitP = unitP;
    }

    @Override
    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature, String unitT) {
        this.temperature = temperature;
        this.unitT = unitT;
    }

    @Override
    public void run(UUID id) {
        int i;
        SystemInterface tempFluid = this.inStream.getThermoSystem().clone();
        double flow = tempFluid.getFlowRate("kg/sec");
        if (this.GOR < 1.0E-15) {
            this.outStream.setThermoSystem(tempFluid);
            return;
        }
        if (flow < 1.0E-6) {
            this.outStream.setThermoSystem(tempFluid);
            return;
        }
        if (this.GOR == 0.0 && tempFluid.hasPhaseType("gas")) {
            tempFluid.removePhase(0);
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
            try {
                thermoOps.TPflash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            this.outStream.setThermoSystem(tempFluid);
            return;
        }
        if (!this.getReferenceConditions().equals("actual")) {
            tempFluid.setTemperature(15.0, "C");
            tempFluid.setPressure(1.01325, "bara");
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
        try {
            thermoOps.TPflash();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (!tempFluid.hasPhaseType("gas") || !tempFluid.hasPhaseType("oil")) {
            this.outStream = this.inStream.clone();
            return;
        }
        tempFluid.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
        double currGOR = tempFluid.getPhase("gas").getCorrectedVolume() / tempFluid.getPhase("oil").getCorrectedVolume();
        if (this.fitAsGVF) {
            this.GOR = tempFluid.getPhase("oil").getCorrectedVolume() * this.getGOR() / (tempFluid.getPhase("oil").getCorrectedVolume() - tempFluid.getPhase("oil").getCorrectedVolume() * this.getGOR());
        }
        double dev = this.getGOR() / currGOR;
        double[] moleChange = new double[tempFluid.getNumberOfComponents()];
        for (i = 0; i < tempFluid.getNumberOfComponents(); ++i) {
            moleChange[i] = (dev - 1.0) * tempFluid.getPhase("gas").getComponent(i).getNumberOfMolesInPhase();
        }
        tempFluid.init(0);
        for (i = 0; i < tempFluid.getNumberOfComponents(); ++i) {
            tempFluid.addComponent(i, moleChange[i]);
        }
        tempFluid.setPressure(this.inStream.getThermoSystem().getPressure());
        tempFluid.setTemperature(this.inStream.getThermoSystem().getTemperature());
        tempFluid.setTotalFlowRate(flow, "kg/sec");
        try {
            thermoOps.TPflash();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        tempFluid.initProperties();
        this.outStream.setThermoSystem(tempFluid);
        this.GVF = !tempFluid.hasPhaseType("gas") ? 0.0 : (tempFluid.hasPhaseType("gas") && tempFluid.hasPhaseType("oil") ? tempFluid.getPhase("gas").getCorrectedVolume() / (tempFluid.getPhase("oil").getCorrectedVolume() + tempFluid.getPhase("gas").getCorrectedVolume()) : Double.NaN);
        this.outStream.setCalculationIdentifier(id);
        this.setCalculationIdentifier(id);
    }

    public double getGOR() {
        return this.GOR;
    }

    public void setGOR(double gOR) {
        this.fitAsGVF = false;
        this.GOR = gOR;
    }

    public void setGVF(double gvf) {
        this.fitAsGVF = true;
        this.GOR = gvf;
    }

    public String getReferenceConditions() {
        return this.referenceConditions;
    }

    public void setReferenceConditions(String referenceConditions) {
        this.referenceConditions = referenceConditions;
    }

    public boolean isFitAsGVF() {
        return this.fitAsGVF;
    }

    public void setFitAsGVF(boolean fitAsGVF) {
        this.fitAsGVF = fitAsGVF;
    }

    public SystemInterface getReferenceFluidPackage() {
        return this.referenceFluidPackage;
    }

    public void setReferenceFluidPackage(SystemInterface referenceFluidPackage) {
        this.referenceFluidPackage = referenceFluidPackage;
    }
}

