/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.util;

import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.equipment.compressor.Compressor;
import neqsim.process.equipment.heatexchanger.Cooler;
import neqsim.process.equipment.heatexchanger.Heater;
import neqsim.process.equipment.pump.Pump;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.valve.ThrottlingValve;
import neqsim.process.processmodel.ProcessSystem;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetPoint
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(SetPoint.class);
    ProcessEquipmentInterface sourceEquipment = null;
    ProcessEquipmentInterface targetEquipment = null;
    String sourceVariable = "";
    String targetVariable = "";
    String targetPhase = "";
    String targetComponent = "";
    double targetValue = 0.0;
    String targetUnit = "";
    double inputValue = 0.0;
    double oldInputValue = 0.0;

    @Deprecated
    public SetPoint() {
        this("SetPoint");
    }

    public SetPoint(String name) {
        super(name);
    }

    public SetPoint(String name, ProcessEquipmentInterface targetEquipment, String targetVariable, ProcessEquipmentInterface sourceEquipment) {
        this(name);
        this.targetEquipment = targetEquipment;
        this.targetVariable = targetVariable;
        this.sourceEquipment = sourceEquipment;
    }

    public void setSourceVariable(ProcessEquipmentInterface adjustedEquipment, String adjstedVariable) {
        this.sourceEquipment = adjustedEquipment;
        this.sourceVariable = adjstedVariable;
        this.targetVariable = adjstedVariable;
    }

    public void setSourceVariable(ProcessEquipmentInterface adjustedEquipment) {
        this.sourceEquipment = adjustedEquipment;
    }

    public void setTargetVariable(ProcessEquipmentInterface targetEquipment, String targetVariable, double targetValue, String targetUnit) {
        this.targetEquipment = targetEquipment;
        this.targetVariable = targetVariable;
        this.targetValue = targetValue;
        this.targetUnit = targetUnit;
    }

    public void setTargetVariable(ProcessEquipmentInterface targetEquipment, String targetVariable) {
        this.targetEquipment = targetEquipment;
        this.targetVariable = targetVariable;
    }

    public void setTargetVariable(ProcessEquipmentInterface targetEquipment) {
        this.targetEquipment = targetEquipment;
    }

    public void setTargetVariable(ProcessEquipmentInterface targetEquipment, String targetVariable, double targetValue, String targetUnit, String targetPhase) {
        this.targetEquipment = targetEquipment;
        this.targetVariable = targetVariable;
        this.targetValue = targetValue;
        this.targetUnit = targetUnit;
        this.targetPhase = targetPhase;
    }

    public void setTargetVariable(ProcessEquipmentInterface targetEquipment, String targetVariable, double targetValue, String targetUnit, String targetPhase, String targetComponent) {
        this.targetEquipment = targetEquipment;
        this.targetVariable = targetVariable;
        this.targetValue = targetValue;
        this.targetUnit = targetUnit;
        this.targetPhase = targetPhase;
        this.targetComponent = targetComponent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(UUID id) {
        if (!(this.sourceEquipment instanceof Stream)) {
            throw new RuntimeException("only Stream supproted as  sourceEquipment");
        }
        if (this.targetEquipment instanceof Stream) {
            if (this.targetVariable.equals("pressure")) {
                this.targetEquipment.setPressure(this.sourceEquipment.getPressure());
            } else if (this.targetVariable.equals("temperature")) {
                this.targetEquipment.setTemperature(this.sourceEquipment.getTemperature());
            } else {
                this.inputValue = ((Stream)this.sourceEquipment).getThermoSystem().getNumberOfMoles();
                double targetValueCurrent = ((Stream)this.targetEquipment).getThermoSystem().getVolume(this.targetUnit);
                double deviation = this.targetValue - targetValueCurrent;
                logger.info("adjuster deviation " + deviation + " inputValue " + this.inputValue);
                this.oldInputValue = this.inputValue;
            }
        } else if (this.targetEquipment instanceof ThrottlingValve) {
            if (!this.targetVariable.equals("pressure")) throw new RuntimeException(this.targetVariable + " adjustment is not supported for ThrottlingValve.");
            ((ThrottlingValve)this.targetEquipment).setOutletPressure(this.sourceEquipment.getPressure());
        } else if (this.targetEquipment instanceof Compressor) {
            if (!this.targetVariable.equals("pressure")) throw new RuntimeException(this.targetVariable + " adjustment is not supported for Compressor.");
            ((Compressor)this.targetEquipment).setOutletPressure(this.sourceEquipment.getPressure());
        } else if (this.targetEquipment instanceof Pump) {
            if (!this.targetVariable.equals("pressure")) throw new RuntimeException(this.targetVariable + " adjustment is not supported for Pump.");
            ((Pump)this.targetEquipment).setOutletPressure(this.sourceEquipment.getPressure());
        } else if (this.targetEquipment instanceof Heater || this.targetEquipment instanceof Cooler) {
            if (this.targetVariable.equals("pressure")) {
                ((Heater)this.targetEquipment).setOutletPressure(this.sourceEquipment.getPressure());
            } else {
                if (!this.targetVariable.equals("temperature")) throw new RuntimeException(this.targetVariable + " adjustment is not supported for Heater.");
                ((Heater)this.targetEquipment).setOutTemperature(this.sourceEquipment.getTemperature());
            }
        }
        this.setCalculationIdentifier(id);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(298.15, 20.0);
        testSystem.addComponent("methane", 1000.0);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        Stream stream_1 = new Stream("Stream1", testSystem);
        SetPoint adjuster1 = new SetPoint();
        adjuster1.setSourceVariable(stream_1, "molarFlow");
        adjuster1.setTargetVariable(stream_1, "gasVolumeFlow", 10.0, "", "MSm3/day");
        ProcessSystem operations = new ProcessSystem();
        operations.add(stream_1);
        operations.add(adjuster1);
        operations.run();
    }
}

