/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.measurementdevice;

import neqsim.process.measurementdevice.MeasurementDeviceInterface;
import neqsim.process.measurementdevice.online.OnlineSignal;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import neqsim.util.NamedBaseClass;

public abstract class MeasurementDeviceBaseClass
extends NamedBaseClass
implements MeasurementDeviceInterface {
    private static final long serialVersionUID = 1000L;
    protected String unit;
    private double maximumValue = 1.0;
    private double minimumValue = 0.0;
    private boolean logging = false;
    private OnlineSignal onlineSignal = null;
    private boolean isOnlineSignal = false;
    private double onlineMeasurementValue = 0.0;
    private String onlineMeasurementValueUnit = "";
    private boolean conditionAnalysis = true;
    private String conditionAnalysisMessage = "";
    private double conditionAnalysisMaxDeviation = 0.0;

    public MeasurementDeviceBaseClass(String name, String unit) {
        super(name);
        this.setUnit(unit);
    }

    @Override
    public OnlineSignal getOnlineSignal() {
        return this.onlineSignal;
    }

    public void setOnlineSignal(OnlineSignal onlineSignal) {
        this.onlineSignal = onlineSignal;
    }

    @Override
    public boolean isOnlineSignal() {
        return this.isOnlineSignal;
    }

    public void setIsOnlineSignal(boolean isOnlineSignal, String plantName, String transmitterame) {
        this.isOnlineSignal = isOnlineSignal;
        this.onlineSignal = new OnlineSignal(plantName, transmitterame);
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Override
    public double getMaximumValue() {
        return this.maximumValue;
    }

    @Override
    public void setMaximumValue(double maximumValue) {
        this.maximumValue = maximumValue;
    }

    @Override
    public double getMinimumValue() {
        return this.minimumValue;
    }

    @Override
    public void setMinimumValue(double minimumValue) {
        this.minimumValue = minimumValue;
    }

    @Override
    public double getMeasuredPercentValue() {
        return (this.getMeasuredValue() - this.minimumValue) / (this.maximumValue - this.minimumValue) * 100.0;
    }

    @Override
    public boolean isLogging() {
        return this.logging;
    }

    @Override
    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    @Override
    public double getMeasuredValue(String unit) {
        return 0.0;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
        System.out.println("measured value: " + this.getMeasuredValue());
    }

    public void setOnlineMeasurementValue(double value, String unit) {
        this.onlineMeasurementValue = value;
        this.onlineMeasurementValueUnit = unit;
    }

    public double getOnlineMeasurementValue() {
        return this.onlineMeasurementValue;
    }

    public boolean doConditionAnalysis() {
        return this.conditionAnalysis;
    }

    public void setConditionAnalysis(boolean conditionMonitor) {
        this.conditionAnalysis = conditionMonitor;
    }

    public void runConditionAnalysis() {
        this.conditionAnalysisMessage = Math.abs(this.getMeasuredValue(this.onlineMeasurementValueUnit) - this.onlineMeasurementValue) < this.getConditionAnalysisMaxDeviation() ? "ok" : "fail";
    }

    public String getConditionAnalysisMessage() {
        return this.conditionAnalysisMessage;
    }

    public void setQualityCheckMessage(String conditionAnalysisMessage) {
        this.conditionAnalysisMessage = conditionAnalysisMessage;
    }

    public double getConditionAnalysisMaxDeviation() {
        return this.conditionAnalysisMaxDeviation;
    }

    public void setConditionAnalysisMaxDeviation(double conditionAnalysisMaxDeviation) {
        this.conditionAnalysisMaxDeviation = conditionAnalysisMaxDeviation;
    }
}

