/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.measurementdevice;

import neqsim.physicalproperties.PhysicalPropertyType;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.measurementdevice.StreamMeasurementDeviceBaseClass;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiPhaseMeter
extends StreamMeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(MultiPhaseMeter.class);
    double pressure = 1.01325;
    double temperature = 288.15;
    String unitT;
    String unitP;

    public MultiPhaseMeter(StreamInterface stream) {
        this("Multi Phase Meter", stream);
    }

    public MultiPhaseMeter(String name, StreamInterface stream) {
        super(name, "kg/hr", stream);
    }

    public double getPressure() {
        return this.pressure;
    }

    public void setPressure(double pressure, String unitP) {
        this.pressure = pressure;
        this.unitP = unitP;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature, String unitT) {
        this.temperature = temperature;
        this.unitT = unitT;
    }

    @Override
    public double getMeasuredValue(String unit) {
        return this.stream.getThermoSystem().getFlowRate(unit);
    }

    public double getMeasuredValue(String measurement, String unit) {
        if (measurement.equals("mass rate")) {
            return this.stream.getFlowRate(unit);
        }
        if (this.stream.getFlowRate("kg/hr") < 1.0E-10) {
            return Double.NaN;
        }
        if (measurement.equals("GOR")) {
            SystemInterface tempFluid = this.stream.getFluid().clone();
            tempFluid.setTemperature(this.temperature, this.unitT);
            tempFluid.setPressure(this.pressure, this.unitP);
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
            try {
                thermoOps.TPflash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                return Double.NaN;
            }
            if (!tempFluid.hasPhaseType("gas")) {
                return Double.NaN;
            }
            if (!tempFluid.hasPhaseType("oil")) {
                return Double.NaN;
            }
            tempFluid.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            return tempFluid.getPhase("gas").getCorrectedVolume() / tempFluid.getPhase("oil").getCorrectedVolume();
        }
        if (measurement.equals("Gas Flow Rate")) {
            SystemInterface tempFluid = this.stream.getThermoSystem().clone();
            tempFluid.setTemperature(this.temperature, this.unitT);
            tempFluid.setPressure(this.pressure, this.unitP);
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
            try {
                thermoOps.TPflash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                return Double.NaN;
            }
            if (!tempFluid.hasPhaseType("gas")) {
                return Double.NaN;
            }
            tempFluid.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            return tempFluid.getPhase("gas").getFlowRate(unit);
        }
        if (measurement.equals("Oil Flow Rate")) {
            SystemInterface tempFluid = this.stream.getThermoSystem().clone();
            tempFluid.setTemperature(this.temperature, this.unitT);
            tempFluid.setPressure(this.pressure, this.unitP);
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
            try {
                thermoOps.TPflash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                return Double.NaN;
            }
            if (!tempFluid.hasPhaseType("oil")) {
                return Double.NaN;
            }
            tempFluid.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            return tempFluid.getPhase("oil").getFlowRate(unit);
        }
        if (measurement.equals("Water Flow Rate")) {
            SystemInterface tempFluid = this.stream.getThermoSystem().clone();
            tempFluid.setTemperature(this.temperature, this.unitT);
            tempFluid.setPressure(this.pressure, this.unitP);
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
            try {
                thermoOps.TPflash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                return Double.NaN;
            }
            if (!tempFluid.hasPhaseType("aqueous")) {
                return Double.NaN;
            }
            tempFluid.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            return tempFluid.getPhase("aqueous").getFlowRate(unit);
        }
        if (measurement.equals("gasDensity") || measurement.equals("oilDensity") || measurement.equals("waterDensity")) {
            SystemInterface tempFluid = this.stream.getThermoSystem().clone();
            tempFluid.setTemperature(this.temperature, this.unitT);
            tempFluid.setPressure(this.pressure, this.unitP);
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
            try {
                thermoOps.TPflash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                return Double.NaN;
            }
            tempFluid.initPhysicalProperties();
            if (measurement.equals("gasDensity")) {
                if (!tempFluid.hasPhaseType("gas")) {
                    return 0.0;
                }
                return tempFluid.getPhase("gas").getDensity("kg/m3");
            }
            if (measurement.equals("oilDensity")) {
                if (!tempFluid.hasPhaseType("oil")) {
                    return 0.0;
                }
                return tempFluid.getPhase("oil").getDensity("kg/m3");
            }
            if (measurement.equals("waterDensity") && tempFluid.hasPhaseType("aqueous")) {
                return tempFluid.getPhase("aqueous").getDensity("kg/m3");
            }
            return 0.0;
        }
        if (measurement.equals("GOR_std")) {
            SystemInterface tempFluid = this.stream.getThermoSystem().clone();
            tempFluid.setTemperature(15.0, "C");
            tempFluid.setPressure(1.01325, "bara");
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
            try {
                thermoOps.TPflash();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                return Double.NaN;
            }
            if (!tempFluid.hasPhaseType("gas")) {
                return Double.NaN;
            }
            if (!tempFluid.hasPhaseType("oil")) {
                return Double.NaN;
            }
            tempFluid.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            double GOR_in_sm3_sm3 = tempFluid.getPhase("gas").getFlowRate("Sm3/hr") / tempFluid.getPhase("oil").getFlowRate("m3/hr");
            double GOR_via_corrected_volume = tempFluid.getPhase("gas").getCorrectedVolume() / tempFluid.getPhase("oil").getCorrectedVolume();
            return tempFluid.getPhase("gas").getCorrectedVolume() / tempFluid.getPhase("oil").getCorrectedVolume();
        }
        logger.warn("Measurement type " + measurement + " is not found");
        return 0.0;
    }
}

