/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.measurementdevice;

import java.util.Arrays;
import java.util.List;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.measurementdevice.StreamMeasurementDeviceBaseClass;

public class NMVOCAnalyser
extends StreamMeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1000L;

    public NMVOCAnalyser(StreamInterface stream) {
        this("NM VOC Analyser", stream);
    }

    public NMVOCAnalyser(String name, StreamInterface stream) {
        super(name, "kg/hr", stream);
    }

    @Override
    public double getMeasuredValue(String unit) {
        return this.getnmVOCFlowRate(unit);
    }

    public double getnmVOCFlowRate(String unit) {
        List<String> nmVOCcomponents = Arrays.asList("ethane", "propane", "i-butane", "n-butane", "i-pentane", "n-pentane", "n-hexane", "n-heptane", "benzene", "nC8", "nC9", "nC10", "nC11");
        double flow = 0.0;
        for (int i = 0; i < this.stream.getFluid().getNumberOfComponents(); ++i) {
            String name = this.stream.getFluid().getComponent(i).getName();
            if (!nmVOCcomponents.contains(name)) continue;
            flow += this.stream.getFluid().getComponent(i).getFlowRate(unit);
        }
        return flow;
    }
}

