/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign.designstandards;

import java.sql.ResultSet;
import neqsim.process.mechanicaldesign.MechanicalDesign;
import neqsim.process.mechanicaldesign.designstandards.DesignStandard;
import neqsim.util.database.NeqSimProcessDesignDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompressorDesignStandard
extends DesignStandard {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(CompressorDesignStandard.class);
    private double compressorFactor = 0.11;

    public CompressorDesignStandard(String name, MechanicalDesign equipmentInn) {
        super(name, equipmentInn);
        try (NeqSimProcessDesignDataBase database = new NeqSimProcessDesignDataBase();){
            try (ResultSet dataSet = database.getResultSet("SELECT * FROM technicalrequirements_process WHERE EQUIPMENTTYPE='Compressor' AND Company='" + this.standardName + "'");){
                while (dataSet.next()) {
                    String specName = dataSet.getString("SPECIFICATION");
                    if (!specName.equals("compressorFactor")) continue;
                    this.compressorFactor = Double.parseDouble(dataSet.getString("MAXVALUE"));
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public double getCompressorFactor() {
        return this.compressorFactor;
    }

    public void setCompressorFactor(double compressorFactor) {
        this.compressorFactor = compressorFactor;
    }
}

