/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign.pipeline;

import java.util.HashMap;
import java.util.Map;

public class PipeDesign {
    private static final double INCH_TO_M = 0.0254;
    private static final double FOOT_TO_M = 0.3048;
    private static final double LB_FT3_TO_KG_M3 = 16.01846337;
    public static final double[] NPS5 = new double[]{0.5, 0.75, 1.0, 1.25, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 5.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 30.0};
    public static final double[] S5i = new double[]{18.0, 23.4, 30.1, 38.9, 45.0, 57.0, 68.78, 84.68, 97.38, 110.08, 135.76, 162.76, 213.56, 266.2, 315.88, 347.68, 398.02, 448.62, 498.44, 549.44, 598.92, 749.3};
    public static final double[] S5o = new double[]{21.3, 26.7, 33.4, 42.2, 48.3, 60.3, 73.0, 88.9, 101.6, 114.3, 141.3, 168.3, 219.1, 273.0, 323.8, 355.6, 406.4, 457.0, 508.0, 559.0, 610.0, 762.0};
    public static final double[] S5t = new double[]{1.65, 1.65, 1.65, 1.65, 1.65, 1.65, 2.11, 2.11, 2.11, 2.11, 2.77, 2.77, 2.77, 3.4, 3.96, 3.96, 4.19, 4.19, 4.78, 4.78, 5.54, 6.35};
    public static final double[] NPS10 = new double[]{0.125, 0.25, 0.375, 0.5, 0.75, 1.0, 1.25, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 5.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 26.0, 28.0, 30.0, 32.0, 34.0, 36.0};
    public static final double[] S10i = new double[]{7.82, 10.4, 13.8, 17.08, 22.48, 27.86, 36.66, 42.76, 54.76, 66.9, 82.8, 95.5, 108.2, 134.5, 161.5, 211.58, 264.62, 314.66, 342.9, 393.7, 444.3, 495.3, 546.3, 597.3, 644.16, 695.16, 746.16, 797.16, 848.16, 898.16};
    public static final double[] S10o = new double[]{10.3, 13.7, 17.1, 21.3, 26.7, 33.4, 42.2, 48.3, 60.3, 73.0, 88.9, 101.6, 114.3, 141.3, 168.3, 219.1, 273.0, 323.8, 355.6, 406.4, 457.0, 508.0, 559.0, 610.0, 660.0, 711.0, 762.0, 813.0, 864.0, 914.0};
    public static final double[] S10t = new double[]{1.24, 1.65, 1.65, 2.11, 2.11, 2.77, 2.77, 2.77, 2.77, 3.05, 3.05, 3.05, 3.05, 3.4, 3.4, 3.76, 4.19, 4.57, 6.35, 6.35, 6.35, 6.35, 6.35, 6.35, 7.92, 7.92, 7.92, 7.92, 7.92, 7.92};
    public static final double[] NPS20 = new double[]{8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 26.0, 28.0, 30.0, 32.0, 34.0, 36.0};
    public static final double[] S20i = new double[]{206.4, 260.3, 311.1, 339.76, 390.56, 441.16, 488.94, 539.94, 590.94, 634.6, 685.6, 736.6, 787.6, 838.6, 888.6};
    public static final double[] S20o = new double[]{219.1, 273.0, 323.8, 355.6, 406.4, 457.0, 508.0, 559.0, 610.0, 660.0, 711.0, 762.0, 813.0, 864.0, 914.0};
    public static final double[] S20t = new double[]{6.35, 6.35, 6.35, 7.92, 7.92, 7.92, 9.53, 9.53, 9.53, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7};
    public static final double[] NPS30 = new double[]{0.125, 0.25, 0.375, 0.5, 0.75, 1.0, 1.25, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 28.0, 30.0, 32.0, 34.0, 36.0};
    public static final double[] S30i = new double[]{7.4, 10.0, 13.4, 16.48, 21.88, 27.6, 36.26, 41.94, 53.94, 63.44, 79.34, 92.04, 104.74, 205.02, 257.4, 307.04, 336.54, 387.34, 434.74, 482.6, 533.6, 581.46, 679.24, 730.24, 781.24, 832.24, 882.24};
    public static final double[] S30o = new double[]{10.3, 13.7, 17.1, 21.3, 26.7, 33.4, 42.2, 48.3, 60.3, 73.0, 88.9, 101.6, 114.3, 219.1, 273.0, 323.8, 355.6, 406.4, 457.0, 508.0, 559.0, 610.0, 711.0, 762.0, 813.0, 864.0, 914.0};
    public static final double[] S30t = new double[]{1.45, 1.85, 1.85, 2.41, 2.41, 2.9, 2.97, 3.18, 3.18, 4.78, 4.78, 4.78, 4.78, 7.04, 7.8, 8.38, 9.53, 9.53, 11.13, 12.7, 12.7, 14.27, 15.88, 15.88, 15.88, 15.88, 15.88};
    public static final double[] NPS40 = new double[]{0.125, 0.25, 0.375, 0.5, 0.75, 1.0, 1.25, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 5.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 24.0, 32.0, 34.0, 36.0};
    public static final double[] S40i = new double[]{6.84, 9.22, 12.48, 15.76, 20.96, 26.64, 35.08, 40.94, 52.48, 62.68, 77.92, 90.12, 102.26, 128.2, 154.08, 202.74, 254.46, 303.18, 333.34, 381.0, 428.46, 477.82, 575.04, 778.04, 829.04, 875.9};
    public static final double[] S40o = new double[]{10.3, 13.7, 17.1, 21.3, 26.7, 33.4, 42.2, 48.3, 60.3, 73.0, 88.9, 101.6, 114.3, 141.3, 168.3, 219.1, 273.0, 323.8, 355.6, 406.4, 457.0, 508.0, 610.0, 813.0, 864.0, 914.0};
    public static final double[] S40t = new double[]{1.73, 2.24, 2.31, 2.77, 2.87, 3.38, 3.56, 3.68, 3.91, 5.16, 5.49, 5.74, 6.02, 6.55, 7.11, 8.18, 9.27, 10.31, 11.13, 12.7, 14.27, 15.09, 17.48, 17.48, 17.48, 19.05};
    public static final double[] NPS60 = new double[]{8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0};
    public static final double[] S60i = new double[]{198.48, 247.6, 295.26, 325.42, 373.08, 418.9, 466.76, 514.54, 560.78};
    public static final double[] S60o = new double[]{219.1, 273.0, 323.8, 355.6, 406.4, 457.0, 508.0, 559.0, 610.0};
    public static final double[] S60t = new double[]{10.31, 12.7, 14.27, 15.09, 16.66, 19.05, 20.62, 22.23, 24.61};
    public static final double[] NPS80 = new double[]{0.125, 0.25, 0.375, 0.5, 0.75, 1.0, 1.25, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 5.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0};
    public static final double[] S80i = new double[]{5.48, 7.66, 10.7, 13.84, 18.88, 24.3, 32.5, 38.14, 49.22, 58.98, 73.66, 85.44, 97.18, 122.24, 146.36, 193.7, 242.82, 288.84, 317.5, 363.52, 409.34, 455.62, 501.84, 548.08};
    public static final double[] S80o = new double[]{10.3, 13.7, 17.1, 21.3, 26.7, 33.4, 42.2, 48.3, 60.3, 73.0, 88.9, 101.6, 114.3, 141.3, 168.3, 219.1, 273.0, 323.8, 355.6, 406.4, 457.0, 508.0, 559.0, 610.0};
    public static final double[] S80t = new double[]{2.41, 3.02, 3.2, 3.73, 3.91, 4.55, 4.85, 5.08, 5.54, 7.01, 7.62, 8.08, 8.56, 9.53, 10.97, 12.7, 15.09, 17.48, 19.05, 21.44, 23.83, 26.19, 28.58, 30.96};
    public static final double[] NPS100 = new double[]{8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0};
    public static final double[] S100i = new double[]{188.92, 236.48, 280.92, 307.94, 354.02, 398.28, 442.92, 489.14, 532.22};
    public static final double[] S100o = new double[]{219.1, 273.0, 323.8, 355.6, 406.4, 457.0, 508.0, 559.0, 610.0};
    public static final double[] S100t = new double[]{15.09, 18.26, 21.44, 23.83, 26.19, 29.36, 32.54, 34.93, 38.89};
    public static final double[] NPS120 = new double[]{4.0, 5.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0};
    public static final double[] S120i = new double[]{92.04, 115.9, 139.76, 182.58, 230.12, 273.0, 300.02, 344.48, 387.14, 431.8, 476.44, 517.96};
    public static final double[] S120o = new double[]{114.3, 141.3, 168.3, 219.1, 273.0, 323.8, 355.6, 406.4, 457.0, 508.0, 559.0, 610.0};
    public static final double[] S120t = new double[]{11.13, 12.7, 14.27, 18.26, 21.44, 25.4, 27.79, 30.96, 34.93, 38.1, 41.28, 46.02};
    public static final double[] NPS140 = new double[]{8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0};
    public static final double[] S140i = new double[]{177.86, 222.2, 266.64, 292.1, 333.34, 377.66, 419.1, 463.74, 505.26};
    public static final double[] S140o = new double[]{219.1, 273.0, 323.8, 355.6, 406.4, 457.0, 508.0, 559.0, 610.0};
    public static final double[] S140t = new double[]{20.62, 25.4, 28.58, 31.75, 36.53, 39.67, 44.45, 47.63, 52.37};
    public static final double[] NPS160 = new double[]{0.5, 0.75, 1.0, 1.25, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0};
    public static final double[] S160i = new double[]{11.74, 15.58, 20.7, 29.5, 34.02, 42.82, 53.94, 66.64, 87.32, 109.54, 131.78, 173.08, 215.84, 257.16, 284.18, 325.42, 366.52, 407.98, 451.04, 490.92};
    public static final double[] S160o = new double[]{21.3, 26.7, 33.4, 42.2, 48.3, 60.3, 73.0, 88.9, 114.3, 141.3, 168.3, 219.1, 273.0, 323.8, 355.6, 406.4, 457.0, 508.0, 559.0, 610.0};
    public static final double[] S160t = new double[]{4.78, 5.56, 6.35, 6.35, 7.14, 8.74, 9.53, 11.13, 13.49, 15.88, 18.26, 23.01, 28.58, 33.32, 35.71, 40.49, 45.24, 50.01, 53.98, 59.54};
    public static final double[] NPSSTD = new double[]{0.125, 0.25, 0.375, 0.5, 0.75, 1.0, 1.25, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 5.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 26.0, 28.0, 30.0, 32.0, 34.0, 36.0, 38.0, 40.0, 42.0, 44.0, 46.0, 48.0};
    public static final double[] STDi = new double[]{6.84, 9.22, 12.48, 15.76, 20.96, 26.64, 35.08, 40.94, 52.48, 62.68, 77.92, 90.12, 102.26, 128.2, 154.08, 202.74, 254.46, 304.74, 336.54, 387.34, 437.94, 488.94, 539.94, 590.94, 640.94, 691.94, 742.94, 793.94, 844.94, 894.94, 945.94, 996.94, 1047.94, 1098.94, 1148.94, 1199.94};
    public static final double[] STDo = new double[]{10.3, 13.7, 17.1, 21.3, 26.7, 33.4, 42.2, 48.3, 60.3, 73.0, 88.9, 101.6, 114.3, 141.3, 168.3, 219.1, 273.0, 323.8, 355.6, 406.4, 457.0, 508.0, 559.0, 610.0, 660.0, 711.0, 762.0, 813.0, 864.0, 914.0, 965.0, 1016.0, 1067.0, 1118.0, 1168.0, 1219.0};
    public static final double[] STDt = new double[]{1.73, 2.24, 2.31, 2.77, 2.87, 3.38, 3.56, 3.68, 3.91, 5.16, 5.49, 5.74, 6.02, 6.55, 7.11, 8.18, 9.27, 9.53, 9.53, 9.53, 9.53, 9.53, 9.53, 9.53, 9.53, 9.53, 9.53, 9.53, 9.53, 9.53, 9.53, 9.53, 9.53, 9.53, 9.53, 9.53};
    public static final double[] NPSXS = new double[]{0.125, 0.25, 0.375, 0.5, 0.75, 1.0, 1.25, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 5.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 26.0, 28.0, 30.0, 32.0, 34.0, 36.0, 38.0, 40.0, 42.0, 44.0, 46.0, 48.0};
    public static final double[] XSi = new double[]{5.48, 7.66, 10.7, 13.84, 18.88, 24.3, 32.5, 38.14, 49.22, 58.98, 73.66, 85.44, 97.18, 122.24, 146.36, 193.7, 247.6, 298.4, 330.2, 381.0, 431.6, 482.6, 533.6, 584.6, 634.6, 685.6, 736.6, 787.6, 838.6, 888.6, 939.6, 990.6, 1041.6, 1092.6, 1142.6, 1193.6};
    public static final double[] XSo = new double[]{10.3, 13.7, 17.1, 21.3, 26.7, 33.4, 42.2, 48.3, 60.3, 73.0, 88.9, 101.6, 114.3, 141.3, 168.3, 219.1, 273.0, 323.8, 355.6, 406.4, 457.0, 508.0, 559.0, 610.0, 660.0, 711.0, 762.0, 813.0, 864.0, 914.0, 965.0, 1016.0, 1067.0, 1118.0, 1168.0, 1219.0};
    public static final double[] XSt = new double[]{2.41, 3.02, 3.2, 3.73, 3.91, 4.55, 4.85, 5.08, 5.54, 7.01, 7.62, 8.08, 8.56, 9.53, 10.97, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7, 12.7};
    public static final double[] NPSXXS = new double[]{0.5, 0.75, 1.0, 1.25, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0, 6.0, 8.0, 10.0, 12.0};
    public static final double[] XXSi = new double[]{6.36, 11.06, 15.22, 22.8, 28.0, 38.16, 44.96, 58.42, 80.06, 103.2, 124.4, 174.64, 222.2, 273.0};
    public static final double[] XXSo = new double[]{21.3, 26.7, 33.4, 42.2, 48.3, 60.3, 73.0, 88.9, 114.3, 141.3, 168.3, 219.1, 273.0, 323.8};
    public static final double[] XXSt = new double[]{7.47, 7.82, 9.09, 9.7, 10.15, 11.07, 14.02, 15.24, 17.12, 19.05, 21.95, 22.23, 25.4, 25.4};
    public static final double[] NPSS5 = new double[]{0.5, 0.75, 1.0, 1.25, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 5.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 30.0};
    public static final double[] SS5DN = new double[]{15.0, 20.0, 25.0, 32.0, 40.0, 50.0, 65.0, 80.0, 90.0, 100.0, 125.0, 150.0, 200.0, 250.0, 300.0, 350.0, 400.0, 450.0, 500.0, 550.0, 600.0, 750.0};
    public static final double[] SS5i = new double[]{18.0, 23.4, 30.1, 38.9, 45.0, 57.0, 68.78, 84.68, 97.38, 110.08, 135.76, 162.76, 213.56, 266.3, 315.98, 347.68, 398.02, 448.62, 498.44, 549.44, 598.92, 749.3};
    public static final double[] SS5o = new double[]{21.3, 26.7, 33.4, 42.2, 48.3, 60.3, 73.0, 88.9, 101.6, 114.3, 141.3, 168.3, 219.1, 273.1, 323.9, 355.6, 406.4, 457.0, 508.0, 559.0, 610.0, 762.0};
    public static final double[] SS5t = new double[]{1.65, 1.65, 1.65, 1.65, 1.65, 1.65, 2.11, 2.11, 2.11, 2.11, 2.77, 2.77, 2.77, 3.4, 3.96, 3.96, 4.19, 4.19, 4.78, 4.78, 5.54, 6.35};
    public static final Map<String, ScheduleData> scheduleLookup = new HashMap<String, ScheduleData>();
    public static final double[] SSWG_integers;
    public static final double[] SSWG_inch;
    public static final double[] SSWG_SI;
    public static final double[] BWG_integers;
    public static final double[] BWG_inch;
    public static final double[] BWG_SI;
    public static final Map<String, WireScheduleData> wireSchedules;

    private static double[] DiLookup(double DiMm, double[] NPSes, double[] Dis, double[] Dos, double[] ts) {
        if (DiMm > Dis[Dis.length - 1]) {
            return null;
        }
        for (int i = 0; i < Dis.length; ++i) {
            if (!(Dis[i] >= DiMm)) continue;
            return new double[]{NPSes[i], Dis[i], Dos[i], ts[i]};
        }
        throw new RuntimeException("Di lookup failed");
    }

    private static double[] DoLookup(double DoMm, double[] NPSes, double[] Dis, double[] Dos, double[] ts) {
        if (DoMm > Dos[Dos.length - 1]) {
            return null;
        }
        for (int i = 0; i < Dos.length; ++i) {
            if (!(Dos[i] >= DoMm)) continue;
            return new double[]{NPSes[i], Dis[i], Dos[i], ts[i]};
        }
        throw new RuntimeException("Do lookup failed");
    }

    private static double[] NPSLookup(double wantedNPS, double[] NPSes, double[] Dis, double[] Dos, double[] ts) {
        for (int i = 0; i < NPSes.length; ++i) {
            if (Double.compare(NPSes[i], wantedNPS) != 0) continue;
            return new double[]{NPSes[i], Dis[i], Dos[i], ts[i]};
        }
        throw new RuntimeException("NPS not in list: " + wantedNPS);
    }

    public static double[] nearestPipe(Double Do, Double Di, Double NPS, String schedule) {
        if (!scheduleLookup.containsKey(schedule)) {
            throw new IllegalArgumentException("Schedule not recognized: " + schedule);
        }
        ScheduleData sd = scheduleLookup.get(schedule);
        Double DoMm = Do == null ? null : Double.valueOf(Do * 1000.0);
        Double DiMm = Di == null ? null : Double.valueOf(Di * 1000.0);
        double[] result = null;
        if (DiMm != null) {
            result = PipeDesign.DiLookup(DiMm, sd.nps, sd.dis, sd.dos, sd.ts);
        } else if (DoMm != null) {
            result = PipeDesign.DoLookup(DoMm, sd.nps, sd.dis, sd.dos, sd.ts);
        } else if (NPS != null) {
            result = PipeDesign.NPSLookup(NPS, sd.nps, sd.dis, sd.dos, sd.ts);
        } else {
            throw new IllegalArgumentException("Must provide Do, Di, or NPS");
        }
        if (result == null) {
            throw new IllegalArgumentException("Input diameter is larger than max of selected schedule.");
        }
        double foundNPS = result[0];
        double foundDi = result[1] / 1000.0;
        double foundDo = result[2] / 1000.0;
        double foundT = result[3] / 1000.0;
        return new double[]{foundNPS, foundDi, foundDo, foundT};
    }

    public static double gaugeFromThickness(double t, boolean SI, String schedule) {
        WireScheduleData wsd = wireSchedules.get(schedule);
        if (wsd == null) {
            throw new IllegalArgumentException("Wire gauge schedule not found: " + schedule);
        }
        double tInch = SI ? t / 0.0254 : t;
        double largest = wsd.thicknessInch[0];
        double smallest = wsd.thicknessInch[wsd.thicknessInch.length - 1];
        if (tInch > largest) {
            throw new IllegalArgumentException("Thickness bigger than largest in schedule: " + tInch + " > " + largest);
        }
        double tol = 0.1;
        for (int i = 0; i < wsd.thicknessInch.length; ++i) {
            if (!(Math.abs(tInch - wsd.thicknessInch[i]) < 1.0E-12)) continue;
            return wsd.gaugeNumbers[i];
        }
        double nextLargerVal = wsd.thicknessInch[wsd.thicknessInch.length - 1];
        int idxLarger = -1;
        for (int i = 0; i < wsd.thicknessInch.length; ++i) {
            if (!(wsd.thicknessInch[i] >= tInch)) continue;
            nextLargerVal = wsd.thicknessInch[i];
            idxLarger = i;
            break;
        }
        if (idxLarger == -1) {
            return wsd.gaugeNumbers[wsd.thicknessInch.length - 1];
        }
        if (idxLarger == 0) {
            return wsd.gaugeNumbers[0];
        }
        double smallerVal = wsd.thicknessInch[idxLarger - 1];
        double delta = nextLargerVal - smallerVal;
        if (tInch - smallerVal <= tol * delta) {
            return wsd.gaugeNumbers[idxLarger - 1];
        }
        return wsd.gaugeNumbers[idxLarger];
    }

    public static double thicknessFromGauge(double gauge, boolean SI, String schedule) {
        WireScheduleData wsd = wireSchedules.get(schedule);
        if (wsd == null) {
            throw new IllegalArgumentException("Wire gauge schedule not found: " + schedule);
        }
        int idx = -1;
        for (int i = 0; i < wsd.gaugeNumbers.length; ++i) {
            if (Double.compare(wsd.gaugeNumbers[i], gauge) != 0) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            throw new IllegalArgumentException("Gauge not found in schedule: " + gauge);
        }
        return SI ? wsd.thicknessM[idx] : wsd.thicknessInch[idx];
    }

    public static double erosionalVelocity(double rho, double C) {
        double rho_lb_ft3 = rho / 16.01846337;
        double v_ft_s = C / Math.sqrt(rho_lb_ft3);
        return v_ft_s * 0.3048;
    }

    public static void main(String[] args) {
        double[] res = PipeDesign.nearestPipe(null, 0.021, null, "40");
        System.out.printf("nearestPipe(Di=0.021, schedule=40) => NPS=%.3f, Di=%.6f m, Do=%.6f m, t=%.6f m%n", res[0], res[1], res[2], res[3]);
        double gaugeBWG = PipeDesign.gaugeFromThickness(0.5, false, "BWG");
        System.out.println("Gauge from thickness=0.5 inch => " + gaugeBWG);
        double thickBWG = PipeDesign.thicknessFromGauge(0.2, false, "BWG");
        System.out.println("Thickness from gauge=0.2 => " + thickBWG + " inches (BWG)");
        double vErode = PipeDesign.erosionalVelocity(1000.0, 100.0);
        System.out.println("Erosional velocity for rho=1000, C=100 => " + vErode + " m/s");
    }

    static {
        scheduleLookup.put("5", new ScheduleData(NPS5, S5i, S5o, S5t));
        scheduleLookup.put("10", new ScheduleData(NPS10, S10i, S10o, S10t));
        scheduleLookup.put("20", new ScheduleData(NPS20, S20i, S20o, S20t));
        scheduleLookup.put("30", new ScheduleData(NPS30, S30i, S30o, S30t));
        scheduleLookup.put("40", new ScheduleData(NPS40, S40i, S40o, S40t));
        scheduleLookup.put("60", new ScheduleData(NPS60, S60i, S60o, S60t));
        scheduleLookup.put("80", new ScheduleData(NPS80, S80i, S80o, S80t));
        scheduleLookup.put("100", new ScheduleData(NPS100, S100i, S100o, S100t));
        scheduleLookup.put("120", new ScheduleData(NPS120, S120i, S120o, S120t));
        scheduleLookup.put("140", new ScheduleData(NPS140, S140i, S140o, S140t));
        scheduleLookup.put("160", new ScheduleData(NPS160, S160i, S160o, S160t));
        scheduleLookup.put("STD", new ScheduleData(NPSSTD, STDi, STDo, STDt));
        scheduleLookup.put("XS", new ScheduleData(NPSXS, XSi, XSo, XSt));
        scheduleLookup.put("XXS", new ScheduleData(NPSXXS, XXSi, XXSo, XXSt));
        scheduleLookup.put("5S", new ScheduleData(NPSS5, SS5i, SS5o, SS5t));
        SSWG_integers = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0};
        SSWG_inch = new double[]{0.227, 0.219, 0.212, 0.207, 0.204, 0.201, 0.199, 0.197, 0.194, 0.191, 0.188, 0.185, 0.182, 0.18, 0.178, 0.175, 0.172, 0.168, 0.164, 0.161, 0.157, 0.155, 0.153, 0.151, 0.148, 0.146, 0.143, 0.139, 0.134, 0.127, 0.12, 0.115, 0.112, 0.11, 0.108, 0.106, 0.103, 0.101, 0.099, 0.097, 0.095, 0.092, 0.088, 0.085, 0.081, 0.079, 0.077, 0.075, 0.072, 0.069, 0.066, 0.063, 0.058, 0.055, 0.05, 0.045, 0.042, 0.041, 0.04, 0.039, 0.038, 0.037, 0.036, 0.035, 0.033, 0.032, 0.031, 0.03, 0.029, 0.027, 0.026, 0.024, 0.023, 0.022, 0.02, 0.018, 0.016, 0.015, 0.014, 0.013};
        SSWG_SI = new double[]{0.0057658, 0.0055626, 0.0053848, 0.0052578, 0.0051816, 0.0051054, 0.0050546, 0.0050038, 0.0049276, 0.0048514, 0.0047752, 0.004699, 0.0046228, 0.004572, 0.0045212, 0.004445, 0.0043688, 0.0042672, 0.0041656, 0.0040894, 0.0039878, 0.003937, 0.0038862, 0.0038354, 0.0037592, 0.0037084, 0.0036322, 0.0035306, 0.0034036, 0.0032258, 0.003048, 0.002921, 0.0028448, 0.002794, 0.0027432, 0.0026924, 0.0026162, 0.0025654, 0.0025146, 0.0024638, 0.002413, 0.0023368, 0.0022352, 0.002159, 0.0020574, 0.0020066, 0.0019558, 0.001905, 0.0018288, 0.0017526, 0.0016764, 0.0016002, 0.0014732, 0.001397, 0.00127, 0.001143, 0.0010668, 0.0010414, 0.001016, 9.906E-4, 9.652E-4, 9.398E-4, 9.144E-4, 8.89E-4, 8.382E-4, 8.128E-4, 7.874E-4, 7.62E-4, 7.366E-4, 6.858E-4, 6.604E-4, 6.096E-4, 5.842E-4, 5.588E-4, 5.08E-4, 4.572E-4, 4.064E-4, 3.81E-4, 3.556E-4, 3.302E-4};
        BWG_integers = new double[]{0.2, 0.25, 0.33, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0};
        BWG_inch = new double[]{0.5, 0.454, 0.425, 0.38, 0.34, 0.3, 0.284, 0.259, 0.238, 0.22, 0.203, 0.18, 0.165, 0.148, 0.134, 0.12, 0.109, 0.095, 0.083, 0.072, 0.065, 0.058, 0.049, 0.042, 0.035, 0.032, 0.028, 0.025, 0.022, 0.02, 0.018, 0.016, 0.014, 0.013, 0.012, 0.01, 0.009, 0.008, 0.007, 0.005, 0.004};
        BWG_SI = new double[]{0.0127, 0.011532, 0.010795, 0.009652, 0.008636, 0.00762, 0.007214, 0.006579, 0.006045, 0.005588, 0.005156, 0.004572, 0.004191, 0.003759, 0.003404, 0.003048, 0.002769, 0.002413, 0.002108, 0.001829, 0.001651, 0.001473, 0.001245, 0.001067, 8.89E-4, 8.13E-4, 7.11E-4, 6.35E-4, 5.59E-4, 5.08E-4, 4.57E-4, 4.06E-4, 3.56E-4, 3.3E-4, 3.05E-4, 2.54E-4, 2.29E-4, 2.03E-4, 1.78E-4, 1.27E-4, 1.02E-4};
        wireSchedules = new HashMap<String, WireScheduleData>();
        wireSchedules.put("BWG", new WireScheduleData(BWG_integers, BWG_inch, BWG_SI, true));
        wireSchedules.put("SSWG", new WireScheduleData(SSWG_integers, SSWG_inch, SSWG_SI, true));
    }

    public static class ScheduleData {
        public final double[] nps;
        public final double[] dis;
        public final double[] dos;
        public final double[] ts;

        public ScheduleData(double[] nps, double[] dis, double[] dos, double[] ts) {
            this.nps = nps;
            this.dis = dis;
            this.dos = dos;
            this.ts = ts;
        }
    }

    public static class WireScheduleData {
        public final double[] gaugeNumbers;
        public final double[] thicknessInch;
        public final double[] thicknessM;
        public final boolean something;

        public WireScheduleData(double[] gaugeNumbers, double[] thicknessInch, double[] thicknessM, boolean something) {
            this.gaugeNumbers = gaugeNumbers;
            this.thicknessInch = thicknessInch;
            this.thicknessM = thicknessM;
            this.something = something;
        }
    }
}

