/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.processmodel.processmodules;

import java.util.UUID;
import neqsim.process.equipment.separator.Separator;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.processmodel.ProcessModuleBaseClass;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CO2RemovalModule
extends ProcessModuleBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(CO2RemovalModule.class);
    protected StreamInterface streamToAbsorber = null;
    protected StreamInterface streamFromAbsorber = null;
    protected StreamInterface gasFromCO2Stripper = null;
    protected Separator inletSeparator = null;

    public CO2RemovalModule(String name) {
        super(name);
    }

    @Override
    public void addInputStream(String streamName, StreamInterface stream) {
        if (streamName.equals("streamToAbsorber")) {
            this.streamToAbsorber = stream;
        }
    }

    @Override
    public StreamInterface getOutputStream(String streamName) {
        if (!this.isInitializedStreams) {
            this.initializeStreams();
        }
        if (streamName.equals("streamFromAbsorber")) {
            return this.streamFromAbsorber;
        }
        return null;
    }

    @Override
    public void run(UUID id) {
        if (!this.isInitializedModule) {
            this.initializeModule();
        }
        this.getOperations().run(id);
        this.streamFromAbsorber = this.inletSeparator.getGasOutStream().clone();
        this.streamFromAbsorber.getThermoSystem().addComponent("CO2", -this.streamFromAbsorber.getThermoSystem().getPhase(0).getComponent("CO2").getNumberOfMolesInPhase() * 0.99);
        this.streamFromAbsorber.getThermoSystem().addComponent("MEG", -this.streamFromAbsorber.getThermoSystem().getPhase(0).getComponent("MEG").getNumberOfMolesInPhase() * 0.99);
        this.streamFromAbsorber.getThermoSystem().init(1);
        this.setCalculationIdentifier(id);
    }

    @Override
    public void initializeStreams() {
        this.isInitializedStreams = true;
        try {
            this.streamFromAbsorber = this.streamToAbsorber.clone("Stream from Absorber");
            this.gasFromCO2Stripper = this.streamToAbsorber.clone("Gas stream from Stripper");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void initializeModule() {
        this.isInitializedModule = true;
        this.inletSeparator = new Separator("inletSeparator", this.streamToAbsorber);
        this.getOperations().add(this.inletSeparator);
    }

    @Override
    public void calcDesign() {
    }

    @Override
    public void setDesign() {
    }
}

