/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.util.monitor;

import neqsim.process.equipment.distillation.DistillationColumn;
import neqsim.process.util.monitor.BaseResponse;

public class DistillationColumnResponse
extends BaseResponse {
    public Double massBalanceError;
    public Double[] trayTemperature;
    public Double[] trayPressure;
    public int numberOfTrays;
    public Double[] trayVaporFlowRate;
    public Double[] trayLiquidFlowRate;
    public Double[] trayFeedFlow;
    public Double[] trayMassBalance;

    public DistillationColumnResponse(DistillationColumn column) {
        super(column);
        int i;
        this.massBalanceError = column.getMassBalanceError();
        int numberOfTrays = column.getNumerOfTrays();
        this.trayTemperature = new Double[numberOfTrays];
        this.trayMassBalance = new Double[numberOfTrays];
        this.trayVaporFlowRate = new Double[numberOfTrays];
        this.trayLiquidFlowRate = new Double[numberOfTrays];
        this.trayFeedFlow = new Double[numberOfTrays];
        this.trayFeedFlow = new Double[numberOfTrays];
        for (i = 0; i < numberOfTrays; ++i) {
            this.trayFeedFlow[i] = column.getTray(i).getFeedRate("kg/hr");
        }
        for (i = 0; i < numberOfTrays; ++i) {
            this.trayMassBalance[i] = column.getTray(i).massBalance();
        }
        this.trayPressure = new Double[numberOfTrays];
        for (i = 0; i < numberOfTrays; ++i) {
            this.trayTemperature[i] = column.getTray(i).getTemperature() - 273.15;
            this.trayPressure[i] = column.getTray(i).getPressure("bara");
            this.trayVaporFlowRate[i] = column.getTray(i).getVaporFlowRate("kg/hr");
            this.trayLiquidFlowRate[i] = column.getTray(i).getLiquidFlowRate("kg/hr");
        }
    }
}

