/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.util.monitor;

import java.util.HashMap;
import neqsim.process.util.monitor.Value;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.unit.Units;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidComponentResponse {
    static Logger logger = LogManager.getLogger(FluidComponentResponse.class);
    public String name;
    public HashMap<String, HashMap<String, Value>> properties = new HashMap();

    public FluidComponentResponse(SystemInterface inputFluid) {
        this(inputFluid.getFluidName(), inputFluid);
    }

    public FluidComponentResponse(String nameinp) {
        this.name = nameinp;
    }

    public FluidComponentResponse(String fluidname, SystemInterface fluid) {
        this(fluidname);
        this.name = fluidname;
        SystemInterface inputFluid = fluid.clone();
        inputFluid.init(0);
        HashMap<String, Value> newdata = new HashMap<String, Value>();
        for (int i = 0; i < inputFluid.getNumberOfComponents(); ++i) {
            String name = inputFluid.getPhase(0).getComponent(i).getComponentName();
            ComponentInterface component = inputFluid.getPhase(0).getComponent(i);
            PhaseInterface phase = inputFluid.getPhase(0);
            newdata = new HashMap();
            newdata.put("Acentric Factor", new Value(Double.toString(component.getAcentricFactor()), "-"));
            newdata.put("Mole Fraction", new Value(Double.toString(component.getz()), "-"));
            newdata.put("Weigth Fraction", new Value(Double.toString(phase.getWtFrac(i)), "-"));
            newdata.put("Critical Temperature", new Value(Double.toString(component.getTC(Units.getSymbol("temperature"))), Units.getSymbol("temperature")));
            newdata.put("Critical Pressure", new Value(Double.toString(component.getPC(Units.getSymbol("pressure"))), Units.getSymbol("pressure")));
            newdata.put("Normal Liquid Density", new Value(Double.toString(component.getNormalLiquidDensity(Units.getSymbol("density"))), Units.getSymbol("density")));
            this.properties.put(name, newdata);
        }
    }

    SystemInterface getNeqSimFluid() {
        SystemSrkEos tempFluid = new SystemSrkEos();
        return tempFluid;
    }

    public void print() {
    }
}

