/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.util.monitor;

import neqsim.process.equipment.pipeline.PipeBeggsAndBrills;
import neqsim.process.util.monitor.BaseResponse;

public class PipeBeggsBrillsResponse
extends BaseResponse {
    public Double inletPressure;
    public Double outletPressure;
    public Double inletTemperature;
    public Double outletTemperature;
    public Double inletDensity;
    public Double outletDensity;
    public Double inletVolumeFlow;
    public Double outletVolumeFlow;
    public Double inletMassFlow;
    public Double outletMassFlow;

    public PipeBeggsBrillsResponse(PipeBeggsAndBrills pipe) {
        super(pipe);
        this.inletPressure = pipe.getInletStream().getPressure("bara");
        this.outletPressure = pipe.getOutletStream().getPressure("bara");
        this.inletTemperature = pipe.getInletStream().getTemperature("C");
        this.outletTemperature = pipe.getOutletStream().getTemperature("C");
        this.inletDensity = pipe.getInletStream().getFluid().getDensity("kg/m3");
        this.outletDensity = pipe.getOutletStream().getFluid().getDensity("kg/m3");
        this.inletVolumeFlow = pipe.getInletStream().getFluid().getFlowRate("m3/hr");
        this.outletVolumeFlow = pipe.getOutletStream().getFluid().getFlowRate("m3/hr");
        this.inletMassFlow = pipe.getInletStream().getFluid().getFlowRate("kg/hr");
        this.outletMassFlow = pipe.getOutletStream().getFluid().getFlowRate("kg/hr");
    }
}

