/*
 * Decompiled with CFR 0.152.
 */
package neqsim.pvtsimulation.simulation;

import java.util.ArrayList;
import neqsim.physicalproperties.util.parameterfitting.purecomponentparameterfitting.purecompviscosity.linearliquidmodel.ViscosityFunction;
import neqsim.pvtsimulation.simulation.BasePVTsimulation;
import neqsim.statistics.parameterfitting.SampleSet;
import neqsim.statistics.parameterfitting.SampleValue;
import neqsim.statistics.parameterfitting.nonlinearparameterfitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DensitySim
extends BasePVTsimulation {
    static Logger logger = LogManager.getLogger(DensitySim.class);
    double[] temperature = new double[1];
    double[] pressure = new double[1];
    private double[] waxFraction = null;
    private double[] gasDensity;
    private double[] oilDensity;
    private double[] aqueousDensity;

    public DensitySim(SystemInterface tempSystem) {
        super(tempSystem);
        this.temperature[0] = tempSystem.getTemperature();
        this.pressure[0] = tempSystem.getPressure();
    }

    public void setTemperaturesAndPressures(double[] temperature, double[] pressure) {
        this.pressure = pressure;
        this.temperature = temperature;
        this.experimentalData = new double[temperature.length][1];
    }

    public void runTuning() {
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        try {
            System.out.println("adding....");
            for (int i = 0; i < this.experimentalData[0].length; ++i) {
                ViscosityFunction function = new ViscosityFunction();
                double[] guess = new double[]{1.0};
                function.setInitialGuess(guess);
                SystemInterface tempSystem = this.getThermoSystem();
                tempSystem.setTemperature(this.temperature[i]);
                tempSystem.setPressure(this.pressure[i]);
                this.thermoOps.TPflash();
                double[] sample1 = new double[]{this.temperature[i]};
                double viscosity = this.experimentalData[0][i];
                double[] standardDeviation1 = new double[]{1.5};
                SampleValue sample = new SampleValue(viscosity, viscosity / 50.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(tempSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error", (Throwable)ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        this.optimizer = new LevenbergMarquardt();
        this.optimizer.setMaxNumberOfIterations(20);
        this.optimizer.setSampleSet(sampleSet);
        this.optimizer.solve();
        this.runCalc();
        this.optimizer.displayCurveFit();
    }

    public void runCalc() {
        this.gasDensity = new double[this.pressure.length];
        this.oilDensity = new double[this.pressure.length];
        this.aqueousDensity = new double[this.pressure.length];
        this.waxFraction = new double[this.pressure.length];
        for (int i = 0; i < this.pressure.length; ++i) {
            this.getThermoSystem().setPressure(this.pressure[i]);
            this.getThermoSystem().setTemperature(this.temperature[i]);
            this.thermoOps.TPflash();
            this.getThermoSystem().initPhysicalProperties();
            this.waxFraction[i] = 0.0;
            if (this.getThermoSystem().hasPhaseType("gas")) {
                this.gasDensity[i] = this.getThermoSystem().getPhase("gas").getPhysicalProperties().getViscosity();
            }
            if (this.getThermoSystem().hasPhaseType("oil")) {
                this.oilDensity[i] = this.getThermoSystem().getPhase("oil").getPhysicalProperties().getViscosity();
            }
            if (!this.getThermoSystem().hasPhaseType("aqueous")) continue;
            this.aqueousDensity[i] = this.getThermoSystem().getPhase("aqueous").getPhysicalProperties().getViscosity();
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        SystemSrkEos tempSystem = new SystemSrkEos(298.0, 10.0);
        tempSystem.addPlusFraction("C20", 10.62, 0.1, 0.73);
        tempSystem.createDatabase(true);
        tempSystem.setMixingRule(2);
        tempSystem.init(0);
        tempSystem.init(1);
        DensitySim sepSim = new DensitySim(tempSystem);
        double[] temps = new double[]{300.15, 293.15, 283.15, 273.15, 264.15};
        double[] pres = new double[]{5.0, 5.0, 5.0, 5.0, 5.0};
        sepSim.setTemperaturesAndPressures(temps, pres);
        sepSim.runCalc();
        double[][] expData = new double[][]{{2.0E-4, 3.0E-4, 4.0E-4, 5.0E-4, 6.0E-4}};
        sepSim.setExperimentalData(expData);
        sepSim.runCalc();
        double a = sepSim.getGasDensity()[0];
        double a2 = sepSim.getOilDensity()[0];
    }

    public double[] getWaxFraction() {
        return this.waxFraction;
    }

    public double[] getGasDensity() {
        return this.gasDensity;
    }

    public double[] getOilDensity() {
        return this.oilDensity;
    }

    public double[] getAqueousDensity() {
        return this.aqueousDensity;
    }
}

