/*
 * Decompiled with CFR 0.152.
 */
package neqsim.pvtsimulation.simulation;

import neqsim.pvtsimulation.simulation.BasePVTsimulation;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SlimTubeSim
extends BasePVTsimulation {
    static Logger logger = LogManager.getLogger(SlimTubeSim.class);
    SystemInterface inectionGasSystem = null;
    private int numberOfSlimTubeNodes = 200;
    SystemInterface[] slimTubeNodeSystem = null;

    public SlimTubeSim(SystemInterface tempSystem, SystemInterface injectionGas) {
        super(tempSystem);
        this.inectionGasSystem = injectionGas;
    }

    @Override
    public void run() {
        this.slimTubeNodeSystem = new SystemInterface[this.numberOfSlimTubeNodes + 1];
        this.getThermoSystem().setPressure(1.01325);
        this.getThermoSystem().setTemperature(288.15);
        this.thermoOps.TPflash();
        this.getThermoSystem().setPressure(this.getPressure());
        this.getThermoSystem().setTemperature(this.getTemperature());
        this.thermoOps.TPflash();
        if (this.getThermoSystem().getNumberOfPhases() > 1) {
            logger.debug("more than one phase at initial pressure and temperature.....stopping slimtube simulation.");
            return;
        }
        double standardNodeVolume = this.getThermoSystem().getPhase(0).getVolume();
        this.inectionGasSystem.setPressure(this.getPressure());
        this.inectionGasSystem.setTemperature(this.getTemperature());
        this.inectionGasSystem.init(0);
        this.inectionGasSystem.init(1);
        for (int i = 0; i < this.numberOfSlimTubeNodes + 1; ++i) {
            this.slimTubeNodeSystem[i] = this.getThermoSystem().clone();
        }
        this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].reset();
        this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].init(1);
        ThermodynamicOperations slimOps0 = new ThermodynamicOperations(this.slimTubeNodeSystem[0]);
        ThermodynamicOperations slimOps1 = new ThermodynamicOperations(this.slimTubeNodeSystem[0]);
        for (int timeStep = 0; timeStep < 200; ++timeStep) {
            this.slimTubeNodeSystem[0].addFluid(this.inectionGasSystem);
            slimOps0.setSystem(this.slimTubeNodeSystem[0]);
            slimOps0.TPflash();
            for (int i = 0; i < this.numberOfSlimTubeNodes; ++i) {
                double moles;
                int k;
                double liquidExcessVolume;
                double totalVolume = this.slimTubeNodeSystem[i].getVolume();
                double gasVolume = 0.0;
                int liquidPhaseNumber = 0;
                double excessVolume = totalVolume - standardNodeVolume;
                if (this.slimTubeNodeSystem[i].getNumberOfPhases() > 1) {
                    gasVolume = this.slimTubeNodeSystem[i].getPhase(0).getVolume();
                    liquidPhaseNumber = 1;
                }
                if ((liquidExcessVolume = totalVolume - standardNodeVolume - gasVolume) < 0.0) {
                    liquidExcessVolume = 0.0;
                }
                int numComp = this.slimTubeNodeSystem[0].getPhase(0).getNumberOfComponents();
                double[] removeMoles = new double[numComp];
                if (this.slimTubeNodeSystem[i].getNumberOfPhases() > 1) {
                    double gasExcessVolume = totalVolume - standardNodeVolume - liquidExcessVolume;
                    double gasfactor = gasExcessVolume / excessVolume;
                    if (gasExcessVolume < excessVolume) {
                        gasfactor = 1.0;
                    }
                    k = 0;
                    while (k < numComp) {
                        moles = this.slimTubeNodeSystem[i].getPhase(0).getComponent(k).getNumberOfMolesInPhase();
                        int n = k++;
                        removeMoles[n] = removeMoles[n] + gasfactor * moles;
                    }
                }
                if (liquidExcessVolume > 0.0) {
                    double liquidVolume = this.slimTubeNodeSystem[i].getPhase(liquidPhaseNumber).getVolume();
                    double liqfactor = liquidExcessVolume / liquidVolume;
                    k = 0;
                    while (k < numComp) {
                        moles = this.slimTubeNodeSystem[i].getPhase(liquidPhaseNumber).getComponent(k).getNumberOfMolesInPhase();
                        int n = k++;
                        removeMoles[n] = removeMoles[n] + moles * liqfactor;
                    }
                }
                for (int k2 = 0; k2 < numComp; ++k2) {
                    try {
                        if (removeMoles[k2] <= this.slimTubeNodeSystem[i].getComponent(k2).getNumberOfmoles()) {
                            this.slimTubeNodeSystem[i].addComponent(k2, -removeMoles[k2]);
                            this.slimTubeNodeSystem[i + 1].addComponent(k2, removeMoles[k2]);
                            continue;
                        }
                        this.slimTubeNodeSystem[i + 1].addComponent(k2, this.slimTubeNodeSystem[i].getComponent(k2).getNumberOfmoles());
                        this.slimTubeNodeSystem[i].addComponent(k2, -this.slimTubeNodeSystem[i].getComponent(k2).getNumberOfmoles());
                        continue;
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage());
                    }
                }
                slimOps0.setSystem(this.slimTubeNodeSystem[i]);
                slimOps0.TPflash();
                slimOps1.setSystem(this.slimTubeNodeSystem[i + 1]);
                slimOps1.TPflash();
            }
            this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].setTemperature(288.15);
            this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].setPressure(1.01325);
            slimOps1.TPflash();
        }
        this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].setTemperature(288.15);
        this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].setPressure(1.01325);
        slimOps1.TPflash();
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        SystemSrkEos gasSystem = new SystemSrkEos(298.0, 200.0);
        gasSystem.addComponent("CO2", 10.0);
        gasSystem.createDatabase(true);
        gasSystem.setMixingRule(2);
        SystemSrkEos oilSystem = new SystemSrkEos(298.0, 200.0);
        oilSystem.addComponent("CO2", 0.1);
        oilSystem.addComponent("methane", 1.5);
        oilSystem.addComponent("ethane", 1.5);
        oilSystem.addTBPfraction("C7", 1.06, 0.0922, 0.7324);
        oilSystem.addTBPfraction("C8", 1.06, 0.1046, 0.7602);
        oilSystem.addTBPfraction("C9", 0.79, 0.1191, 0.7677);
        oilSystem.addTBPfraction("C10", 0.57, 0.133, 0.79);
        oilSystem.addTBPfraction("C11", 0.38, 0.155, 0.795);
        oilSystem.addTBPfraction("C12", 0.37, 0.162, 0.806);
        oilSystem.addTBPfraction("C13", 0.32, 0.177, 0.824);
        oilSystem.addTBPfraction("C14", 0.27, 0.198, 0.835);
        oilSystem.addTBPfraction("C15", 0.23, 0.202, 0.84);
        oilSystem.addTBPfraction("C16", 0.19, 0.215, 0.846);
        oilSystem.addTBPfraction("C17", 0.17, 0.234, 0.84);
        oilSystem.addTBPfraction("C18", 0.13, 0.251, 0.844);
        oilSystem.addTBPfraction("C19", 0.13, 0.27, 0.854);
        oilSystem.addPlusFraction("C20", 10.62, 0.381, 0.88);
        oilSystem.getCharacterization().characterisePlusFraction();
        oilSystem.createDatabase(true);
        oilSystem.setMixingRule(2);
        SlimTubeSim sepSim = new SlimTubeSim(oilSystem, gasSystem);
        sepSim.setTemperature(373.15);
        sepSim.setPressure(380.0);
        sepSim.setNumberOfSlimTubeNodes(40);
        sepSim.run();
    }

    public int getNumberOfSlimTubeNodes() {
        return this.numberOfSlimTubeNodes;
    }

    public void setNumberOfSlimTubeNodes(int numberOfSlimTubeNodes) {
        this.numberOfSlimTubeNodes = numberOfSlimTubeNodes;
    }
}

