/*
 * Decompiled with CFR 0.152.
 */
package neqsim.pvtsimulation.simulation;

import java.util.ArrayList;
import neqsim.pvtsimulation.simulation.BasePVTsimulation;
import neqsim.pvtsimulation.util.parameterfitting.WaxFunction;
import neqsim.statistics.parameterfitting.SampleSet;
import neqsim.statistics.parameterfitting.SampleValue;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WaxFractionSim
extends BasePVTsimulation {
    static Logger logger = LogManager.getLogger(WaxFractionSim.class);
    double[] temperature = new double[1];
    double[] pressure = new double[1];
    private double[] waxFraction = null;
    double[] Sm3gas;
    double[] m3oil;
    private double[] Bofactor;
    private double[] GOR = null;
    double oilVolumeStdCond = 0.0;

    public WaxFractionSim(SystemInterface tempSystem) {
        super(tempSystem);
        this.temperature[0] = tempSystem.getTemperature();
        this.pressure[0] = tempSystem.getPressure();
    }

    public void setTemperaturesAndPressures(double[] temperature, double[] pressure) {
        this.pressure = pressure;
        this.temperature = temperature;
        this.experimentalData = new double[temperature.length][1];
    }

    public void runTuning() {
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        try {
            System.out.println("adding....");
            for (int i = 0; i < this.experimentalData[0].length; ++i) {
                ArrayList<Double> guessArray = new ArrayList<Double>();
                for (int p = 0; p < 3; ++p) {
                    guessArray.add(this.getThermoSystem().getWaxModel().getWaxParameters()[p]);
                }
                guessArray.add(this.getThermoSystem().getWaxModel().getParameterWaxHeatOfFusion()[0]);
                guessArray.add(this.getThermoSystem().getWaxModel().getParameterWaxTriplePointTemperature()[0]);
                double[] guess = new double[this.optimizer.getNumberOfTuningParameters()];
                for (int o = 0; o < guess.length; ++o) {
                    guess[o] = (Double)guessArray.get(o);
                }
                WaxFunction function = new WaxFunction();
                function.setInitialGuess(guess);
                SystemInterface tempSystem = this.getThermoSystem();
                tempSystem.setTemperature(this.temperature[i]);
                tempSystem.setPressure(this.pressure[i]);
                this.thermoOps.TPflash();
                double[] sample1 = new double[]{this.temperature[i]};
                double waxContent = this.experimentalData[0][i];
                double[] standardDeviation1 = new double[]{1.5};
                SampleValue sample = new SampleValue(waxContent, waxContent / 10.0 + 0.1, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(tempSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error", (Throwable)ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        this.optimizer.setSampleSet(sampleSet);
        this.optimizer.solve();
    }

    public void runCalc() {
        this.Sm3gas = new double[this.pressure.length];
        this.m3oil = new double[this.pressure.length];
        this.GOR = new double[this.pressure.length];
        this.waxFraction = new double[this.pressure.length];
        this.Bofactor = new double[this.pressure.length];
        for (int i = 0; i < this.pressure.length; ++i) {
            this.getThermoSystem().setPressure(this.pressure[i]);
            this.getThermoSystem().setTemperature(this.temperature[i]);
            this.thermoOps.TPflash();
            this.waxFraction[i] = 0.0;
            if (!this.getThermoSystem().hasPhaseType("wax")) continue;
            this.waxFraction[i] = this.getThermoSystem().getWtFraction(this.getThermoSystem().getPhaseNumberOfPhase("wax"));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        NeqSimDataBase.setConnectionString("jdbc:derby:C:/Users/esol/OneDrive - Equinor/temp/neqsimthermodatabase");
        NeqSimDataBase.setCreateTemporaryTables(true);
        SystemSrkEos tempSystem = new SystemSrkEos(298.0, 10.0);
        tempSystem.addComponent("methane", 6.78);
        tempSystem.addTBPfraction("C19", 10.13, 0.17, 0.7814);
        tempSystem.addPlusFraction("C20", 10.62, 0.381, 0.850871882888);
        tempSystem.getCharacterization().characterisePlusFraction();
        tempSystem.getWaxModel().addTBPWax();
        tempSystem.createDatabase(true);
        tempSystem.setMixingRule(2);
        tempSystem.addSolidComplexPhase("wax");
        tempSystem.setMultiphaseWaxCheck(true);
        tempSystem.setMultiPhaseCheck(true);
        tempSystem.init(0);
        tempSystem.init(1);
        NeqSimDataBase.setCreateTemporaryTables(false);
        WaxFractionSim sepSim = new WaxFractionSim(tempSystem);
        double[] temps = new double[]{293.15, 283.15, 273.15, 264.15, 263.0, 262.0, 261.0};
        double[] pres = new double[]{5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0};
        sepSim.setTemperaturesAndPressures(temps, pres);
        sepSim.runCalc();
        sepSim.getThermoSystem().display();
        double[][] expData = new double[][]{{4.0, 7.0, 9.0, 10.0, 11.0, 12.0, 13.0}};
        sepSim.setExperimentalData(expData);
        sepSim.getOptimizer().setNumberOfTuningParameters(3);
        sepSim.getOptimizer().setMaxNumberOfIterations(20);
        sepSim.runTuning();
        sepSim.runCalc();
    }

    public double[] getGOR() {
        return this.GOR;
    }

    public double[] getBofactor() {
        return this.Bofactor;
    }

    public double[] getWaxFraction() {
        return this.waxFraction;
    }
}

