/*
 * Decompiled with CFR 0.152.
 */
package neqsim.standards.gasquality;

import neqsim.standards.Standard;
import neqsim.thermo.system.SystemInterface;
import org.apache.commons.math3.analysis.interpolation.BicubicInterpolatingFunction;
import org.apache.commons.math3.analysis.interpolation.BicubicInterpolator;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;

public class Standard_ISO6578
extends Standard {
    private static final long serialVersionUID = 1000L;
    double LNGdensity = 0.0;
    String densityUnit = "kg/m^3";
    double KMcorrectionFactor1 = 0.0;
    double KMcorrectionFactor2 = 0.0;
    double[] Vi = null;
    boolean use6578volumeCorrectionFactors = true;
    double[] temperatures = new double[]{105.0, 110.0, 115.0, 120.0, 125.0, 130.0, 135.0};
    double[] molarMasses = new double[]{16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0};
    double[][] KMKMcorrectionFactor1Matrix = new double[][]{{-0.007, -0.008, -0.009, -0.01, -0.013, -0.015, -0.017}, {0.165, 0.19, 0.22, 0.25, 0.295, 0.345, 0.4}, {0.34, 0.375, 0.44, 0.5, 0.59, 0.7, 0.825}, {0.475, 0.535, 0.61, 0.695, 0.795, 0.92, 1.06}, {0.635, 0.725, 0.81, 0.92, 1.035, 1.2, 1.39}, {0.735, 0.835, 0.945, 1.055, 1.21, 1.37, 1.59}, {0.84, 0.95, 1.065, 1.205, 1.385, 1.555, 1.8}, {0.92, 1.055, 1.18, 1.33, 1.525, 1.715, 1.95}, {1.045, 1.155, 1.28, 1.45, 1.64, 1.86, 2.105}, {1.12, 1.245, 1.38, 1.55, 1.75, 1.99, 2.272}};
    double[][] KMKMcorrectionFactor2Matrix = new double[][]{{-0.01, -0.015, -0.024, -0.032, -0.043, -0.058, -0.075}, {0.24, 0.32, 0.41, 0.6, 0.71, 0.95, 1.3}, {0.42, 0.59, 0.72, 0.91, 1.13, 1.46, 2.0}, {0.61, 0.77, 0.95, 1.23, 1.48, 1.92, 2.4}, {0.75, 0.92, 1.15, 1.43, 1.73, 2.2, 2.6}, {0.91, 1.07, 1.22, 1.63, 1.98, 2.42, 3.0}, {1.05, 1.22, 1.3, 1.85, 2.23, 2.68, 3.4}, {1.19, 1.37, 1.45, 2.08, 2.48, 3.0, 3.77}, {1.33, 1.52, 1.65, 2.3, 2.75, 3.32, 3.99}, {1.45, 1.71, 2.0, 2.45, 2.9, 3.52, 4.23}};
    double[] ISO6578temperatures = new double[]{93.15, 98.15, 103.15, 108.15, 113.15, 118.15, 123.15, 128.15, 133.15};
    double[] ISO6578molarMasses = new double[]{16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0};
    double[][] ISO6578KMKMcorrectionFactor1Matrix = new double[][]{{-0.01, -0.01, -0.01, -0.01, -0.01, -0.01, -0.01, -0.01, -0.01}, {0.13, 0.15, 0.16, 0.18, 0.21, 0.24, 0.28, 0.33, 0.38}, {0.25, 0.29, 0.33, 0.37, 0.41, 0.47, 0.56, 0.66, 0.76}, {0.37, 0.41, 0.45, 0.51, 0.58, 0.67, 0.76, 0.87, 1.01}, {0.47, 0.52, 0.59, 0.67, 0.76, 0.86, 0.98, 1.01, 1.3}, {0.55, 0.62, 0.7, 0.79, 0.89, 1.0, 1.13, 1.29, 1.45}, {0.64, 0.72, 0.81, 0.9, 1.01, 1.17, 1.32, 1.52, 1.71}, {0.72, 0.82, 0.92, 1.02, 1.15, 1.33, 1.53, 1.68, 1.84}, {0.81, 0.92, 1.04, 1.16, 1.3, 1.47, 1.66, 1.87, 2.13}, {0.88, 1.0, 1.12, 1.25, 1.41, 1.58, 1.78, 2.0, 2.27}, {0.95, 1.07, 1.19, 1.33, 1.5, 1.68, 1.89, 2.13, 2.41}, {1.01, 1.13, 1.26, 1.41, 1.58, 1.78, 1.99, 2.24, 2.53}, {1.06, 1.18, 1.32, 1.47, 1.64, 1.84, 2.06, 2.32, 2.62}, {1.11, 1.23, 1.37, 1.54, 1.72, 1.92, 2.15, 2.42, 2.73}, {1.16, 1.29, 1.43, 1.6, 1.79, 2.0, 2.24, 2.51, 2.83}};
    double[][] ISO6578KMKMcorrectionFactor2Matrix = new double[][]{{0.0, -0.01, -0.01, -0.01, -0.02, -0.03, -0.04, -0.05, -0.07}, {0.11, 0.15, 0.21, 0.29, 0.46, 0.68, 0.91, 1.21, 1.6}, {0.26, 0.32, 0.39, 0.53, 0.67, 0.84, 1.05, 1.34, 1.8}, {0.4, 0.47, 0.57, 0.71, 0.88, 1.13, 1.39, 1.76, 2.22}, {0.56, 0.62, 0.71, 0.86, 1.06, 1.33, 1.62, 2.03, 2.45}, {0.67, 0.76, 0.87, 1.01, 1.16, 1.48, 1.85, 2.26, 2.79}, {0.78, 0.9, 1.01, 1.16, 1.27, 1.65, 2.09, 2.51, 3.13}, {0.88, 1.03, 1.15, 1.3, 1.42, 1.85, 2.33, 2.81, 3.49}, {0.98, 1.13, 1.27, 1.45, 1.6, 2.06, 2.58, 3.11, 3.74}, {1.07, 1.22, 1.38, 1.61, 1.89, 2.28, 2.73, 3.29, 3.97}, {1.15, 1.31, 1.5, 1.74, 2.04, 2.44, 2.92, 3.48, 4.19}, {1.22, 1.4, 1.61, 1.87, 2.19, 2.6, 3.1, 3.71, 4.46}, {1.31, 1.5, 1.72, 1.99, 2.33, 2.77, 3.31, 3.95, 4.74}, {1.38, 1.59, 1.83, 2.12, 2.48, 2.95, 3.51, 4.19, 5.03}, {1.47, 1.68, 1.93, 2.24, 2.63, 3.12, 3.72, 4.45, 5.34}};
    BicubicInterpolatingFunction pcs1 = null;
    BicubicInterpolatingFunction pcs2 = null;
    LinearInterpolator liearInterpol = new LinearInterpolator();
    double[] Vitemperatures = this.ISO6578temperatures;
    double[] Vimethane = new double[]{0.035771, 0.036315, 0.036891, 0.0375, 0.038149, 0.038839, 0.03958, 0.040375, 0.041237};
    double[] Viethane = new double[]{0.046324, 0.046716, 0.047116, 0.047524, 0.0479422, 0.048369, 0.048806, 0.049253, 0.049711};
    double[] Vipropane = new double[]{0.060731, 0.061164, 0.061602, 0.062046, 0.062497, 0.062953, 0.063417, 0.063887, 0.064364};
    double[] VinC4 = new double[]{0.074997, 0.075459, 0.075926, 0.076398, 0.076875, 0.077359, 0.077849, 0.078342, 0.078843};
    double[] ViiC4 = new double[]{0.076384, 0.076868, 0.077356, 0.077851, 0.078352, 0.078859, 0.079374, 0.079896, 0.080425};
    double[] VinC5 = new double[]{0.089498, 0.090016, 0.090536, 0.091058, 0.091583, 0.092111, 0.092642, 0.093177, 0.093715};
    double[] ViiC5 = new double[]{0.089576, 0.090107, 0.090642, 0.091179, 0.091721, 0.092267, 0.092817, 0.093372, 0.09393};
    double[] VinC6 = new double[]{0.10273, 0.10326, 0.1038, 0.10434, 0.10489, 0.10545, 0.10602, 0.10659, 0.10716};
    double[] Vinitrogen = new double[]{0.038408, 0.039949, 0.041788, 0.0440143, 0.047019, 0.051022, 0.055897, 0.061767, 0.069064};

    public Standard_ISO6578(SystemInterface thermoSystem) {
        super("Standard_ISO6578", "LNG density calcuation method", thermoSystem);
        this.setCorrectionFactors();
    }

    public void useISO6578VolumeCorrectionFacotrs(boolean useFactors) {
        this.use6578volumeCorrectionFactors = useFactors;
        this.setCorrectionFactors();
    }

    public void setCorrectionFactors() {
        BicubicInterpolator tempInterp = new BicubicInterpolator();
        if (this.use6578volumeCorrectionFactors) {
            this.pcs1 = tempInterp.interpolate(this.ISO6578molarMasses, this.ISO6578temperatures, this.ISO6578KMKMcorrectionFactor1Matrix);
            this.pcs2 = tempInterp.interpolate(this.ISO6578molarMasses, this.ISO6578temperatures, this.ISO6578KMKMcorrectionFactor2Matrix);
        } else {
            this.pcs1 = tempInterp.interpolate(this.molarMasses, this.temperatures, this.KMKMcorrectionFactor1Matrix);
            this.pcs2 = tempInterp.interpolate(this.molarMasses, this.temperatures, this.KMKMcorrectionFactor2Matrix);
        }
    }

    @Override
    public void calculate() {
        double Vmix = 0.0;
        this.Vi = new double[this.thermoSystem.getPhase(0).getNumberOfComponents()];
        PolynomialSplineFunction function = null;
        for (int i = 0; i < this.thermoSystem.getPhase(0).getNumberOfComponents(); ++i) {
            if (this.thermoSystem.getPhase(0).getComponent(i).getName().equals("methane")) {
                function = this.liearInterpol.interpolate(this.Vitemperatures, this.Vimethane);
            } else if (this.thermoSystem.getPhase(0).getComponent(i).getName().equals("ethane")) {
                function = this.liearInterpol.interpolate(this.Vitemperatures, this.Viethane);
            } else if (this.thermoSystem.getPhase(0).getComponent(i).getName().equals("propane")) {
                function = this.liearInterpol.interpolate(this.Vitemperatures, this.Vipropane);
            } else if (this.thermoSystem.getPhase(0).getComponent(i).getName().equals("i-butane")) {
                function = this.liearInterpol.interpolate(this.Vitemperatures, this.ViiC4);
            } else if (this.thermoSystem.getPhase(0).getComponent(i).getName().equals("n-butane")) {
                function = this.liearInterpol.interpolate(this.Vitemperatures, this.VinC4);
            } else if (this.thermoSystem.getPhase(0).getComponent(i).getName().equals("i-pentane") || this.thermoSystem.getPhase(0).getComponent(i).getName().equals("iC5")) {
                function = this.liearInterpol.interpolate(this.Vitemperatures, this.ViiC5);
            } else if (this.thermoSystem.getPhase(0).getComponent(i).getName().equals("n-pentane")) {
                function = this.liearInterpol.interpolate(this.Vitemperatures, this.VinC5);
            } else if (this.thermoSystem.getPhase(0).getComponent(i).getName().equals("n-hexane")) {
                function = this.liearInterpol.interpolate(this.Vitemperatures, this.VinC6);
            } else if (this.thermoSystem.getPhase(0).getComponent(i).getName().equals("nitrogen")) {
                function = this.liearInterpol.interpolate(this.Vitemperatures, this.Vinitrogen);
            } else {
                this.Vi[i] = 0.036315;
            }
            try {
                this.Vi[i] = function.value(this.thermoSystem.getTemperature());
            }
            catch (Exception ex) {
                this.Vi[i] = this.thermoSystem.getPhase(1).getMolarVolume() / 100.0;
            }
            Vmix += this.thermoSystem.getPhase(0).getComponent(i).getx() * this.Vi[i];
        }
        double xn2 = 0.0;
        double xch4 = 0.0;
        try {
            this.KMcorrectionFactor1 = this.pcs1.value(this.thermoSystem.getPhase(0).getMolarMass() * 1000.0, this.thermoSystem.getTemperature());
            this.KMcorrectionFactor2 = this.pcs2.value(this.thermoSystem.getPhase(0).getMolarMass() * 1000.0, this.thermoSystem.getTemperature());
        }
        catch (Exception ex) {
            this.KMcorrectionFactor1 = 0.0;
            this.KMcorrectionFactor2 = 0.0;
        }
        if (this.thermoSystem.getPhase(0).hasComponent("nitrogen")) {
            xn2 = this.thermoSystem.getPhase(0).getComponent("nitrogen").getx();
        }
        if (this.thermoSystem.getPhase(0).hasComponent("methane")) {
            xch4 = this.thermoSystem.getPhase(0).getComponent("methane").getx();
        }
        this.LNGdensity = this.thermoSystem.getPhase(0).getMolarMass() * 1000.0 / (Vmix -= (this.KMcorrectionFactor1 + (this.KMcorrectionFactor2 - this.KMcorrectionFactor1) * (xn2 / 0.0425)) * xch4 / 1000.0);
    }

    @Override
    public double getValue(String returnParameter, String returnUnit) {
        return this.LNGdensity;
    }

    @Override
    public double getValue(String returnParameter) {
        return this.LNGdensity;
    }

    @Override
    public String getUnit(String returnParameter) {
        return this.densityUnit;
    }

    @Override
    public boolean isOnSpec() {
        return true;
    }

    public double getCorrFactor1() {
        return this.KMcorrectionFactor1;
    }

    public double getCorrFactor2() {
        return this.KMcorrectionFactor2;
    }
}

