/*
 * Decompiled with CFR 0.152.
 */
package neqsim.statistics.experimentalsamplecreation.samplecreator.wettedwallcolumnsamplecreator;

import Jama.Matrix;
import neqsim.statistics.dataanalysis.datasmoothing.DataSmoother;
import neqsim.statistics.experimentalequipmentdata.wettedwallcolumndata.WettedWallColumnData;
import neqsim.statistics.experimentalsamplecreation.readdatafromfile.wettedwallcolumnreader.WettedWallColumnDataObject;
import neqsim.statistics.experimentalsamplecreation.readdatafromfile.wettedwallcolumnreader.WettedWallDataReader;
import neqsim.statistics.experimentalsamplecreation.samplecreator.SampleCreator;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.ExcludeFromJacocoGeneratedReport;

public class WettedWallColumnSampleCreator
extends SampleCreator {
    WettedWallDataReader reader;
    double[] time;
    double[] pressure;
    double[] inletLiquidTemperature;
    double[] outletLiquidTemperature;
    double[] inletGasTemperature;
    double[] inletTotalGasFlowRate;
    double[] inletLiquidFlowRate;
    double[] co2SupplyRate;
    double[] columnWallTemperature;
    double[] dPdt;
    double[] dNdt;
    double[] dPdn;
    double[] dNdtOld;
    double[] dnVdt;
    double[] smoothedPressure;
    double[] smoothedInletLiquidTemperature;
    double[] smoothedOutletLiquidTemperature;
    double[] smoothedInletGasTemperature;
    double[] smoothedInletTotalGasFlowRate;
    double[] smoothedInletLiquidFlowRate;
    double[] smoothedCo2SupplyRate;
    double[] smoothedColumnWallTemperature;

    public WettedWallColumnSampleCreator() {
    }

    public WettedWallColumnSampleCreator(String file) {
        this.reader = new WettedWallDataReader(file);
    }

    public void setSampleValues() {
        this.time = new double[this.reader.getSampleObjectList().size() - 1];
        this.pressure = new double[this.reader.getSampleObjectList().size() - 1];
        this.inletLiquidTemperature = new double[this.reader.getSampleObjectList().size() - 1];
        this.outletLiquidTemperature = new double[this.reader.getSampleObjectList().size() - 1];
        this.inletGasTemperature = new double[this.reader.getSampleObjectList().size() - 1];
        this.inletTotalGasFlowRate = new double[this.reader.getSampleObjectList().size() - 1];
        this.inletLiquidFlowRate = new double[this.reader.getSampleObjectList().size() - 1];
        this.co2SupplyRate = new double[this.reader.getSampleObjectList().size() - 1];
        this.columnWallTemperature = new double[this.reader.getSampleObjectList().size() - 1];
        int i = 0;
        do {
            this.time[i] = ((WettedWallColumnDataObject)this.reader.getSampleObjectList().get(i)).getTime();
            this.pressure[i] = ((WettedWallColumnDataObject)this.reader.getSampleObjectList().get(i)).getPressure();
            this.inletLiquidTemperature[i] = ((WettedWallColumnDataObject)this.reader.getSampleObjectList().get(i)).getInletLiquidTemperature();
            this.outletLiquidTemperature[i] = ((WettedWallColumnDataObject)this.reader.getSampleObjectList().get(i)).getOutletLiquidTemperature();
            this.columnWallTemperature[i] = ((WettedWallColumnDataObject)this.reader.getSampleObjectList().get(i)).getColumnWallTemperature();
            this.inletTotalGasFlowRate[i] = ((WettedWallColumnDataObject)this.reader.getSampleObjectList().get(i)).getInletTotalGasFlow();
            this.co2SupplyRate[i] = ((WettedWallColumnDataObject)this.reader.getSampleObjectList().get(i)).getCo2SupplyFlow();
            this.inletLiquidFlowRate[i] = ((WettedWallColumnDataObject)this.reader.getSampleObjectList().get(i)).getInletLiquidFlow();
        } while (++i < this.reader.getSampleObjectList().size() - 1);
    }

    public void smoothData() {
        Matrix data = new Matrix(this.pressure, 1);
        data.print(10, 2);
        DataSmoother smoother = new DataSmoother(this.pressure, 10, 10, 0, 2);
        smoother.runSmoothing();
        this.smoothedPressure = smoother.getSmoothedNumbers();
        smoother = new DataSmoother(this.inletLiquidTemperature, 10, 10, 0, 2);
        smoother.runSmoothing();
        this.smoothedInletLiquidTemperature = smoother.getSmoothedNumbers();
        smoother = new DataSmoother(this.outletLiquidTemperature, 10, 10, 0, 2);
        smoother.runSmoothing();
        this.smoothedOutletLiquidTemperature = smoother.getSmoothedNumbers();
        smoother = new DataSmoother(this.columnWallTemperature, 10, 10, 0, 2);
        smoother.runSmoothing();
        this.smoothedColumnWallTemperature = smoother.getSmoothedNumbers();
        smoother = new DataSmoother(this.inletTotalGasFlowRate, 10, 10, 0, 2);
        smoother.runSmoothing();
        this.smoothedInletTotalGasFlowRate = smoother.getSmoothedNumbers();
        smoother = new DataSmoother(this.co2SupplyRate, 10, 10, 0, 2);
        smoother.runSmoothing();
        this.smoothedCo2SupplyRate = smoother.getSmoothedNumbers();
        smoother = new DataSmoother(this.inletLiquidFlowRate, 10, 10, 0, 2);
        smoother.runSmoothing();
        this.smoothedInletLiquidFlowRate = smoother.getSmoothedNumbers();
        data = new Matrix(this.smoothedPressure, 1);
        data.print(10, 2);
        System.out.println("data-smoothing finished!");
    }

    public void calcdPdt() {
        this.system.init(0);
        this.dPdt = new double[this.reader.getSampleObjectList().size() - 1];
        this.dPdt[0] = 0.0;
        this.dPdt[this.reader.getSampleObjectList().size() - 2] = 0.0;
        this.dPdn = new double[this.reader.getSampleObjectList().size() - 1];
        this.dPdn[0] = 0.0;
        this.dPdn[this.reader.getSampleObjectList().size() - 2] = 0.0;
        double err = 0.0;
        this.dNdt = new double[this.reader.getSampleObjectList().size() - 1];
        this.dNdtOld = new double[this.reader.getSampleObjectList().size() - 1];
        this.dnVdt = new double[this.reader.getSampleObjectList().size() - 1];
        do {
            int i;
            for (i = 1; i < this.reader.getSampleObjectList().size() - 3; ++i) {
                this.system.setTemperature(this.smoothedInletLiquidTemperature[i]);
                this.system.setPressure(this.smoothedPressure[i]);
                this.system.getPhases()[0].addMoles(1, this.dNdt[i] * (this.time[i] - this.time[i - 1]));
                this.system.getPhases()[1].addMoles(1, -this.dNdt[i] * (this.time[i] - this.time[i - 1]));
                this.system.init(1);
                this.dPdt[i] = (this.smoothedPressure[i + 1] - this.smoothedPressure[i - 1]) / (this.time[i + 1] - this.time[i - 1]);
            }
            this.dNdt[0] = 0.0;
            this.dNdt[this.reader.getSampleObjectList().size() - 2] = 0.0;
            err = 0.0;
            for (i = 1; i < this.reader.getSampleObjectList().size() - 3; ++i) {
                this.dNdtOld[i] = this.dNdt[i];
                this.dNdt[i] = this.dPdt[i] * 1.0 / this.dPdn[i];
                err += Math.abs(this.dNdtOld[i] - this.dNdt[i]);
                this.dnVdt[i] = this.dNdt[i] * 8.3144621 * 298.15 / 101325.0 * 1000.0 * 60.0;
                System.out.println("dVdt: " + this.dnVdt[i]);
            }
            System.out.println("err: " + err);
        } while (err > 1.0E-10);
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        WettedWallColumnSampleCreator creator = new WettedWallColumnSampleCreator("31011250");
        WettedWallColumnData eq = new WettedWallColumnData(0.025, 1.48, 4.9);
        creator.setExperimentalEquipment(eq);
        creator.setSampleValues();
        creator.smoothData();
        SystemSrkEos sys = new SystemSrkEos(298.0, 10.0);
        sys.addComponent("methane", 100.0);
        sys.addComponent("CO2", 10.0);
        creator.setThermoSystem(sys);
        creator.calcdPdt();
    }
}

