/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.characterization;

import java.io.Serializable;
import neqsim.thermo.characterization.TBPModelInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.exception.NotImplementedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TBPfractionModel
implements Serializable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(TBPfractionModel.class);
    String name = "";

    public TBPModelInterface getModel(String name) {
        this.name = name;
        if (name.equals("PedersenSRK")) {
            return new PedersenTBPModelSRK();
        }
        if (name.equals("PedersenSRKHeavyOil")) {
            logger.info("using SRK heavy oil TBp.................");
            return new PedersenTBPModelSRKHeavyOil();
        }
        if (name.equals("PedersenPR")) {
            return new PedersenTBPModelPR();
        }
        if (name.equals("PedersenPR2")) {
            return new PedersenTBPModelPR2();
        }
        if (name.equals("PedersenPRHeavyOil")) {
            logger.info("using PR heavy oil TBp.................");
            return new PedersenTBPModelPRHeavyOil();
        }
        if (name.equals("RiaziDaubert")) {
            return new RiaziDaubert();
        }
        if (name.equals("Lee-Kesler")) {
            return new LeeKesler();
        }
        if (name.equals("Twu")) {
            return new TwuModel();
        }
        return new PedersenTBPModelSRK();
    }

    public class PedersenTBPModelSRK
    extends TBPBaseModel {
        private static final long serialVersionUID = 1000L;
        double[][] TBPfractionCoefOil;
        double[][] TBPfractionCoefsHeavyOil;
        double[] TPBracketcoefs;
        double[][] TBPfractionCoefs;

        public PedersenTBPModelSRK() {
            this.TBPfractionCoefOil = new double[][]{{163.12, 86.052, 0.43475, -1877.4, 0.0}, {-0.13408, 2.5019, 208.46, -3987.2, 1.0}, {0.7431, 0.0048122, 0.0096707, -3.7184E-6, 0.0}};
            this.TBPfractionCoefsHeavyOil = new double[][]{{830.63, 17.5228, 0.0455911, -11348.4, 0.0}, {0.802988, 1.78396, 156.74, -6965.59, 0.25}, {-0.047268, 0.0602931, 1.21051, -0.00576676, 0.0}};
            this.TPBracketcoefs = new double[]{0.29441, 0.40768};
            this.TBPfractionCoefs = null;
        }

        @Override
        public double calcTC(double molarMass, double density) {
            this.TBPfractionCoefs = molarMass < 1120.0 ? this.TBPfractionCoefOil : this.TBPfractionCoefsHeavyOil;
            return this.TBPfractionCoefs[0][0] * density + this.TBPfractionCoefs[0][1] * Math.log(molarMass) + this.TBPfractionCoefs[0][2] * molarMass + this.TBPfractionCoefs[0][3] / molarMass;
        }

        @Override
        public double calcPC(double molarMass, double density) {
            this.TBPfractionCoefs = molarMass < 1120.0 ? this.TBPfractionCoefOil : this.TBPfractionCoefsHeavyOil;
            return Math.exp(0.01325 + this.TBPfractionCoefs[1][0] + this.TBPfractionCoefs[1][1] * Math.pow(density, this.TBPfractionCoefs[1][4]) + this.TBPfractionCoefs[1][2] / molarMass + this.TBPfractionCoefs[1][3] / Math.pow(molarMass, 2.0));
        }

        @Override
        public double calcm(double molarMass, double density) {
            this.TBPfractionCoefs = molarMass < 1120.0 ? this.TBPfractionCoefOil : this.TBPfractionCoefsHeavyOil;
            return this.TBPfractionCoefs[2][0] + this.TBPfractionCoefs[2][1] * molarMass + this.TBPfractionCoefs[2][2] * density + this.TBPfractionCoefs[2][3] * Math.pow(molarMass, 2.0);
        }

        @Override
        public double calcTB(double molarMass, double density) {
            if (this.getBoilingPoint() > 0.0) {
                return this.getBoilingPoint();
            }
            if (molarMass < 540.0) {
                return 2.0E-6 * Math.pow(molarMass, 3.0) - 0.0035 * Math.pow(molarMass, 2.0) + 2.4003 * molarMass + 171.74;
            }
            return 97.58 * Math.pow(molarMass, 0.3323) * Math.pow(density, 0.04609);
        }

        @Override
        public double calcRacketZ(SystemInterface thermoSystem, double molarMass, double density) {
            double penelouxC = thermoSystem.getPhase(0).getMolarVolume() - molarMass / (density * 10.0);
            double TC = this.calcTC(molarMass, density);
            double PC = this.calcPC(molarMass, density);
            return this.TPBracketcoefs[0] - penelouxC / (this.TPBracketcoefs[1] * 8.3144621 * TC / PC);
        }
    }

    public class PedersenTBPModelSRKHeavyOil
    extends PedersenTBPModelSRK {
        private static final long serialVersionUID = 1000L;
        double[][] TBPfractionCoefsHeavyOil = new double[][]{{830.63, 17.5228, 0.0455911, -11348.4, 0.0}, {0.802988, 1.78396, 156.74, -6965.59, 0.25}, {-0.047268, 0.0602931, 1.21051, -0.00576676, 0.0}};
        double[][] TBPfractionCoefOil = this.TBPfractionCoefsHeavyOil;

        public PedersenTBPModelSRKHeavyOil() {
            this.TBPfractionCoefsHeavyOil = new double[][]{{830.63, 17.5228, 0.0455911, -11348.4, 0.0}, {0.802988, 1.78396, 156.74, -6965.59, 0.25}, {-0.047268, 0.0602931, 1.21051, -0.00576676, 0.0}};
            this.TBPfractionCoefOil = this.TBPfractionCoefsHeavyOil;
        }
    }

    public class PedersenTBPModelPR
    extends PedersenTBPModelSRK {
        private static final long serialVersionUID = 1000L;

        public PedersenTBPModelPR() {
            double[][] TBPfractionCoefOil2 = new double[][]{{73.4043, 97.3562, 0.618744, -2059.32, 0.0}, {0.0728462, 2.18811, 163.91, -4043.23, 0.25}, {0.373765, 0.00549269, 0.0117934, -4.93049E-6, 0.0}};
            double[][] TBPfractionCoefHeavyOil2 = new double[][]{{913.222, 10.1134, 0.0454194, -13587.0, 0.0}, {1.28155, 1.26838, 167.106, -8101.64, 0.25}, {-0.23838, 0.0610147, 1.32349, -0.00652067, 0.0}};
            double[] TPBracketcoefs2 = new double[]{0.25969, 0.50033};
            this.TBPfractionCoefOil = TBPfractionCoefOil2;
            this.TBPfractionCoefsHeavyOil = TBPfractionCoefHeavyOil2;
            this.TPBracketcoefs = TPBracketcoefs2;
        }
    }

    public class PedersenTBPModelPR2
    extends PedersenTBPModelSRK {
        private static final long serialVersionUID = 1000L;

        public PedersenTBPModelPR2() {
            double[][] TBPfractionCoefOil2 = new double[][]{{73.4043, 97.3562, 0.618744, -2059.32, 0.0}, {0.0728462, 2.18811, 163.91, -4043.23, 0.25}, {0.373765, 0.00549269, 0.0117934, -4.93049E-6, 0.0}};
            double[][] TBPfractionCoefHeavyOil2 = new double[][]{{913.222, 10.1134, 0.0454194, -13587.0, 0.0}, {1.28155, 1.26838, 167.106, -8101.64, 0.25}, {-0.23838, 0.0610147, 1.32349, -0.00652067, 0.0}};
            double[] TPBracketcoefs2 = new double[]{0.25969, 0.50033};
            this.TBPfractionCoefOil = TBPfractionCoefOil2;
            this.TBPfractionCoefsHeavyOil = TBPfractionCoefHeavyOil2;
            this.TPBracketcoefs = TPBracketcoefs2;
        }

        @Override
        public double calcTB(double molarMass, double density) {
            if (this.getBoilingPoint() > 0.0) {
                return this.getBoilingPoint();
            }
            double calculated_TB = 1928.3 - 169500.0 * Math.pow(molarMass, -0.03522) * Math.pow(density, 3.266) * Math.exp(-0.004922 * molarMass - 4.7685 * density + 0.003462 * molarMass * density);
            return calculated_TB / 1.8;
        }
    }

    public class PedersenTBPModelPRHeavyOil
    extends PedersenTBPModelPR {
        private static final long serialVersionUID = 1000L;

        public PedersenTBPModelPRHeavyOil() {
            double[][] TBPfractionCoefHeavyOil2 = new double[][]{{913.222, 10.1134, 0.0454194, -13587.0, 0.0}, {1.28155, 1.26838, 167.106, -8101.64, 0.25}, {-0.23838, 0.0610147, 1.32349, -0.00652067, 0.0}};
            this.TBPfractionCoefOil = TBPfractionCoefHeavyOil2;
            this.TBPfractionCoefsHeavyOil = TBPfractionCoefHeavyOil2;
        }
    }

    public class RiaziDaubert
    extends PedersenTBPModelSRK {
        private static final long serialVersionUID = 1000L;

        public RiaziDaubert() {
            this.calcm = false;
        }

        @Override
        public double calcTC(double molarMass, double density) {
            if (molarMass > 300.0) {
                return super.calcTC(molarMass, density);
            }
            return 308.0 * Math.exp(-1.3478E-4 * molarMass - 0.61641 * density + 0.0 * molarMass * density) * Math.pow(molarMass, 0.2998) * Math.pow(density, 1.0555);
        }

        @Override
        public double calcPC(double molarMass, double density) {
            if (molarMass > 300.0) {
                return super.calcPC(molarMass, density);
            }
            return 3116.6112409999996 * Math.exp(-0.0018078 * molarMass + -0.3084 * density + 0.0 * molarMass * density) * Math.pow(molarMass, -0.8063) * Math.pow(density, 1.6015);
        }

        public double calcAcentricFactor2(double molarMass, double density) {
            double TC = this.calcTC(molarMass, density);
            double TB = this.calcTB(molarMass, density);
            double PC = this.calcPC(molarMass, density);
            return 0.42857142857142855 * Math.log10(PC / 1.01325) / (TC / TB - 1.0) - 1.0;
        }

        @Override
        public double calcTB(double molarMass, double density) {
            if (this.getBoilingPoint() > 0.0) {
                return this.getBoilingPoint();
            }
            return 97.58 * Math.pow(molarMass, 0.3323) * Math.pow(density, 0.04609);
        }

        @Override
        public double calcAcentricFactor(double molarMass, double density) {
            double TC = this.calcTC(molarMass, density);
            double TB = this.calcTB(molarMass, density);
            double PC = this.calcPC(molarMass, density);
            double TBR = TB / TC;
            double PBR = 1.01325 / PC;
            if (TBR < 0.8) {
                return (Math.log(PBR) - 5.92714 + 6.09649 / TBR + 1.28862 * Math.log(TBR) - 0.169347 * Math.pow(TBR, 6.0)) / (15.2518 - 15.6875 / TBR - 13.4721 * Math.log(TBR) + 0.43577 * Math.pow(TBR, 6.0));
            }
            double Kw = Math.pow(TB, 0.3333333333333333) / density;
            return -7.904 + 0.1352 * Kw - 0.007465 * Kw * Kw + 8.359 * TBR + (1.408 - 0.01063 * Kw) / TBR;
        }
    }

    public class LeeKesler
    extends TBPBaseModel {
        private static final long serialVersionUID = 1000L;

        public LeeKesler() {
            this.calcm = false;
        }

        @Override
        public double calcTC(double molarMass, double density) {
            double sg = density;
            double TB = this.calcTB(molarMass, density);
            double TC = 189.8 + 450.6 * sg + (0.4244 + 0.1174 * sg) * TB + (0.1441 - 1.0069 * sg) * 100000.0 / TB;
            return TC;
        }

        @Override
        public double calcPC(double molarMass, double density) {
            double sg = density;
            double TB = this.calcTB(molarMass, density);
            double logpc = 3.3864 - 0.0566 / sg - (0.43639 + 4.1216 / sg + 0.21343 / sg / sg) * 0.001 * TB + (0.47579 + 1.182 / sg + 0.15302 / sg / sg) * 1.0E-6 * TB * TB - (2.4505 + 9.9099 / sg / sg) * 1.0E-10 * TB * TB * TB;
            double PC = Math.exp(logpc) * 10.0;
            return PC;
        }

        @Override
        public double calcAcentricFactor(double molarMass, double density) {
            return super.calcAcentricFactorKeslerLee(molarMass, density);
        }
    }

    public class TwuModel
    extends TBPBaseModel {
        private static final long serialVersionUID = 1000L;

        public TwuModel() {
            this.calcm = false;
        }

        @Override
        public double calcTC(double molarMass, double density) {
            double sg = density;
            double TB = this.calcTB(molarMass, density);
            double MW = this.solveMW(TB);
            double Tcnalkane = TB * 1.0 / (0.533272 + 3.43831E-4 * TB + 2.526167E-7 * TB * TB - 1.65848E-10 * TB * TB * TB + 4.60774E24 * Math.pow(TB, -13.0));
            double phi = 1.0 - TB / Tcnalkane;
            double SGalkane = 0.843593 - 0.128624 * phi - 3.36159 * Math.pow(phi, 3.0) - 13749.0 * Math.pow(phi, 12.0);
            double PCnalkane = Math.pow(0.318317 + 0.099334 * Math.sqrt(phi) + 2.89698 * phi + 3.0054 * phi * phi + 8.65163 * Math.pow(phi, 4.0), 2.0);
            double VCnalkane = Math.pow(0.82055 + 0.715468 * phi + 2.21266 * phi * phi * phi + 13411.1 * Math.pow(phi, 14.0), -8.0);
            double deltaST = Math.exp(5.0 * (SGalkane - sg)) - 1.0;
            double fT = deltaST * (-0.270159 * Math.pow(TB, -0.5) + (0.0398285 - 0.706691 * Math.pow(TB, -0.5) * deltaST));
            double TC = Tcnalkane * Math.pow((1.0 + 2.0 * fT) / (1.0 - 2.0 * fT), 2.0);
            return TC;
        }

        public double calculateTfunc(double MW_alkane, double TB) {
            double phi = Math.log(MW_alkane);
            return Math.exp(5.1264 + 2.71579 * phi - 0.28659 * phi * phi - 39.8544 / phi - 0.122488 / phi / phi) - 13.7512 * phi + 19.6197 * phi * phi - TB;
        }

        public double computeGradient(double MW_alkane, double TB) {
            double delta = 1.0;
            double TfuncPlus = this.calculateTfunc(MW_alkane + delta, TB);
            double TfuncMinus = this.calculateTfunc(MW_alkane - delta, TB);
            return (TfuncPlus - TfuncMinus) / (2.0 * delta);
        }

        public double solveMW(double TB) {
            double prevMW_alkane;
            double gradient;
            double MW_alkane = TB / (5.8 - 0.0052 * TB);
            double tolerance = 1.0E-6;
            double error = 1.0;
            int iter = 0;
            do {
                prevMW_alkane = MW_alkane;
                gradient = this.computeGradient(MW_alkane, TB);
            } while (Math.abs(error = Math.abs((MW_alkane -= 0.5 * this.calculateTfunc(MW_alkane, TB) / gradient) - prevMW_alkane)) > tolerance && ++iter < 1000 || iter < 3);
            return MW_alkane;
        }

        @Override
        public double calcPC(double molarMass, double density) {
            double sg = density;
            double TB = this.calcTB(molarMass, density);
            double MW = this.solveMW(TB);
            double Tcnalkane = TB * 1.0 / (0.533272 + 3.43831E-4 * TB + 2.526167E-7 * TB * TB - 1.65848E-10 * TB * TB * TB + 4.60774E24 * Math.pow(TB, -13.0));
            double phi = 1.0 - TB / Tcnalkane;
            double SGalkane = 0.843593 - 0.128624 * phi - 3.36159 * Math.pow(phi, 3.0) - 13749.0 * Math.pow(phi, 12.0);
            double PCnalkane = Math.pow(0.318317 + 0.099334 * Math.sqrt(phi) + 2.89698 * phi + 3.0054 * phi * phi + 8.65163 * Math.pow(phi, 4.0), 2.0);
            double VCnalkane = Math.pow(0.82055 + 0.715468 * phi + 2.21266 * phi * phi * phi + 13411.1 * Math.pow(phi, 14.0), -8.0);
            double deltaST = Math.exp(5.0 * (SGalkane - sg)) - 1.0;
            double fT = deltaST * (-0.270159 * Math.pow(TB, -0.5) + (0.0398285 - 0.706691 * Math.pow(TB, -0.5) * deltaST));
            double TC = Tcnalkane * Math.pow((1.0 + 2.0 * fT) / (1.0 - 2.0 * fT), 2.0);
            double deltaSP = Math.exp(0.5 * (SGalkane - sg)) - 1.0;
            double deltaSV = Math.exp(4.0 * (SGalkane * SGalkane - sg * sg)) - 1.0;
            double fV = deltaSV * (0.347776 * Math.pow(TB, -0.5) + (-0.182421 + 2.2489 * Math.pow(TB, -0.5)) * deltaSV);
            double VC = VCnalkane * Math.pow((1.0 + 2.0 * fV) / (1.0 - 2.0 * fV), 2.0);
            double fP = deltaSP * (2.53262 - 34.4321 * Math.pow(TB, -0.5) - 0.00230193 * TB + (-11.4277 + 187.934 * Math.pow(TB, -0.5) + 0.00414963 * TB) * deltaSP);
            double PC = PCnalkane * (TC / Tcnalkane) * (VCnalkane / VC) * Math.pow((1.0 + 2.0 * fP) / (1.0 - 2.0 * fP), 2.0);
            return PC * 10.0;
        }

        @Override
        public double calcCriticalVolume(double molarMass, double density) {
            double sg = density;
            double TB = this.calcTB(molarMass, density);
            double MW = this.solveMW(TB);
            double Tcnalkane = TB * 1.0 / (0.533272 + 3.43831E-4 * TB + 2.526167E-7 * TB * TB - 1.65848E-10 * TB * TB * TB + 4.60774E24 * Math.pow(TB, -13.0));
            double phi = 1.0 - TB / Tcnalkane;
            double SGalkane = 0.843593 - 0.128624 * phi - 3.36159 * Math.pow(phi, 3.0) - 13749.0 * Math.pow(phi, 12.0);
            double PCnalkane = Math.pow(0.318317 + 0.099334 * Math.sqrt(phi) + 2.89698 * phi + 3.0054 * phi * phi + 8.65163 * Math.pow(phi, 4.0), 2.0);
            double VCnalkane = Math.pow(0.82055 + 0.715468 * phi + 2.21266 * phi * phi * phi + 13411.1 * Math.pow(phi, 14.0), -8.0);
            double deltaST = Math.exp(5.0 * (SGalkane - sg)) - 1.0;
            double fT = deltaST * (-0.270159 * Math.pow(TB, -0.5) + (0.0398285 - 0.706691 * Math.pow(TB, -0.5) * deltaST));
            double TC = Tcnalkane * Math.pow((1.0 + 2.0 * fT) / (1.0 - 2.0 * fT), 2.0);
            double deltaSP = Math.exp(0.5 * (SGalkane - sg)) - 1.0;
            double deltaSV = Math.exp(4.0 * (SGalkane * SGalkane - sg * sg)) - 1.0;
            double fV = deltaSV * (0.347776 * Math.pow(TB, -0.5) + (-0.182421 + 2.2489 * Math.pow(TB, -0.5)) * deltaSV);
            double VC = VCnalkane * Math.pow((1.0 + 2.0 * fV) / (1.0 - 2.0 * fV), 2.0);
            double fP = deltaSP * (2.53262 - 34.4321 * Math.pow(TB, -0.5) - 0.00230193 * TB + (-11.4277 + 187.934 * Math.pow(TB, -0.5) + 0.00414963 * TB) * deltaSP);
            double PC = PCnalkane * (TC / Tcnalkane) * (VCnalkane / VC) * Math.pow((1.0 + 2.0 * fP) / (1.0 - 2.0 * fP), 2.0);
            return VC * 1000.0;
        }
    }

    public abstract class TBPBaseModel
    implements TBPModelInterface,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = 1000L;
        private double boilingPoint = 0.0;
        protected boolean calcm = true;

        @Override
        public void setBoilingPoint(double boilingPoint) {
            this.boilingPoint = boilingPoint;
        }

        public double getBoilingPoint() {
            return this.boilingPoint;
        }

        @Override
        public String getName() {
            return TBPfractionModel.this.name;
        }

        @Override
        public double calcTB(double molarMass, double density) {
            if (this.getBoilingPoint() > 0.0) {
                return this.getBoilingPoint();
            }
            return Math.pow(molarMass / 5.805E-5 * Math.pow(density, 0.9371), 0.42059219380888285);
        }

        @Override
        public double calcWatsonCharacterizationFactor(double molarMass, double density) {
            return Math.pow(1.8 * this.calcTB(molarMass, density), 0.3333333333333333) / density;
        }

        @Override
        public double calcAcentricFactorKeslerLee(double molarMass, double density) {
            double TC = this.calcTC(molarMass, density);
            double TB = this.calcTB(molarMass, density);
            double PC = this.calcPC(molarMass, density);
            double TBR = TB / TC;
            double PBR = 1.01325 / PC;
            if (TBR < 0.8) {
                return (Math.log(PBR) - 5.92714 + 6.09649 / TBR + 1.28862 * Math.log(TBR) - 0.169347 * Math.pow(TBR, 6.0)) / (15.2518 - 15.6875 / TBR - 13.4721 * Math.log(TBR) + 0.43577 * Math.pow(TBR, 6.0));
            }
            double Kw = Math.pow(TB, 0.3333333333333333) / density;
            return -7.904 + 0.1352 * Kw - 0.007465 * Kw * Kw + 8.359 * TBR + (1.408 - 0.01063 * Kw) / TBR;
        }

        @Override
        public double calcAcentricFactor(double molarMass, double density) {
            double TC = this.calcTC(molarMass, density);
            double TB = this.calcTB(molarMass, density);
            double PC = this.calcPC(molarMass, density);
            return 0.42857142857142855 * Math.log10(PC / 1.01325) / (TC / TB - 1.0) - 1.0;
        }

        @Override
        public double calcCriticalVolume(double molarMass, double density) {
            double TC = this.calcTC(molarMass, density);
            double PC = this.calcPC(molarMass, density);
            double acs = this.calcAcentricFactor(molarMass, density);
            double criticaVol = (0.2918 - 0.0928 * acs) * 8.3144621 * TC / PC * 10.0;
            if (criticaVol < 0.0) {
                criticaVol = 1.6545779579000002 * TC / PC * 10.0;
            }
            return criticaVol;
        }

        @Override
        public double calcParachorParameter(double molarMass, double density) {
            return 59.3 + 2.34 * molarMass * 1000.0;
        }

        @Override
        public double calcCriticalViscosity(double molarMass, double density) {
            double TC = this.calcTC(molarMass, density);
            double PC = this.calcPC(molarMass, density);
            return 7.9483 * Math.sqrt(molarMass) * Math.pow(PC, 0.6666666666666666) / Math.pow(TC, 0.16666666666666666) * 1.0E-7;
        }

        @Override
        public double calcRacketZ(SystemInterface thermoSystem, double molarMass, double density) {
            throw new RuntimeException(new NotImplementedException(this, "calcRacketZ"));
        }

        @Override
        public double calcm(double molarMass, double density) {
            throw new RuntimeException(new NotImplementedException(this, "calcm"));
        }

        @Override
        public boolean isCalcm() {
            return this.calcm;
        }
    }
}

