/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import java.sql.ResultSet;
import neqsim.thermo.component.ComponentGE;
import neqsim.thermo.phase.PhaseDesmukhMather;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseType;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentDesmukhMather
extends ComponentGE {
    private static final long serialVersionUID = 1000L;
    private double deshMathIonicDiameter;
    static Logger logger = LogManager.getLogger(ComponentDesmukhMather.class);

    public ComponentDesmukhMather(String name, double moles, double molesInPhase, int compIndex) {
        block9: {
            super(name, moles, molesInPhase, compIndex);
            this.deshMathIonicDiameter = 1.0;
            ResultSet dataSet = null;
            try (NeqSimDataBase database = new NeqSimDataBase();){
                if (name.equals("default")) break block9;
                try {
                    dataSet = database.getResultSet("SELECT * FROM comptemp WHERE name='" + name + "'");
                    dataSet.next();
                    dataSet.getString("FORMULA");
                }
                catch (Exception ex) {
                    dataSet.close();
                    logger.info("no parameters in tempcomp -- trying comp.. " + name);
                    dataSet = database.getResultSet("SELECT * FROM comp WHERE name='" + name + "'");
                    dataSet.next();
                }
                this.deshMathIonicDiameter = Double.parseDouble(dataSet.getString("DeshMatIonicDiameter"));
            }
            catch (Exception ex) {
                logger.error("error in comp");
            }
        }
    }

    @Override
    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, PhaseType pt, double[][] HValpha, double[][] HVgij, double[][] intparam, String[][] mixRule) {
        return this.getGamma(phase, numberOfComponents, temperature, pressure, pt);
    }

    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, PhaseType pt) {
        double A = 1.174;
        double B = 3.32384E9;
        double Iion = ((PhaseDesmukhMather)phase).getIonicStrength();
        double temp = 0.0;
        for (int i = 0; i < phase.getNumberOfComponents(); ++i) {
            if (phase.getComponent(i).getComponentName().equals("water")) continue;
            temp += 2.0 * ((PhaseDesmukhMather)phase).getBetaDesMatij(i, this.getComponentNumber()) * phase.getComponent(i).getMolality(phase);
        }
        this.lngamma = -A * Math.pow(this.getIonicCharge(), 2.0) * Math.sqrt(Iion) / (1.0 + B * this.deshMathIonicDiameter * 1.0E-10 * Math.sqrt(Iion)) + temp;
        this.gamma = this.getMolality(phase) * ((PhaseDesmukhMather)phase).getSolventMolarMass() * Math.exp(this.lngamma) / this.getx();
        this.lngamma = Math.log(this.gamma);
        logger.info("gamma " + this.componentName + " " + this.gamma);
        return this.gamma;
    }

    @Override
    public double fugcoef(PhaseInterface phase) {
        if (this.componentName.equals("water")) {
            double watervol = 0.001 * this.getMolarMass();
            double watervappres = this.getAntoineVaporPressure(phase.getTemperature());
            this.fugacityCoefficient = this.gamma * watervappres * Math.exp(watervol / (8.3144621 * phase.getTemperature()) * (phase.getPressure() - watervappres) * 100000.0) / phase.getPressure();
        } else {
            this.fugacityCoefficient = this.ionicCharge == 0 && this.referenceStateType.equals("solvent") ? this.gamma * this.getAntoineVaporPressure(phase.getTemperature()) / phase.getPressure() : (this.ionicCharge == 0 && this.referenceStateType.equals("solute") ? this.gamma * this.getHenryCoef(phase.getTemperature()) / phase.getPressure() : 1.0E-15);
        }
        return this.fugacityCoefficient;
    }

    public double getLngamma() {
        return this.lngamma;
    }

    @Override
    public double getMolality(PhaseInterface phase) {
        return this.getNumberOfMolesInPhase() / ((PhaseDesmukhMather)phase).getSolventWeight();
    }
}

