/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentHydrate;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentHydrateBallard
extends ComponentHydrate {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ComponentHydrateBallard.class);

    public ComponentHydrateBallard(String name, double moles, double molesInPhase, int compIndex) {
        super(name, moles, molesInPhase, compIndex);
        this.coordNumb[0][0] = 20.0;
        this.coordNumb[0][1] = 24.0;
        this.cavRadius[0][0] = 3.908;
        this.cavRadius[0][1] = 4.326;
        this.cavNumb[0][0] = 2.0;
        this.cavNumb[0][1] = 6.0;
        this.cavprwat[0][0] = 0.043478260869565216;
        this.cavprwat[0][1] = 0.13043478260869565;
        this.coordNumb[1][0] = 20.0;
        this.coordNumb[1][1] = 28.0;
        this.cavRadius[1][0] = 3.902;
        this.cavRadius[1][1] = 4.683;
        this.cavNumb[1][0] = 16.0;
        this.cavNumb[1][1] = 8.0;
        this.cavprwat[1][0] = 0.11764705882352941;
        this.cavprwat[1][1] = 0.058823529411764705;
    }

    @Override
    public double fugcoef(PhaseInterface phase, int numberOfComps, double temp, double pres) {
        if (this.componentName.equals("water")) {
            this.refPhase.setTemperature(temp);
            this.refPhase.setPressure(pres);
            this.refPhase.init(this.refPhase.getNumberOfMolesInPhase(), 1, 3, PhaseType.LIQUID, 1.0);
            double refWaterFugacity = this.refPhase.getComponent("water").fugcoef(this.refPhase) * pres;
            double alphaWater = this.reffug[this.getComponentNumber()];
            double wateralphaRef = Math.log(refWaterFugacity / alphaWater);
            this.fugacityCoefficient = -1.0E50;
            double val = 0.0;
            double tempy = 1.0;
            for (int cavType = 0; cavType < 2; ++cavType) {
                tempy = 0.0;
                for (int j = 0; j < phase.getNumberOfComponents(); ++j) {
                    double tee = ((ComponentHydrate)phase.getComponent(j)).calcYKI(this.hydrateStructure, cavType, phase);
                    tempy += tee;
                }
                val += this.getCavprwat()[this.hydrateStructure][cavType] * Math.log(1.0 - tempy);
            }
            logger.info("val " + val + " wateralphaRef " + wateralphaRef + " calcChemPotEmpty(phase, numberOfComps, temp, pres, hydrateStructure) " + this.calcChemPotEmpty(phase, numberOfComps, temp, pres, this.hydrateStructure) + " " + this.calcChemPotIdealWater(phase, numberOfComps, temp, pres, this.hydrateStructure));
            this.fugacityCoefficient = alphaWater * Math.exp(wateralphaRef + val + this.calcChemPotEmpty(phase, numberOfComps, temp, pres, this.hydrateStructure) - this.calcChemPotIdealWater(phase, numberOfComps, temp, pres, this.hydrateStructure)) / pres;
            logger.info("structure " + (this.hydrateStructure + 1));
        } else {
            this.fugacityCoefficient = 1.0E50;
        }
        return this.fugacityCoefficient;
    }

    @Override
    public double calcYKI(int stucture, int cavityType, PhaseInterface phase) {
        if (this.componentName.equals("water")) {
            return 0.0;
        }
        double yki = this.calcCKI(stucture, cavityType, phase) * this.reffug[this.componentNumber] * 100000.0;
        double temp = 1.0;
        for (int i = 0; i < phase.getNumberOfComponents(); ++i) {
            if (!phase.getComponent(i).isHydrateFormer()) continue;
            temp += ((ComponentHydrate)phase.getComponent(i)).calcCKI(stucture, cavityType, phase) * 100000.0 * this.reffug[i];
        }
        return yki / temp;
    }

    @Override
    public double calcCKI(int stucture, int cavityType, PhaseInterface phase) {
        if (this.componentName.equals("water")) {
            return 0.0;
        }
        double cki = 12.5663706 / (phase.getTemperature() * 8.3144621) * this.potIntegral(stucture, cavityType, phase) * 6.023E23;
        return cki / 1.0E30;
    }

    @Override
    public double potIntegral(int stucture, int cavityType, PhaseInterface phase) {
        double step;
        double val = 0.0;
        double endval = this.cavRadius[stucture][cavityType] - this.getSphericalCoreRadius();
        double x = 0.0;
        x = step = endval / 100.0;
        for (int i = 1; i < 100; ++i) {
            val += step * ((this.getPot(x, stucture, cavityType, phase) + 4.0 * this.getPot(x + 0.5 * step, stucture, cavityType, phase) + this.getPot(x + step, stucture, cavityType, phase)) / 6.0);
            x = (double)i * step;
        }
        if (Double.isNaN(val)) {
            logger.error("val NaN ...");
        }
        if (Double.isInfinite(val)) {
            logger.error("val Infinite ...");
        }
        return val;
    }

    @Override
    public double getPot(double radius, int struccture, int cavityType, PhaseInterface phase) {
        double pot = 2.0 * this.coordNumb[struccture][cavityType] * this.getLennardJonesEnergyParameter() * (Math.pow(this.getLennardJonesMolecularDiameter(), 12.0) / (Math.pow(this.cavRadius[struccture][cavityType], 11.0) * radius) * (this.delt(10.0, radius, struccture, cavityType) + this.getSphericalCoreRadius() / this.cavRadius[struccture][cavityType] * this.delt(11.0, radius, struccture, cavityType)) - Math.pow(this.getLennardJonesMolecularDiameter(), 6.0) / (Math.pow(this.cavRadius[struccture][cavityType], 5.0) * radius) * (this.delt(4.0, radius, struccture, cavityType) + this.getSphericalCoreRadius() / this.cavRadius[struccture][cavityType] * this.delt(5.0, radius, struccture, cavityType)));
        if (Double.isNaN(pot = Math.exp(-pot / phase.getTemperature()) * radius * radius)) {
            logger.error("pot NaN ...");
        }
        if (Double.isInfinite(pot)) {
            logger.error("pot Infinite ...");
        }
        return pot;
    }

    public double delt(double n, double radius, int struccture, int cavityType) {
        double diff1 = (radius + this.getSphericalCoreRadius()) / this.cavRadius[struccture][cavityType];
        double diff2 = (radius - this.getSphericalCoreRadius()) / this.cavRadius[struccture][cavityType];
        double delt = 1.0 / n * (Math.pow(1.0 - diff1, -n) - Math.pow(1.0 + diff2, -n));
        if (Double.isNaN(delt)) {
            logger.error("delt NaN ...");
        }
        if (Double.isInfinite(delt)) {
            logger.error("delt Infinite ...");
        }
        return delt;
    }
}

