/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveeosterm;

import java.util.Arrays;
import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveeosterm.AttractiveTermInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AttractiveTermBaseClass
implements AttractiveTermInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(AttractiveTermBaseClass.class);
    private ComponentEosInterface component = null;
    protected double m;
    protected double[] parameters = new double[3];
    protected double[] parametersSolid = new double[3];

    public AttractiveTermBaseClass(ComponentEosInterface component) {
        this.setComponent(component);
    }

    @Override
    public void setm(double val) {
        this.m = val;
        logger.info("does not solve for accentric when new m is set... in AccentricBase class");
    }

    @Override
    public double getm() {
        return this.m;
    }

    @Override
    public AttractiveTermBaseClass clone() {
        AttractiveTermBaseClass attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermBaseClass)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return attractiveTerm;
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        return 0.0;
    }

    @Override
    public double diffdiffaT(double temperature) {
        return 0.0;
    }

    @Override
    public double aT(double temperature) {
        return this.getComponent().geta();
    }

    @Override
    public double alpha(double temperature) {
        return 1.0;
    }

    @Override
    public double diffaT(double temperature) {
        return 0.0;
    }

    @Override
    public double diffalphaT(double temperature) {
        return 0.0;
    }

    @Override
    public void setParameters(int i, double val) {
        this.parameters[i] = val;
    }

    @Override
    public double getParameters(int i) {
        return this.parameters[i];
    }

    ComponentEosInterface getComponent() {
        return this.component;
    }

    void setComponent(ComponentEosInterface component) {
        this.component = component;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AttractiveTermBaseClass other = (AttractiveTermBaseClass)obj;
        if (Double.compare(this.m, other.m) != 0) {
            return false;
        }
        if (!Arrays.equals(this.parameters, other.parameters)) {
            return false;
        }
        if (!Arrays.equals(this.parametersSolid, other.parametersSolid)) {
            return false;
        }
        return this.component != null || other.component == null;
    }
}

