/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.mixingrule;

import java.sql.ResultSet;
import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.ComponentSrkCPA;
import neqsim.thermo.mixingrule.CPAMixingRuleType;
import neqsim.thermo.mixingrule.CPAMixingRulesInterface;
import neqsim.thermo.mixingrule.MixingRuleHandler;
import neqsim.thermo.mixingrule.MixingRuleTypeInterface;
import neqsim.thermo.mixingrule.MixingRulesInterface;
import neqsim.thermo.phase.PhaseCPAInterface;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;
import neqsim.util.exception.InvalidInputException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CPAMixingRuleHandler
extends MixingRuleHandler {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(CPAMixingRuleHandler.class);
    int[][] assosSchemeType = null;
    double[][] cpaBetaCross = null;
    double[][] cpaEpsCross = null;
    final int[] charge4C = new int[]{1, 1, -1, -1};
    final int[] charge1A = new int[]{-1};
    final int[] charge2A = new int[]{-1, -1};
    final int[] charge2B = new int[]{1, -1};

    public CPAMixingRuleHandler() {
        this.mixingRuleName = "CPA_Radoch";
    }

    public CPAMixingRulesInterface getMixingRule(MixingRuleTypeInterface mr) {
        if (!CPAMixingRuleType.class.isInstance(mr)) {
            throw new RuntimeException(new InvalidInputException(this, "setMixingRule", "mr"));
        }
        CPAMixingRuleType cmr = (CPAMixingRuleType)mr;
        switch (cmr) {
            case CPA_RADOCH: {
                this.mixingRuleName = "CPA_Radoch";
                return new CPA_Radoch();
            }
            case PCSAFTA_RADOCH: {
                this.mixingRuleName = "PCSAFTa_Radoch";
                return new PCSAFTa_Radoch();
            }
        }
        return new CPA_Radoch();
    }

    public CPAMixingRulesInterface getMixingRule(int mr) {
        if (mr == 1) {
            this.mixingRuleName = "CPA_Radoch";
            return new CPA_Radoch();
        }
        if (mr == 3) {
            this.mixingRuleName = "PCSAFTa_Radoch";
            return new PCSAFTa_Radoch();
        }
        throw new RuntimeException(new InvalidInputException(this, "getMixingRule", "mr"));
    }

    public CPAMixingRulesInterface getMixingRule(int mr, PhaseInterface phase) {
        this.assosSchemeType = new int[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.cpaBetaCross = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.cpaEpsCross = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        for (int k = 0; k < phase.getNumberOfComponents(); ++k) {
            String component_name = phase.getComponent(k).getComponentName();
            ResultSet dataSet = null;
            for (int l = k; l < phase.getNumberOfComponents(); ++l) {
                if (k == l || phase.getComponent(l).getNumberOfAssociationSites() == 0 || phase.getComponent(k).getNumberOfAssociationSites() == 0) continue;
                try (NeqSimDataBase database = new NeqSimDataBase();){
                    dataSet = NeqSimDataBase.createTemporaryTables() ? database.getResultSet("SELECT * FROM intertemp WHERE (comp1='" + component_name + "' AND comp2='" + phase.getComponent(l).getComponentName() + "') OR (comp1='" + phase.getComponent(l).getComponentName() + "' AND comp2='" + component_name + "')") : database.getResultSet("SELECT * FROM inter WHERE (comp1='" + component_name + "' AND comp2='" + phase.getComponent(l).getComponentName() + "') OR (comp1='" + phase.getComponent(l).getComponentName() + "' AND comp2='" + component_name + "')");
                    if (!dataSet.next()) continue;
                    this.assosSchemeType[k][l] = Integer.parseInt(dataSet.getString("cpaAssosiationType").trim());
                    this.assosSchemeType[l][k] = this.assosSchemeType[k][l];
                    this.cpaBetaCross[k][l] = Double.parseDouble(dataSet.getString("cpaBetaCross").trim());
                    this.cpaBetaCross[l][k] = this.cpaBetaCross[k][l];
                    this.cpaEpsCross[k][l] = Double.parseDouble(dataSet.getString("cpaEpsCross").trim());
                    this.cpaEpsCross[l][k] = this.cpaEpsCross[k][l];
                    continue;
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return this.getMixingRule(mr);
    }

    public MixingRulesInterface resetMixingRule(int i, PhaseInterface phase) {
        return this.getMixingRule(i);
    }

    public CPAMixingRuleHandler clone() {
        CPAMixingRuleHandler clonedSystem = null;
        try {
            clonedSystem = (CPAMixingRuleHandler)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }

    public int[][] setAssociationScheme(int compnumb, PhaseInterface phase) {
        if (phase.getComponent(compnumb).getAssociationScheme().equals("4C")) {
            return this.getInteractionMatrix(this.charge4C, this.charge4C);
        }
        if (phase.getComponent(compnumb).getAssociationScheme().equals("2B")) {
            return this.getInteractionMatrix(this.charge2B, this.charge2B);
        }
        if (phase.getComponent(compnumb).getAssociationScheme().equals("1A")) {
            return this.getInteractionMatrix(this.charge1A, this.charge1A);
        }
        if (phase.getComponent(compnumb).getAssociationScheme().equals("2A")) {
            return this.getInteractionMatrix(this.charge2A, this.charge2A);
        }
        return new int[0][0];
    }

    public int[][] setCrossAssociationScheme(int compnumb, int compnumb2, PhaseInterface phase) {
        int[] comp1Scheme = new int[]{};
        int[] comp2Scheme = new int[]{};
        if (phase.getComponent(compnumb).getOrginalNumberOfAssociationSites() * phase.getComponent(compnumb2).getOrginalNumberOfAssociationSites() > 0) {
            if (phase.getComponent(compnumb).getAssociationScheme().equals("4C")) {
                comp1Scheme = this.charge4C;
            }
            if (phase.getComponent(compnumb).getAssociationScheme().equals("2A")) {
                comp1Scheme = this.charge2A;
            }
            if (phase.getComponent(compnumb).getAssociationScheme().equals("2B")) {
                comp1Scheme = this.charge2B;
            }
            if (phase.getComponent(compnumb).getAssociationScheme().equals("1A")) {
                comp1Scheme = this.charge1A;
            }
            if (phase.getComponent(compnumb2).getAssociationScheme().equals("4C")) {
                comp2Scheme = this.charge4C;
            }
            if (phase.getComponent(compnumb2).getAssociationScheme().equals("2A")) {
                comp2Scheme = this.charge2A;
            }
            if (phase.getComponent(compnumb2).getAssociationScheme().equals("2B")) {
                comp2Scheme = this.charge2B;
            }
            if (phase.getComponent(compnumb2).getAssociationScheme().equals("1A")) {
                comp2Scheme = this.charge1A;
            }
        } else {
            return new int[0][0];
        }
        return this.getInteractionMatrix(comp1Scheme, comp2Scheme);
    }

    public int[][] getInteractionMatrix(int[] comp1Scheme, int[] comp2Scheme) {
        int[][] intMatrix = new int[comp1Scheme.length][comp2Scheme.length];
        for (int i = 0; i < comp1Scheme.length; ++i) {
            for (int j = 0; j < comp2Scheme.length; ++j) {
                intMatrix[i][j] = comp1Scheme[i] * comp2Scheme[j] < 0 ? 1 : 0;
            }
        }
        return intMatrix;
    }

    public class CPA_Radoch
    extends CPA_Radoch_base {
        private static final long serialVersionUID = 1000L;

        @Override
        public String getName() {
            return CPAMixingRuleHandler.this.mixingRuleName;
        }

        public double getCrossAssociationEnergy(int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            if (Math.abs(CPAMixingRuleHandler.this.cpaEpsCross[compnumb1][compnumb2]) > 1.0E-10) {
                return CPAMixingRuleHandler.this.cpaEpsCross[compnumb1][compnumb2];
            }
            return (phase.getComponent(compnumb1).getAssociationEnergy() + phase.getComponent(compnumb2).getAssociationEnergy()) / 2.0;
        }

        public double getCrossAssociationVolume(int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            if (Math.abs(CPAMixingRuleHandler.this.cpaBetaCross[compnumb1][compnumb2]) > 1.0E-10) {
                return CPAMixingRuleHandler.this.cpaBetaCross[compnumb1][compnumb2];
            }
            return Math.sqrt(phase.getComponent(compnumb1).getAssociationVolume() * phase.getComponent(compnumb2).getAssociationVolume());
        }

        @Override
        public double calcDelta(int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            if (CPAMixingRuleHandler.this.assosSchemeType[compnumb1][compnumb2] == 0) {
                double temp2 = 0.0;
                double temp1 = (Math.exp(this.getCrossAssociationEnergy(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) - 1.0) * (((ComponentEosInterface)phase.getComponent(compnumb1)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb1)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
                temp2 = compnumb1 == compnumb2 ? temp1 : (Math.exp(this.getCrossAssociationEnergy(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) - 1.0) * (((ComponentEosInterface)phase.getComponent(compnumb2)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb2)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
                return (double)((PhaseCPAInterface)phase).getCrossAssosiationScheme(compnumb1, compnumb2, siteNumber1, siteNumber2) * Math.sqrt(temp1 * temp2);
            }
            return (double)((PhaseCPAInterface)phase).getCrossAssosiationScheme(compnumb1, compnumb2, siteNumber1, siteNumber2) * (Math.exp(this.getCrossAssociationEnergy(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) - 1.0) * (((ComponentEosInterface)phase.getComponent(compnumb1)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb2)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
        }

        public double calcDelta(int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            if (CPAMixingRuleHandler.this.assosSchemeType[compnumb1][compnumb2] == 0) {
                double temp2 = 0.0;
                double temp1 = (Math.exp(this.getCrossAssociationEnergy(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) - 1.0) * (((ComponentEosInterface)phase.getComponent(compnumb1)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb1)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
                temp2 = compnumb1 == compnumb2 ? temp1 : (Math.exp(this.getCrossAssociationEnergy(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) - 1.0) * (((ComponentEosInterface)phase.getComponent(compnumb2)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb2)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
                return Math.sqrt(temp1 * temp2);
            }
            return (Math.exp(this.getCrossAssociationEnergy(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) - 1.0) * (((ComponentEosInterface)phase.getComponent(compnumb1)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb2)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
        }

        @Override
        public double calcDeltaNog(int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            if (CPAMixingRuleHandler.this.assosSchemeType[compnumb1][compnumb2] == 0) {
                double temp2 = 0.0;
                double temp1 = (Math.exp(this.getCrossAssociationEnergy(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) - 1.0) * (((ComponentEosInterface)phase.getComponent(compnumb1)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb1)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb1, compnumb1, phase, temperature, pressure, numbcomp);
                temp2 = compnumb1 == compnumb2 ? temp1 : (Math.exp(this.getCrossAssociationEnergy(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) - 1.0) * (((ComponentEosInterface)phase.getComponent(compnumb2)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb2)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb2, compnumb2, phase, temperature, pressure, numbcomp);
                return (double)((PhaseCPAInterface)phase).getCrossAssosiationScheme(compnumb1, compnumb2, siteNumber1, siteNumber2) * Math.sqrt(temp1 * temp2);
            }
            return (double)((PhaseCPAInterface)phase).getCrossAssosiationScheme(compnumb1, compnumb2, siteNumber1, siteNumber2) * (Math.exp(this.getCrossAssociationEnergy(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) - 1.0) * (((ComponentEosInterface)phase.getComponent(compnumb1)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb2)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb1, compnumb2, phase, temperature, pressure, numbcomp);
        }

        @Override
        public double calcDeltadN(int derivativeComp, int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            return (double)((PhaseCPAInterface)phase).getCrossAssosiationScheme(compnumb1, compnumb2, siteNumber1, siteNumber2) * this.calcDelta(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) * ((ComponentSrkCPA)phase.getComponent(derivativeComp)).calc_lngi(phase);
        }

        @Override
        public double calcDeltadT(int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            if (CPAMixingRuleHandler.this.assosSchemeType[compnumb1][compnumb2] == 0) {
                double derivative1 = -this.getCrossAssociationEnergy(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature() * phase.getTemperature()) * Math.exp(this.getCrossAssociationEnergy(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) * (((ComponentEosInterface)phase.getComponent(compnumb2)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb2)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
                double temp1 = derivative1 * (Math.exp(this.getCrossAssociationEnergy(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) - 1.0) * (((ComponentEosInterface)phase.getComponent(compnumb1)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb1)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
                double derivative2 = -this.getCrossAssociationEnergy(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature() * phase.getTemperature()) * Math.exp(this.getCrossAssociationEnergy(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) * (((ComponentEosInterface)phase.getComponent(compnumb1)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb1)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
                double temp2 = derivative2 * (Math.exp(this.getCrossAssociationEnergy(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) - 1.0) * (((ComponentEosInterface)phase.getComponent(compnumb2)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb2)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
                return (double)((PhaseCPAInterface)phase).getCrossAssosiationScheme(compnumb1, compnumb2, siteNumber1, siteNumber2) * 0.5 / this.calcDelta(siteNumber1, siteNumber2, compnumb1, compnumb2, phase, temperature, pressure, numbcomp) * (temp1 + temp2);
            }
            double derivative = -this.getCrossAssociationEnergy(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature() * phase.getTemperature());
            return (double)((PhaseCPAInterface)phase).getCrossAssosiationScheme(compnumb1, compnumb2, siteNumber1, siteNumber2) * derivative * (Math.exp(this.getCrossAssociationEnergy(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) - 1.0) * (((ComponentEosInterface)phase.getComponent(compnumb1)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb2)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
        }

        @Override
        public double calcDeltadV(int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            return (double)((PhaseCPAInterface)phase).getCrossAssosiationScheme(compnumb1, compnumb2, siteNumber1, siteNumber2) * this.calcDelta(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpav();
        }

        @Override
        public double calcDeltadTdV(int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            if (CPAMixingRuleHandler.this.assosSchemeType[compnumb1][compnumb2] == 0) {
                if (((PhaseCPAInterface)phase).getCrossAssosiationScheme(compnumb1, compnumb2, siteNumber1, siteNumber2) == 1) {
                    double tempDelta = this.calcDelta(compnumb2, compnumb2, phase, temperature, pressure, numbcomp);
                    return (double)((PhaseCPAInterface)phase).getCrossAssosiationScheme(compnumb1, compnumb2, siteNumber1, siteNumber2) * 0.5 * Math.pow(tempDelta, -1.0) * 2.0 * this.calcDeltadT(siteNumber1, siteNumber2, compnumb1, compnumb2, phase, temperature, pressure, numbcomp) * tempDelta * ((PhaseCPAInterface)phase).getGcpav();
                }
                return 0.0;
            }
            double derivative = -this.getCrossAssociationEnergy(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature() * phase.getTemperature());
            return (double)((PhaseCPAInterface)phase).getCrossAssosiationScheme(compnumb1, compnumb2, siteNumber1, siteNumber2) * derivative * Math.exp(this.getCrossAssociationEnergy(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) * (((ComponentEosInterface)phase.getComponent(compnumb1)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb2)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa() * ((PhaseCPAInterface)phase).getGcpav();
        }

        @Override
        public double calcDeltadTdT(int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            if (CPAMixingRuleHandler.this.assosSchemeType[compnumb1][compnumb2] == 0) {
                double deltaj = 0.0;
                double deltai = this.calcDelta(compnumb1, compnumb1, phase, temperature, pressure, numbcomp);
                deltaj = compnumb1 == compnumb2 ? deltai : this.calcDelta(compnumb2, compnumb2, phase, temperature, pressure, numbcomp);
                double dDeltaidT = -this.getCrossAssociationEnergy(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature() * phase.getTemperature()) * Math.exp(this.getCrossAssociationEnergy(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) * (((ComponentEosInterface)phase.getComponent(compnumb1)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb1)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
                double dDeltajdT = -this.getCrossAssociationEnergy(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature() * phase.getTemperature()) * Math.exp(this.getCrossAssociationEnergy(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) * (((ComponentEosInterface)phase.getComponent(compnumb2)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb2)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
                double dDeltajdTdT = (2.0 * this.getCrossAssociationEnergy(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature() * phase.getTemperature() * phase.getTemperature()) * Math.exp(this.getCrossAssociationEnergy(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) + Math.pow(this.getCrossAssociationEnergy(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature() * phase.getTemperature()), 2.0) * Math.exp(this.getCrossAssociationEnergy(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature()))) * (((ComponentEosInterface)phase.getComponent(compnumb2)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb2)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb2, compnumb2, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
                double dDeltaidTdT = (2.0 * this.getCrossAssociationEnergy(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature() * phase.getTemperature() * phase.getTemperature()) * Math.exp(this.getCrossAssociationEnergy(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) + Math.pow(this.getCrossAssociationEnergy(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature() * phase.getTemperature()), 2.0) * Math.exp(this.getCrossAssociationEnergy(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature()))) * (((ComponentEosInterface)phase.getComponent(compnumb1)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb1)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb1, compnumb1, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
                double deltajjdeltaii = Math.pow(this.calcDelta(siteNumber1, siteNumber2, compnumb1, compnumb2, phase, temperature, pressure, numbcomp), 2.0);
                return (double)((PhaseCPAInterface)phase).getCrossAssosiationScheme(compnumb1, compnumb2, siteNumber1, siteNumber2) * (-0.25 * Math.pow(deltajjdeltaii, -1.5) * Math.pow(dDeltaidT * deltaj + dDeltajdT * deltai, 2.0) + 0.5 * Math.pow(deltajjdeltaii, -0.5) * (dDeltaidTdT * deltaj + 2.0 * dDeltaidT * dDeltajdT + dDeltajdTdT * deltai));
            }
            double derivative1 = -this.getCrossAssociationEnergy(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature() * phase.getTemperature());
            double derivative2 = 2.0 * this.getCrossAssociationEnergy(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature() * phase.getTemperature() * phase.getTemperature());
            return (double)((PhaseCPAInterface)phase).getCrossAssosiationScheme(compnumb1, compnumb2, siteNumber1, siteNumber2) * derivative1 * derivative1 * Math.exp(this.getCrossAssociationEnergy(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) * (((ComponentEosInterface)phase.getComponent(compnumb1)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb2)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa() + (double)((PhaseCPAInterface)phase).getCrossAssosiationScheme(compnumb1, compnumb2, siteNumber1, siteNumber2) * derivative2 * Math.exp(this.getCrossAssociationEnergy(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) * (((ComponentEosInterface)phase.getComponent(compnumb1)).getb() + ((ComponentEosInterface)phase.getComponent(compnumb2)).getb()) / 2.0 * this.getCrossAssociationVolume(compnumb1, compnumb2, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
        }
    }

    public class PCSAFTa_Radoch
    extends CPA_Radoch {
        private static final long serialVersionUID = 1000L;

        public double getCrossAssociationEnergy(int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            return (phase.getComponent(compnumb1).getAssociationEnergySAFT() + phase.getComponent(compnumb2).getAssociationEnergySAFT()) / 2.0;
        }

        public double getCrossAssociationVolume(int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            double extrwterm = Math.pow(Math.sqrt(phase.getComponent(compnumb1).getSigmaSAFTi() * phase.getComponent(compnumb2).getSigmaSAFTi()) / (0.5 * (phase.getComponent(compnumb1).getSigmaSAFTi() + phase.getComponent(compnumb2).getSigmaSAFTi())), 3.0);
            return Math.sqrt(phase.getComponent(compnumb1).getAssociationVolumeSAFT() * phase.getComponent(compnumb2).getAssociationVolumeSAFT()) * extrwterm;
        }

        @Override
        public double calcDelta(int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            return (Math.exp(this.getCrossAssociationEnergy(siteNumber1, siteNumber2, compnumb1, compnumb2, phase, temperature, pressure, numbcomp) / (8.3144621 * phase.getTemperature())) - 1.0) * Math.pow((phase.getComponent(compnumb1).getSigmaSAFTi() + phase.getComponent(compnumb2).getSigmaSAFTi()) / 2.0, 3.0) * 100000.0 * 6.023E23 * this.getCrossAssociationVolume(siteNumber1, siteNumber2, compnumb1, compnumb2, phase, temperature, pressure, numbcomp) * ((PhaseCPAInterface)phase).getGcpa();
        }
    }

    public abstract class CPA_Radoch_base
    implements CPAMixingRulesInterface {
        private static final long serialVersionUID = 1000L;
        double eps = 12000.76;
        double beta = 0.03;
        protected double[][] epsab = new double[][]{{0.0, this.eps, this.eps, this.eps}, {this.eps, 0.0, this.eps, this.eps}, {this.eps, this.eps, 0.0, this.eps}, {this.eps, this.eps, this.eps, 0.0}};
        protected double[][] betamat = new double[][]{{0.0, this.beta, this.beta, this.beta}, {this.beta, 0.0, this.beta, this.beta}, {this.beta, this.beta, 0.0, this.beta}, {this.beta, this.beta, this.beta, 0.0}};

        public double calcXi(int siteNumber, int compnumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            return 1.0;
        }

        @Override
        public double calcXi(int[][][] assosScheme, int[][][][] assosScheme2, int siteNumber, int compnumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            return 1.0;
        }

        @Override
        public double calcDelta(int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            return 1.0;
        }

        @Override
        public double calcDeltaNog(int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            return 1.0;
        }

        @Override
        public double calcDeltadN(int derivativeComp, int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            return 1.0;
        }

        @Override
        public double calcDeltadT(int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            return 1.0;
        }

        @Override
        public double calcDeltadV(int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            return 1.0;
        }

        @Override
        public double calcDeltadTdT(int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            return 1.0;
        }

        @Override
        public double calcDeltadTdV(int siteNumber1, int siteNumber2, int compnumb1, int compnumb2, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
            return 1.0;
        }
    }
}

