/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentGEInterface;
import neqsim.thermo.component.ComponentGENRTLmodifiedHV;
import neqsim.thermo.mixingrule.MixingRuleTypeInterface;
import neqsim.thermo.phase.PhaseGENRTL;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseType;

public class PhaseGENRTLmodifiedHV
extends PhaseGENRTL {
    private static final long serialVersionUID = 1000L;
    double[][] DijT;
    int type = 0;

    public PhaseGENRTLmodifiedHV() {
        this.mixRule = this.mixSelect.getMixingRule(1);
    }

    public PhaseGENRTLmodifiedHV(PhaseInterface phase, double[][] alpha, double[][] Dij, String[][] mixRule, double[][] intparam) {
        super(phase, alpha, Dij, mixRule, intparam);
        this.componentArray = new ComponentGENRTLmodifiedHV[alpha[0].length];
        this.type = 0;
        for (int i = 0; i < alpha[0].length; ++i) {
            this.componentArray[i] = new ComponentGENRTLmodifiedHV(phase.getComponent(i).getName(), phase.getComponent(i).getNumberOfmoles(), phase.getComponent(i).getNumberOfMolesInPhase(), phase.getComponent(i).getComponentNumber());
        }
    }

    public PhaseGENRTLmodifiedHV(PhaseInterface phase, double[][] alpha, double[][] Dij, double[][] DijT, String[][] mixRule, double[][] intparam) {
        super(phase, alpha, Dij, mixRule, intparam);
        this.componentArray = new ComponentGENRTLmodifiedHV[alpha[0].length];
        this.type = 1;
        this.DijT = DijT;
        for (int i = 0; i < alpha[0].length; ++i) {
            this.componentArray[i] = new ComponentGENRTLmodifiedHV(phase.getComponent(i).getName(), phase.getComponent(i).getNumberOfmoles(), phase.getComponent(i).getNumberOfMolesInPhase(), phase.getComponent(i).getComponentNumber());
        }
    }

    @Override
    public void addComponent(String name, double moles, double molesInPhase, int compNumber) {
        super.addComponent(name, molesInPhase, compNumber);
        this.componentArray[compNumber] = new ComponentGENRTLmodifiedHV(name, moles, molesInPhase, compNumber);
    }

    @Override
    public void setMixingRule(MixingRuleTypeInterface mr) {
        super.setMixingRule(mr);
        this.DijT = this.mixSelect.getHVDijT();
        this.intparam = this.mixSelect.getSRKbinaryInteractionParameters();
        this.alpha = this.mixSelect.getHValpha();
        this.mixRuleString = this.mixSelect.getClassicOrHV();
        this.Dij = this.mixSelect.getHVDij();
    }

    @Override
    public void setParams(PhaseInterface phase, double[][] alpha, double[][] Dij, double[][] DijT, String[][] mixRule, double[][] intparam) {
        this.mixRuleString = mixRule;
        this.alpha = alpha;
        this.Dij = Dij;
        this.type = 1;
        this.DijT = DijT;
        this.intparam = intparam;
    }

    @Override
    public void setDijT(double[][] DijT) {
        for (int i = 0; i < DijT.length; ++i) {
            System.arraycopy(DijT[i], 0, this.DijT[i], 0, DijT[0].length);
        }
    }

    @Override
    public double getExcessGibbsEnergy(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, PhaseType pt) {
        this.GE = 0.0;
        for (int i = 0; i < numberOfComponents; ++i) {
            if (this.type == 0) {
                this.GE += phase.getComponent(i).getx() * Math.log(((ComponentGEInterface)this.componentArray[i]).getGamma(phase, numberOfComponents, temperature, pressure, pt, this.alpha, this.Dij, this.intparam, this.mixRuleString));
                continue;
            }
            if (this.type != 1) continue;
            this.GE += phase.getComponent(i).getx() * Math.log(((ComponentGENRTLmodifiedHV)this.componentArray[i]).getGamma(phase, numberOfComponents, temperature, pressure, pt, this.alpha, this.Dij, this.DijT, this.intparam, this.mixRuleString));
        }
        return 8.3144621 * phase.getTemperature() * phase.getNumberOfMolesInPhase() * this.GE;
    }

    @Override
    public double getGibbsEnergy() {
        double val = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            val += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(i).getLogFugacityCoefficient();
        }
        return 8.3144621 * this.temperature * this.numberOfMolesInPhase * (val + Math.log(this.pressure));
    }

    @Override
    public double getHresTP() {
        double val = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            val -= this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(i).getdfugdt();
        }
        return 8.3144621 * this.temperature * this.temperature * val;
    }
}

