/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseGERG2008Eos;
import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.system.SystemEos;

public class SystemGERG2008Eos
extends SystemEos {
    private static final long serialVersionUID = 1000L;

    public SystemGERG2008Eos() {
        this(298.15, 1.0, false);
    }

    public SystemGERG2008Eos(double T, double P) {
        this(T, P, false);
    }

    public SystemGERG2008Eos(double T, double P, boolean checkForSolids) {
        super(T, P, checkForSolids);
        this.modelName = "GERG2008-EOS";
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseGERG2008Eos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        if (this.solidPhaseCheck) {
            this.setNumberOfPhases(5);
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        if (this.hydrateCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhaseHydrate();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        this.useVolumeCorrection(false);
        this.commonInitialization();
    }

    @Override
    public SystemGERG2008Eos clone() {
        SystemGERG2008Eos clonedSystem = null;
        try {
            clonedSystem = (SystemGERG2008Eos)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }

    public void commonInitialization() {
        this.setImplementedCompositionDeriativesofFugacity(false);
        this.setImplementedPressureDeriativesofFugacity(false);
        this.setImplementedTemperatureDeriativesofFugacity(false);
    }
}

