/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhasePrEos;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.system.SystemPrEos;

public class SystemPrGassemEos
extends SystemPrEos {
    private static final long serialVersionUID = 1000L;

    public SystemPrGassemEos() {
        this(298.15, 1.0, false);
    }

    public SystemPrGassemEos(double T, double P) {
        this(T, P, false);
    }

    public SystemPrGassemEos(double T, double P, boolean checkForSolids) {
        super(T, P, checkForSolids);
        this.modelName = "PR-Gassem-EOS";
        this.attractiveTermNumber = 8;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhasePrEos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        if (this.solidPhaseCheck) {
            this.setNumberOfPhases(5);
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        if (this.hydrateCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhaseHydrate();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemPrGassemEos clone() {
        SystemPrGassemEos clonedSystem = null;
        try {
            clonedSystem = (SystemPrGassemEos)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }
}

