/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.Vega;

import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermo.util.Vega.Vega;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.netlib.util.StringW;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class NeqSimVega {
    PhaseInterface phase = null;
    Vega Vega = new Vega();

    public NeqSimVega() {
    }

    public NeqSimVega(PhaseInterface phase) {
        this.setPhase(phase);
        if (Double.isNaN(this.Vega.R) || this.Vega.R == 0.0) {
            this.Vega.SetupVega();
        }
    }

    public double getMolarDensity(PhaseInterface phase) {
        return this.getMolarDensity();
    }

    public double getDensity(PhaseInterface phase) {
        return this.getMolarDensity() * this.Vega.M;
    }

    public double getDensity() {
        return this.getMolarDensity() * this.Vega.M;
    }

    public double getPressure() {
        double moldens = this.getMolarDensity();
        doubleW P = new doubleW(0.0);
        doubleW Z = new doubleW(0.0);
        this.Vega.PressureVega(this.phase.getTemperature(), moldens, P, Z);
        return P.val;
    }

    public double getMolarDensity() {
        int flag = 0;
        intW ierr = new intW(0);
        StringW herr = new StringW("");
        doubleW D = new doubleW(0.0);
        double pressure = this.phase.getPressure() * 100.0;
        this.Vega.DensityVega(flag, this.phase.getTemperature(), pressure, D, ierr, herr);
        return D.val;
    }

    public doubleW[] getAlpha0_Vega() {
        double temperature = this.phase.getTemperature();
        double molarDensity = this.getMolarDensity(this.phase);
        int rows = 4;
        int cols = 4;
        doubleW[] a0 = new doubleW[rows];
        for (int i = 0; i < rows; ++i) {
            a0[i] = new doubleW(0.0);
        }
        this.Vega.Alpha0Vega(temperature, molarDensity, a0);
        return a0;
    }

    public doubleW[][] getAlphares_Vega() {
        double temperature = this.phase.getTemperature();
        double molarDensity = this.getMolarDensity(this.phase);
        int rows = 4;
        int cols = 4;
        doubleW[][] ar = new doubleW[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                ar[i][j] = new doubleW(0.0);
            }
        }
        this.Vega.AlpharVega(0, 0, temperature, molarDensity, ar);
        return ar;
    }

    public double[] propertiesVega(PhaseInterface phase) {
        return this.propertiesVega();
    }

    public double[] getProperties(PhaseInterface phase, String[] properties) {
        double[] allProperties = this.propertiesVega();
        double[] returnProperties = new double[properties.length];
        block12: for (int i = 0; i < properties.length; ++i) {
            switch (properties[i]) {
                case "density": {
                    returnProperties[i] = allProperties[0];
                    continue block12;
                }
                case "Cp": {
                    returnProperties[i] = allProperties[1];
                    continue block12;
                }
                case "Cv": {
                    returnProperties[i] = allProperties[2];
                    continue block12;
                }
                case "soundSpeed": {
                    returnProperties[i] = allProperties[3];
                    continue block12;
                }
            }
        }
        return returnProperties;
    }

    public double[] propertiesVega() {
        doubleW p = new doubleW(0.0);
        doubleW z = new doubleW(0.0);
        doubleW dpdd = new doubleW(0.0);
        doubleW d2pdd2 = new doubleW(0.0);
        doubleW d2pdtd = new doubleW(0.0);
        doubleW dpdt = new doubleW(0.0);
        doubleW u = new doubleW(0.0);
        doubleW h = new doubleW(0.0);
        doubleW s = new doubleW(0.0);
        doubleW cv = new doubleW(0.0);
        doubleW cp = new doubleW(0.0);
        doubleW w = new doubleW(0.0);
        doubleW g = new doubleW(0.0);
        doubleW jt = new doubleW(0.0);
        doubleW kappa = new doubleW(0.0);
        doubleW A = new doubleW(0.0);
        double dens = this.getMolarDensity();
        this.Vega.propertiesVega(this.phase.getTemperature(), dens, p, z, dpdd, d2pdd2, d2pdtd, dpdt, u, h, s, cv, cp, w, g, jt, kappa, A);
        double[] properties = new double[]{p.val, z.val, dpdd.val, d2pdd2.val, d2pdtd.val, dpdt.val, u.val, h.val, s.val, cv.val, cp.val, w.val, g.val, jt.val, kappa.val};
        return properties;
    }

    public void setPhase(PhaseInterface phase) {
        if (phase.getNumberOfComponents() != 1) {
            throw new IllegalArgumentException("Vega model requires exactly one component (helium). Found " + phase.getNumberOfComponents() + " components.");
        }
        String componentName = phase.getComponent(0).getComponentName();
        if (!"helium".equalsIgnoreCase(componentName)) {
            throw new IllegalArgumentException("Vega model requires 'helium'. Found: " + componentName);
        }
        this.phase = phase;
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        SystemSrkEos fluid1 = new SystemSrkEos();
        fluid1.addComponent("helium", 90.0);
        fluid1.setTemperature(273.15);
        fluid1.setPressure(10.0);
        fluid1.init(0);
        ThermodynamicOperations ops = new ThermodynamicOperations(fluid1);
        ops.TPflash();
        System.out.println("density Vega " + fluid1.getPhase(0).getDensity_Vega());
        NeqSimVega test = new NeqSimVega(fluid1.getPhase(0));
        System.out.println("density " + test.getDensity());
        System.out.println("pressure " + test.getPressure());
        double[] properties = test.propertiesVega();
        System.out.println("Pressure [kPa]:            " + properties[0]);
        System.out.println("Compressibility factor:            " + properties[1]);
        System.out.println("d(P)/d(rho) [kPa/(mol/l)]            " + properties[2]);
        System.out.println("d^2(P)/d(rho)^2 [kPa/(mol/l)^2]:            " + properties[3]);
        System.out.println("d2(P)/d2(T) [kPa/K]:             " + properties[4]);
        System.out.println("d(P)/d(T) [kPa/K]:             " + properties[5]);
        System.out.println("Energy [J/mol]:             " + properties[6]);
        System.out.println("Enthalpy [J/mol]:             " + properties[7]);
        System.out.println("Entropy [J/mol-K]:             " + properties[8]);
        System.out.println("Isochoric heat capacity [J/mol-K]:             " + properties[9]);
        System.out.println("Isobaric heat capacity [J/mol-K]:            " + properties[10]);
        System.out.println("Speed of sound [m/s]:            " + properties[11]);
        System.out.println("Gibbs energy [J/mol]:            " + properties[12]);
        System.out.println("Joule-Thomson coefficient [K/kPa]:            " + properties[13]);
        System.out.println("Isentropic exponent:           " + properties[14]);
    }
}

