/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.steam;

public final class Iapws_if97 {
    private static final double R = 0.461526;
    private static final int[] I1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 8, 8, 21, 23, 29, 30, 31, 32};
    private static final int[] J1 = new int[]{-2, -1, 0, 1, 2, 3, 4, 5, -9, -7, -1, 0, 1, 3, -3, 0, 1, 3, 17, -4, 0, 6, -5, -2, 10, -8, -11, -6, -29, -31, -38, -39, -40, -41};
    private static final double[] N1 = new double[]{0.14632971213167, -0.84548187169114, -3.756360367204, 3.3855169168385, -0.95791963387872, 0.15772038513228, -0.016616417199501, 8.1214629983568E-4, 2.8319080123804E-4, -6.0706301565874E-4, -0.018990068218419, -0.032529748770505, -0.021841717175414, -5.283835796993E-5, -4.7184321073267E-4, -3.0001780793026E-4, 4.7661393906987E-5, -4.4141845330846E-6, -7.2694996297594E-16, -3.1679644845054E-5, -2.8270797985312E-6, -8.5205128120103E-10, -2.2425281908E-6, -6.5171222895601E-7, -1.4341729937924E-13, -4.0516996860117E-7, -1.2734301741641E-9, -1.7424871230634E-10, -6.8762131295531E-19, 1.4478307828521E-20, 2.6335781662795E-23, -1.1947622640071E-23, 1.8228094581404E-24, -9.3537087292458E-26};
    private static final int[] J0 = new int[]{0, 1, -5, -4, -3, -2, -1, 2, 3};
    private static final double[] N0 = new double[]{-9.6927686500217, 10.086655968018, -0.005608791128302, 0.071452738081455, -0.40710498223928, 1.4240819171444, -4.383951131945, -0.28408632460772, 0.021268463753307};
    private static final int[] IR = new int[]{1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 5, 6, 6, 6, 7, 7, 7, 8, 8, 9, 10, 10, 10, 16, 16, 18, 20, 20, 20, 21, 22, 23, 24, 24, 24};
    private static final int[] JR = new int[]{0, 1, 2, 3, 6, 1, 2, 4, 7, 36, 0, 1, 3, 6, 35, 1, 2, 3, 7, 3, 16, 35, 0, 11, 25, 8, 36, 13, 4, 10, 14, 29, 50, 57, 20, 35, 48, 21, 53, 39, 26, 40, 58};
    private static final double[] NR = new double[]{-0.0017731742473213, -0.017834862292358, -0.045996013696365, -0.057581259083432, -0.05032527872793, -3.3032641670203E-5, -1.8948987516315E-4, -0.0039392777243355, -0.043797295650573, -2.6674547914087E-5, 2.0481737692309E-8, 4.3870667284435E-7, -3.227767723857E-5, -0.0015033924542148, -0.040668253562649, -7.8847309559367E-10, 1.2790717852285E-8, 4.8225372718507E-7, 2.2922076337661E-6, -1.6714766451061E-11, -0.0021171472321355, -23.895741934104, -5.905956432427E-18, -1.2621808899101E-6, -0.038946842435739, 1.1256211360459E-11, -8.2311340897998, 1.9809712802088E-8, 1.0406965210174E-19, -1.0234747095929E-13, -1.0018179379511E-9, -8.0882908646985E-11, 0.10693031879409, -0.33662250574171, 8.9185845355421E-25, 3.0629316876232E-13, -4.2002467698208E-6, -5.9056029685639E-26, 3.7826947613457E-6, -1.2768608934681E-15, 7.3087610595061E-29, 5.5414715350778E-17, -9.436970724121E-7};

    private Iapws_if97() {
    }

    public static double p4_T(double T) {
        double theta = T - 0.23855557567849 / (T - 650.17534844798);
        double a = theta * theta + 1167.0521452767 * theta - 724213.16703206;
        double b = -17.073846940092 * theta * theta + 12020.82470247 * theta - 3232555.0322333;
        double c = 14.91510861353 * theta * theta - 4823.2657361591 * theta + 405113.40542057;
        return Math.pow(2.0 * c / (-b + Math.sqrt(b * b - 4.0 * a * c)), 4.0);
    }

    public static double T4_p(double p) {
        double beta = Math.pow(p, 0.25);
        double e = beta * beta - 17.073846940092 * beta + 14.91510861353;
        double f = 1167.0521452767 * beta * beta + 12020.82470247 * beta - 4823.2657361591;
        double g = -724213.16703206 * beta * beta - 3232555.0322333 * beta + 405113.40542057;
        double d = 2.0 * g / (-f - Math.sqrt(f * f - 4.0 * e * g));
        double temp = (650.17534844798 + d - Math.sqrt(Math.pow(650.17534844798 + d, 2.0) - 4.0 * (-0.23855557567849 + 650.17534844798 * d))) / 2.0;
        return temp;
    }

    private static double gamma1(double pi, double tau) {
        double sum = 0.0;
        for (int i = 0; i < N1.length; ++i) {
            sum += N1[i] * Math.pow(7.1 - pi, I1[i]) * Math.pow(tau - 1.222, J1[i]);
        }
        return sum;
    }

    private static double gamma1_pi(double pi, double tau) {
        double sum = 0.0;
        for (int i = 0; i < N1.length; ++i) {
            sum -= N1[i] * (double)I1[i] * Math.pow(7.1 - pi, I1[i] - 1) * Math.pow(tau - 1.222, J1[i]);
        }
        return sum;
    }

    private static double gamma1_tau(double pi, double tau) {
        double sum = 0.0;
        for (int i = 0; i < N1.length; ++i) {
            sum += N1[i] * Math.pow(7.1 - pi, I1[i]) * (double)J1[i] * Math.pow(tau - 1.222, J1[i] - 1);
        }
        return sum;
    }

    private static double gamma0(double pi, double tau) {
        double sum = Math.log(pi);
        for (int i = 0; i < N0.length; ++i) {
            sum += N0[i] * Math.pow(tau, J0[i]);
        }
        return sum;
    }

    private static double gamma0_pi(double pi) {
        return 1.0 / pi;
    }

    private static double gamma0_tau(double pi, double tau) {
        double sum = 0.0;
        for (int i = 0; i < N0.length; ++i) {
            sum += N0[i] * (double)J0[i] * Math.pow(tau, J0[i] - 1);
        }
        return sum;
    }

    private static double gammar(double pi, double tau) {
        double sum = 0.0;
        for (int i = 0; i < NR.length; ++i) {
            sum += NR[i] * Math.pow(pi, IR[i]) * Math.pow(tau - 0.5, JR[i]);
        }
        return sum;
    }

    private static double gammar_pi(double pi, double tau) {
        double sum = 0.0;
        for (int i = 0; i < NR.length; ++i) {
            sum += NR[i] * (double)IR[i] * Math.pow(pi, IR[i] - 1) * Math.pow(tau - 0.5, JR[i]);
        }
        return sum;
    }

    private static double gammar_tau(double pi, double tau) {
        double sum = 0.0;
        for (int i = 0; i < NR.length; ++i) {
            sum += NR[i] * Math.pow(pi, IR[i]) * (double)JR[i] * Math.pow(tau - 0.5, JR[i] - 1);
        }
        return sum;
    }

    private static double gamma1_pipi(double pi, double tau) {
        double sum = 0.0;
        for (int i = 0; i < N1.length; ++i) {
            sum += N1[i] * (double)I1[i] * ((double)I1[i] - 1.0) * Math.pow(7.1 - pi, (double)I1[i] - 2.0) * Math.pow(tau - 1.222, J1[i]);
        }
        return sum;
    }

    private static double gamma1_pitau(double pi, double tau) {
        double sum = 0.0;
        for (int i = 0; i < N1.length; ++i) {
            sum -= N1[i] * (double)I1[i] * Math.pow(7.1 - pi, (double)I1[i] - 1.0) * (double)J1[i] * Math.pow(tau - 1.222, (double)J1[i] - 1.0);
        }
        return sum;
    }

    private static double gamma1_tautau(double pi, double tau) {
        double sum = 0.0;
        for (int i = 0; i < N1.length; ++i) {
            sum += N1[i] * Math.pow(7.1 - pi, I1[i]) * (double)J1[i] * ((double)J1[i] - 1.0) * Math.pow(tau - 1.222, (double)J1[i] - 2.0);
        }
        return sum;
    }

    private static double gamma0_tautau(double tau) {
        double sum = 0.0;
        for (int i = 0; i < N0.length; ++i) {
            sum += N0[i] * (double)J0[i] * ((double)J0[i] - 1.0) * Math.pow(tau, (double)J0[i] - 2.0);
        }
        return sum;
    }

    private static double gammar_pipi(double pi, double tau) {
        double sum = 0.0;
        for (int i = 0; i < NR.length; ++i) {
            sum += NR[i] * (double)IR[i] * ((double)IR[i] - 1.0) * Math.pow(pi, (double)IR[i] - 2.0) * Math.pow(tau - 0.5, JR[i]);
        }
        return sum;
    }

    private static double gammar_pitau(double pi, double tau) {
        double sum = 0.0;
        for (int i = 0; i < NR.length; ++i) {
            sum += NR[i] * (double)IR[i] * Math.pow(pi, (double)IR[i] - 1.0) * (double)JR[i] * Math.pow(tau - 0.5, (double)JR[i] - 1.0);
        }
        return sum;
    }

    private static double gammar_tautau(double pi, double tau) {
        double sum = 0.0;
        for (int i = 0; i < NR.length; ++i) {
            sum += NR[i] * Math.pow(pi, IR[i]) * (double)JR[i] * ((double)JR[i] - 1.0) * Math.pow(tau - 0.5, (double)JR[i] - 2.0);
        }
        return sum;
    }

    public static double v_pt(double p, double T) {
        double ts = Iapws_if97.T4_p(p);
        if (T <= ts) {
            double pi = p / 16.53;
            double tau = 1386.0 / T;
            return 0.461526 * T / p * pi * Iapws_if97.gamma1_pi(pi, tau) / 1000.0;
        }
        double pi = p;
        double tau = 540.0 / T;
        return 0.461526 * T / p * pi * (Iapws_if97.gamma0_pi(pi) + Iapws_if97.gammar_pi(pi, tau)) / 1000.0;
    }

    public static double h_pt(double p, double T) {
        double ts = Iapws_if97.T4_p(p);
        if (T <= ts) {
            double pi = p / 16.53;
            double tau = 1386.0 / T;
            return 0.461526 * T * tau * Iapws_if97.gamma1_tau(pi, tau);
        }
        double pi = p;
        double tau = 540.0 / T;
        return 0.461526 * T * tau * (Iapws_if97.gamma0_tau(pi, tau) + Iapws_if97.gammar_tau(pi, tau));
    }

    public static double s_pt(double p, double T) {
        double ts = Iapws_if97.T4_p(p);
        if (T <= ts) {
            double pi = p / 16.53;
            double tau = 1386.0 / T;
            double g = Iapws_if97.gamma1(pi, tau);
            double g_tau = Iapws_if97.gamma1_tau(pi, tau);
            return 0.461526 * (tau * g_tau - g);
        }
        double pi = p;
        double tau = 540.0 / T;
        double g = Iapws_if97.gamma0(pi, tau) + Iapws_if97.gammar(pi, tau);
        double g_tau = Iapws_if97.gamma0_tau(pi, tau) + Iapws_if97.gammar_tau(pi, tau);
        return 0.461526 * (tau * g_tau - g);
    }

    public static double cp_pt(double p, double T) {
        double ts = Iapws_if97.T4_p(p);
        if (T <= ts) {
            double pi = p / 16.53;
            double tau = 1386.0 / T;
            return -0.461526 * tau * tau * Iapws_if97.gamma1_tautau(pi, tau);
        }
        double pi = p;
        double tau = 540.0 / T;
        return -0.461526 * tau * tau * (Iapws_if97.gamma0_tautau(tau) + Iapws_if97.gammar_tautau(pi, tau));
    }

    public static double w_pt(double p, double T) {
        double ts = Iapws_if97.T4_p(p);
        if (T <= ts) {
            double pi = p / 16.53;
            double tau = 1386.0 / T;
            double gpi = Iapws_if97.gamma1_pi(pi, tau);
            double gpipi = Iapws_if97.gamma1_pipi(pi, tau);
            double gpitau = Iapws_if97.gamma1_pitau(pi, tau);
            double gtautau = Iapws_if97.gamma1_tautau(pi, tau);
            double num = 461.526 * T * gpi * gpi;
            double denom = (gpi - tau * gpitau) * (gpi - tau * gpitau) / (tau * tau * gtautau) - gpipi;
            return Math.sqrt(num / denom);
        }
        double pi = p;
        double tau = 540.0 / T;
        double grPi = Iapws_if97.gammar_pi(pi, tau);
        double grPipi = Iapws_if97.gammar_pipi(pi, tau);
        double grPitau = Iapws_if97.gammar_pitau(pi, tau);
        double grTautau = Iapws_if97.gammar_tautau(pi, tau);
        double g0tt = Iapws_if97.gamma0_tautau(tau);
        double num = 461.526 * T * (1.0 + 2.0 * pi * grPi + pi * pi * grPi * grPi);
        double denom = 1.0 - pi * pi * grPipi + Math.pow(1.0 + pi * grPi - tau * pi * grPitau, 2.0) / (tau * tau * (g0tt + grTautau));
        return Math.sqrt(num / denom);
    }

    public static double tsat_p(double p) {
        return Iapws_if97.T4_p(p);
    }

    public static double psat_t(double T) {
        return Iapws_if97.p4_T(T);
    }
}

