/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.flashops.Flash;
import neqsim.thermodynamicoperations.flashops.QfuncFlash;
import neqsim.thermodynamicoperations.flashops.SysNewtonRhapsonPHflash;
import neqsim.thermodynamicoperations.flashops.TPflash;

public class PSFlash
extends QfuncFlash {
    private static final long serialVersionUID = 1000L;
    double Sspec = 0.0;
    Flash tpFlash;
    int type = 0;

    public PSFlash(SystemInterface system, double Sspec, int type) {
        this.system = system;
        this.tpFlash = new TPflash(system);
        this.Sspec = Sspec;
        this.type = type;
    }

    @Override
    public double calcdQdTT() {
        if (this.system.getNumberOfPhases() == 1) {
            return -this.system.getPhase(0).getCp() / this.system.getTemperature();
        }
        double dQdTT = 0.0;
        for (int i = 0; i < this.system.getNumberOfPhases(); ++i) {
            dQdTT -= this.system.getPhase(i).getCp() / this.system.getPhase(i).getTemperature();
        }
        return dQdTT;
    }

    @Override
    public double calcdQdT() {
        double dQ = -this.system.getEntropy() + this.Sspec;
        return dQ;
    }

    @Override
    public double solveQ() {
        double oldTemp = this.system.getTemperature();
        double nyTemp = this.system.getTemperature();
        int iterations = 1;
        double error = 1.0;
        double errorOld = 1.0E11;
        double factor = 0.8;
        boolean correctFactor = true;
        double newCorr = 1.0;
        this.system.init(2);
        do {
            if (error > errorOld && factor > 0.1 && correctFactor) {
                factor *= 0.5;
            } else if (error < errorOld && correctFactor) {
                factor = 1.0;
            }
            ++iterations;
            oldTemp = this.system.getTemperature();
            newCorr = factor * this.calcdQdT() / this.calcdQdTT();
            nyTemp = oldTemp - newCorr;
            if (Math.abs(this.system.getTemperature() - nyTemp) > 10.0) {
                nyTemp = this.system.getTemperature() - Math.signum(this.system.getTemperature() - nyTemp) * 10.0;
                correctFactor = false;
            } else if (nyTemp < 0.0) {
                nyTemp = Math.abs(this.system.getTemperature() - 10.0);
                correctFactor = false;
            } else if (Double.isNaN(nyTemp)) {
                nyTemp = oldTemp + 1.0;
                correctFactor = false;
            } else {
                correctFactor = true;
            }
            this.system.setTemperature(nyTemp);
            this.tpFlash.run();
            this.system.init(2);
            errorOld = error;
        } while (((error = Math.abs(this.calcdQdT())) + errorOld > 1.0E-8 || iterations < 3) && iterations < 200);
        return nyTemp;
    }

    public void onPhaseSolve() {
    }

    @Override
    public void run() {
        this.tpFlash.run();
        if (this.type == 0) {
            this.solveQ();
        } else {
            SysNewtonRhapsonPHflash secondOrderSolver = new SysNewtonRhapsonPHflash(this.system, 2, this.system.getPhases()[0].getNumberOfComponents(), 1);
            secondOrderSolver.setSpec(this.Sspec);
            secondOrderSolver.solve(1);
        }
    }
}

