/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import Jama.Matrix;
import java.util.ArrayList;
import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.flashops.TPflash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TPmultiflashWAX
extends TPflash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(TPmultiflashWAX.class);
    boolean multiPhaseTest = false;
    double[] dQdbeta;
    double[][] Qmatrix;
    double[] E;
    double Q = 0.0;
    boolean doStabilityAnalysis = true;

    public TPmultiflashWAX(SystemInterface system) {
        super(system);
    }

    public TPmultiflashWAX(SystemInterface system, boolean checkForSolids) {
        super(system, checkForSolids);
    }

    public void calcMultiPhaseBeta() {
    }

    public void setXY() {
        for (int k = 0; k < this.system.getNumberOfPhases(); ++k) {
            for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
                if (this.system.getPhase(0).getComponent(i).getz() > 1.0E-100) {
                    this.system.getPhase(k).getComponent(i).setx(this.system.getPhase(0).getComponent(i).getz() / this.E[i] / this.system.getPhase(k).getComponent(i).getFugacityCoefficient());
                }
                if (this.system.getPhase(0).getComponent(i).getIonicCharge() != 0.0 && this.system.getPhase(k).getType() != PhaseType.AQUEOUS) {
                    this.system.getPhase(k).getComponent(i).setx(1.0E-50);
                }
                if (this.system.getPhase(0).getComponent(i).getIonicCharge() != 0.0 && this.system.getPhase(k).getType() == PhaseType.AQUEOUS) {
                    this.system.getPhase(k).getComponent(i).setx(this.system.getPhase(k).getComponent(i).getNumberOfmoles() / this.system.getPhase(k).getNumberOfMolesInPhase());
                }
                if (!this.system.hasPhaseType("wax")) continue;
                this.system.getPhaseOfType("wax").getComponent(i).setx(0.0);
            }
            this.system.getPhase(k).normalize();
        }
    }

    public void calcE() {
        this.E = new double[this.system.getPhase(0).getNumberOfComponents()];
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            for (int k = 0; k < this.system.getNumberOfPhases(); ++k) {
                int n = i;
                this.E[n] = this.E[n] + this.system.getPhase(k).getBeta() / this.system.getPhase(k).getComponent(i).getFugacityCoefficient();
            }
        }
    }

    public double calcQ() {
        int i;
        int k;
        this.Q = 0.0;
        double betaTotal = 0.0;
        this.dQdbeta = new double[this.system.getNumberOfPhases()];
        this.Qmatrix = new double[this.system.getNumberOfPhases()][this.system.getNumberOfPhases()];
        for (k = 0; k < this.system.getNumberOfPhases(); ++k) {
            betaTotal += this.system.getPhase(k).getBeta();
        }
        this.Q = betaTotal;
        this.calcE();
        for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            this.Q -= Math.log(this.E[i]) * this.system.getPhase(0).getComponent(i).getz();
        }
        for (k = 0; k < this.system.getNumberOfPhases(); ++k) {
            this.dQdbeta[k] = 1.0;
            for (int i2 = 0; i2 < this.system.getPhase(0).getNumberOfComponents(); ++i2) {
                int n = k;
                this.dQdbeta[n] = this.dQdbeta[n] - this.system.getPhase(0).getComponent(i2).getz() * 1.0 / this.E[i2] / this.system.getPhase(k).getComponent(i2).getFugacityCoefficient();
            }
        }
        for (i = 0; i < this.system.getNumberOfPhases(); ++i) {
            for (int j = 0; j < this.system.getNumberOfPhases(); ++j) {
                this.Qmatrix[i][j] = 0.0;
                for (int k2 = 0; k2 < this.system.getPhase(0).getNumberOfComponents(); ++k2) {
                    double[] dArray = this.Qmatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.system.getPhase(0).getComponent(k2).getz() / (this.E[k2] * this.E[k2] * this.system.getPhase(j).getComponent(k2).getFugacityCoefficient() * this.system.getPhase(i).getComponent(k2).getFugacityCoefficient());
                }
                if (i != j) continue;
                double[] dArray = this.Qmatrix[i];
                int n = j;
                dArray[n] = dArray[n] + 1.0E-10;
            }
        }
        return this.Q;
    }

    public void solveBeta(boolean updateFugacities) {
        double[] oldBeta = new double[this.system.getNumberOfPhases()];
        Matrix ans = new Matrix(this.system.getNumberOfPhases() - 1, 1);
        int iter = 1;
        do {
            ++iter;
            for (int k = 0; k < this.system.getNumberOfPhases(); ++k) {
                oldBeta[k] = this.system.getPhase(k).getBeta();
            }
            this.calcQ();
            Matrix betaMatrix = new Matrix(oldBeta, 1).transpose();
            Matrix dQM = new Matrix(this.dQdbeta, 1);
            Matrix dQdBM = new Matrix(this.Qmatrix);
            try {
                ans = dQdBM.solve(dQM.transpose());
            }
            catch (Exception exception) {
                // empty catch block
            }
            betaMatrix.minusEquals(ans.times((double)iter / ((double)iter + 2.0)));
            for (int k = 0; k < this.system.getNumberOfPhases(); ++k) {
                this.system.setBeta(k, betaMatrix.get(k, 0));
                if (betaMatrix.get(k, 0) < 0.0) {
                    this.system.setBeta(k, 1.0E-9);
                }
                if (!(betaMatrix.get(k, 0) > 1.0)) continue;
                this.system.setBeta(k, 0.999999999);
            }
            if (updateFugacities) {
                // empty if block
            }
            this.calcE();
            this.setXY();
            if (!updateFugacities) continue;
            this.system.init(1);
        } while (ans.norm2() > 1.0E-6 && iter < 20 || iter < 3);
    }

    @Override
    public void stabilityAnalysis() {
        int i;
        int i2;
        int k;
        double[] logWi = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[][] Wi = new double[this.system.getPhase(0).getNumberOfComponents()][this.system.getPhase(0).getNumberOfComponents()];
        double[] sumw = new double[this.system.getPhase(0).getNumberOfComponents()];
        double err = 0.0;
        double[] oldlogw = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[] d = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[][] x = new double[this.system.getPhase(0).getNumberOfComponents()][this.system.getPhase(0).getNumberOfComponents()];
        this.tm = new double[this.system.getPhase(0).getNumberOfComponents()];
        ArrayList<SystemInterface> clonedSystem = new ArrayList<SystemInterface>(1);
        int waxphasenumber = 5;
        SystemInterface minimumGibbsEnergySystem = this.system.clone();
        for (int i3 = 0; i3 < this.system.getPhase(0).getNumberOfComponents(); ++i3) {
            double numb = 0.0;
            if (this.system.getPhase(0).getComponent(i3).getx() < 1.0E-100) {
                clonedSystem.add(null);
                continue;
            }
            clonedSystem.add(this.system.clone());
            for (int j = 0; j < this.system.getPhase(0).getNumberOfComponents(); ++j) {
                double d2 = numb = i3 == j ? 1.0 : 1.0E-12;
                if (this.system.getPhase(0).getComponent(j).getz() < 1.0E-100) {
                    numb = 0.0;
                }
                ((SystemInterface)clonedSystem.get(i3)).getPhase(waxphasenumber).getComponent(j).setx(numb);
            }
            if (this.system.getPhase(0).getComponent(i3).getIonicCharge() != 0.0) continue;
            ((SystemInterface)clonedSystem.get(i3)).init(1);
        }
        this.lowestGibbsEnergyPhase = 0;
        for (k = 0; k < minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++k) {
            for (int i4 = 0; i4 < minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++i4) {
                if (clonedSystem.get(k) == null) continue;
                int n = k;
                sumw[n] = sumw[n] + ((SystemInterface)clonedSystem.get(k)).getPhase(waxphasenumber).getComponent(i4).getx();
            }
        }
        for (k = 0; k < minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++k) {
            for (int i5 = 0; i5 < minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++i5) {
                if (clonedSystem.get(k) == null || !(this.system.getPhase(0).getComponent(k).getx() > 1.0E-100)) continue;
                ((SystemInterface)clonedSystem.get(k)).getPhase(waxphasenumber).getComponent(i5).setx(((SystemInterface)clonedSystem.get(k)).getPhase(waxphasenumber).getComponent(i5).getx() / sumw[0]);
            }
            if (!(this.system.getPhase(0).getComponent(k).getx() > 1.0E-100)) continue;
            d[k] = Math.log(minimumGibbsEnergySystem.getPhases()[this.lowestGibbsEnergyPhase].getComponent(k).getx()) + minimumGibbsEnergySystem.getPhases()[this.lowestGibbsEnergyPhase].getComponent(k).getLogFugacityCoefficient();
        }
        for (int j = 0; j < minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++j) {
            logWi[j] = this.system.getPhase(0).getComponent(j).getz() > 1.0E-100 ? 1.0 : -10000.0;
        }
        int hydrocarbonTestCompNumb = 0;
        int lightTestCompNumb = 0;
        double Mmax = 0.0;
        double Mmin = 1.0E10;
        for (i2 = 0; i2 < minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++i2) {
            if (!minimumGibbsEnergySystem.getPhase(0).getComponent(i2).isHydrocarbon()) continue;
            if (minimumGibbsEnergySystem.getPhase(0).getComponent(i2).getMolarMass() > Mmax) {
                Mmax = minimumGibbsEnergySystem.getPhase(0).getComponent(i2).getMolarMass();
            }
            if (!(minimumGibbsEnergySystem.getPhase(0).getComponent(i2).getMolarMass() < Mmin)) continue;
            Mmin = minimumGibbsEnergySystem.getPhase(0).getComponent(i2).getMolarMass();
        }
        for (i2 = 0; i2 < minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++i2) {
            if (minimumGibbsEnergySystem.getPhase(0).getComponent(i2).isHydrocarbon() && Math.abs(minimumGibbsEnergySystem.getPhase(0).getComponent(i2).getMolarMass() - Mmax) < 1.0E-5) {
                hydrocarbonTestCompNumb = i2;
            }
            if (!minimumGibbsEnergySystem.getPhase(0).getComponent(i2).isHydrocarbon() || !(Math.abs(minimumGibbsEnergySystem.getPhase(0).getComponent(i2).getMolarMass() - Mmin) < 1.0E-5)) continue;
            lightTestCompNumb = i2;
        }
        for (int j = this.system.getPhase(0).getNumberOfComponents() - 1; j >= 0; --j) {
            if (minimumGibbsEnergySystem.getPhase(0).getComponent(j).getx() < 1.0E-100 || minimumGibbsEnergySystem.getPhase(0).getComponent(j).getIonicCharge() != 0.0 || minimumGibbsEnergySystem.getPhase(0).getComponent(j).isHydrocarbon() && j != hydrocarbonTestCompNumb && j != lightTestCompNumb) continue;
            int iter = 0;
            do {
                ++iter;
                err = 0.0;
                ((SystemInterface)clonedSystem.get(j)).init(1, waxphasenumber);
                for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
                    oldlogw[i] = logWi[i];
                    if (!Double.isInfinite(Math.log(((SystemInterface)clonedSystem.get(j)).getPhase(waxphasenumber).getComponent(i).getLogFugacityCoefficient())) && this.system.getPhase(0).getComponent(i).getx() > 1.0E-100) {
                        logWi[i] = d[i] - Math.log(((SystemInterface)clonedSystem.get(j)).getPhase(waxphasenumber).getComponent(i).getFugacityCoefficient());
                        if (((SystemInterface)clonedSystem.get(j)).getPhase(1).getComponent(i).getIonicCharge() != 0.0) {
                            logWi[i] = -1000.0;
                        }
                    }
                    err += Math.abs(logWi[i] - oldlogw[i]);
                    Wi[j][i] = Math.exp(logWi[i]);
                }
                sumw[j] = 0.0;
                for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
                    int n = j;
                    sumw[n] = sumw[n] + Math.exp(logWi[i]);
                }
                for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
                    ((SystemInterface)clonedSystem.get(j)).getPhase(waxphasenumber).getComponent(i).setx(Math.exp(logWi[i]) / sumw[j]);
                }
            } while (Math.abs(err) > 1.0E-9 && iter < 100);
            this.tm[j] = 1.0;
            for (i = 0; i < this.system.getPhase(1).getNumberOfComponents(); ++i) {
                int n = j;
                this.tm[n] = this.tm[n] - Math.exp(logWi[i]);
                x[j][i] = ((SystemInterface)clonedSystem.get(j)).getPhase(waxphasenumber).getComponent(i).getx();
            }
            if (iter >= 99) {
                logger.info("iter > maxiter multiphase stability ");
                logger.info("error " + Math.abs(err));
                logger.info("tm: " + this.tm[j]);
            }
            if (this.tm[j] < -1.0E-8) break;
        }
        int unstabcomp = 0;
        for (int k2 = this.system.getPhase(0).getNumberOfComponents() - 1; k2 >= 0; --k2) {
            if (!(this.tm[k2] < -1.0E-8) || Double.isNaN(this.tm[k2])) continue;
            this.system.addPhase();
            this.system.setPhaseIndex(this.system.getNumberOfPhases() - 1, waxphasenumber);
            unstabcomp = k2;
            for (i = 0; i < this.system.getPhase(1).getNumberOfComponents(); ++i) {
                this.system.getPhase(this.system.getNumberOfPhases() - 1).getComponent(i).setx(x[k2][i]);
            }
            this.multiPhaseTest = true;
            this.system.setBeta(this.system.getNumberOfPhases() - 1, this.system.getPhase(0).getComponent(unstabcomp).getz());
            this.system.init(1);
            this.system.normalizeBeta();
            return;
        }
        this.system.normalizeBeta();
        logger.info("STABILITY ANALYSIS: ");
        logger.info("tm1: " + this.tm[0] + "  tm2: " + this.tm[1]);
    }

    @Override
    public void run() {
        int i;
        if (this.doStabilityAnalysis) {
            this.stabilityAnalysis();
        }
        this.doStabilityAnalysis = true;
        int iterations = 0;
        if (this.multiPhaseTest && !this.system.isChemicalSystem()) {
            double oldBeta = 1.0;
            double diff = 1.0;
            do {
                oldBeta = this.system.getBeta(this.system.getNumberOfPhases() - 1);
                this.solveBeta(true);
            } while ((diff = Math.abs((this.system.getBeta(this.system.getNumberOfPhases() - 1) - oldBeta) / oldBeta)) > 1.0E-5 && ++iterations < 50);
            if (iterations >= 49) {
                logger.error("error in multiphase flash..did not solve in 50 iterations");
            }
        }
        double chemdev = 0.0;
        if (this.system.isChemicalSystem()) {
            for (int phaseNum = 0; phaseNum < this.system.getNumberOfPhases(); ++phaseNum) {
                chemdev = 0.0;
                double[] xchem = new double[this.system.getPhase(phaseNum).getNumberOfComponents()];
                this.i = 0;
                while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                    xchem[this.i] = this.system.getPhase(phaseNum).getComponent(this.i).getx();
                    ++this.i;
                }
                this.system.init(1);
                this.system.getChemicalReactionOperations().solveChemEq(phaseNum, 1);
                this.i = 0;
                while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                    chemdev += Math.abs(xchem[this.i] - this.system.getPhase(phaseNum).getComponent(this.i).getx());
                    ++this.i;
                }
                logger.info("chemdev: " + chemdev);
            }
        }
        boolean hasRemovedPhase = false;
        for (i = 0; i < this.system.getNumberOfPhases(); ++i) {
            if (!(this.system.getBeta(i) < 1.1E-9)) continue;
            this.system.removePhaseKeepTotalComposition(i);
            this.doStabilityAnalysis = false;
            hasRemovedPhase = true;
        }
        if (!hasRemovedPhase) {
            for (i = 0; i < this.system.getNumberOfPhases() - 1; ++i) {
                if (!(Math.abs(this.system.getPhase(i).getDensity() - this.system.getPhase(i + 1).getDensity()) < 1.1E-4)) continue;
                this.system.removePhaseKeepTotalComposition(i + 1);
                this.doStabilityAnalysis = false;
                hasRemovedPhase = true;
            }
        }
        if (hasRemovedPhase) {
            this.run();
        }
        this.system.orderByDensity();
    }
}

