/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.flashops.TPflash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class dTPflash
extends TPflash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(dTPflash.class);
    String[] flashComp = null;

    public dTPflash(SystemInterface system, String[] comps) {
        this.system = system;
        this.flashComp = comps;
    }

    @Override
    public void run() {
        this.iterations = 0;
        double diff = 0.0;
        do {
            diff = 0.0;
            ++this.iterations;
            this.system.init(1);
            for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
                for (int j = 0; j < this.flashComp.length; ++j) {
                    if (!this.flashComp[j].equals(this.system.getPhase(0).getComponent(i).getName())) continue;
                    diff += Math.abs(this.system.getPhase(1).getComponent(i).getx() * this.system.getPhase(1).getComponent(i).getFugacityCoefficient() * this.system.getPhase(1).getPressure() - this.system.getPhase(0).getComponent(i).getx() * this.system.getPhase(0).getComponent(i).getFugacityCoefficient() * this.system.getPhase(0).getPressure());
                    this.system.getPhase(1).getComponent(i).setx(this.system.getPhase(1).getComponent(i).getx() * (this.system.getPhase(0).getComponent(i).getx() * this.system.getPhase(0).getComponent(i).getFugacityCoefficient() * this.system.getPhase(0).getPressure()) / (this.system.getPhase(1).getComponent(i).getx() * this.system.getPhase(1).getComponent(i).getFugacityCoefficient() * this.system.getPhase(1).getPressure()));
                }
            }
            this.system.getPhase(1).normalize();
            logger.info("diff " + diff);
        } while (diff > 1.0E-10 && this.iterations < 1000);
        if (diff > 1.0E-10) {
            logger.error("not able to converge dPflash....continuing....");
        }
    }
}

