/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops.saturationops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyTemperatureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BubblePointTemperatureNoDer
extends ConstantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(BubblePointTemperatureNoDer.class);

    public BubblePointTemperatureNoDer(SystemInterface system) {
        super(system);
    }

    @Override
    public void run() {
        int i;
        if (this.system.getPhase(0).getNumberOfComponents() == 1 && this.system.getPressure() > this.system.getPhase(0).getComponent(0).getPC()) {
            this.setSuperCritical(true);
        }
        int iterations = 0;
        int maxNumberOfIterations = 1000;
        double yold = 0.0;
        double ytotal = 1.0;
        this.system.init(0);
        this.system.setNumberOfPhases(2);
        this.system.setBeta(1, 0.9999999999);
        this.system.setBeta(0, 1.0E-10);
        if (this.system.getPhase(0).getNumberOfComponents() == 1) {
            double oldTemp = this.system.getTemperature();
            if (this.system.getPressure() > this.system.getPhase(0).getComponent(0).getPC()) {
                this.setSuperCritical(true);
                return;
            }
            if (this.system.getPressure() < this.system.getPhase(0).getComponent(0).getPC()) {
                this.system.setTemperature(this.system.getPhase(0).getComponent(0).getAntoineVaporTemperature(this.system.getPressure()));
            }
            if (this.system.getTemperature() > this.system.getPhase(0).getComponent(0).getTC() || this.system.getTemperature() < this.system.getPhase(0).getComponent(0).getTriplePointTemperature()) {
                this.system.setTemperature(oldTemp);
            }
        }
        if (this.system.isChemicalSystem()) {
            this.system.getChemicalReactionOperations().solveChemEq(0);
            this.system.getChemicalReactionOperations().solveChemEq(1);
        }
        for (i = 0; i < this.system.getPhases()[1].getNumberOfComponents(); ++i) {
            this.system.getPhases()[1].getComponent(i).setx(this.system.getPhases()[0].getComponent(i).getz());
            if (this.system.getPhases()[0].getComponent(i).getIonicCharge() != 0.0) {
                this.system.getPhases()[0].getComponent(i).setx(1.0E-40);
                continue;
            }
            this.system.getPhases()[0].getComponent(i).setx(this.system.getPhases()[0].getComponent(i).getK() * this.system.getPhases()[1].getComponent(i).getz());
        }
        ytotal = 0.0;
        for (i = 0; i < this.system.getPhases()[0].getNumberOfComponents(); ++i) {
            ytotal += this.system.getPhases()[0].getComponent(i).getx();
        }
        double oldTemp = 10.0;
        double ktot = 0.0;
        do {
            int i2;
            ++iterations;
            for (i2 = 0; i2 < this.system.getPhases()[0].getNumberOfComponents(); ++i2) {
                this.system.getPhases()[0].getComponent(i2).setx(this.system.getPhases()[0].getComponent(i2).getx() / ytotal);
            }
            if (this.system.isChemicalSystem() && iterations % 2 == 0) {
                this.system.getChemicalReactionOperations().solveChemEq(1);
            }
            this.system.init(1);
            oldTemp = this.system.getTemperature();
            ktot = 0.0;
            for (i2 = 0; i2 < this.system.getPhases()[1].getNumberOfComponents(); ++i2) {
                do {
                    yold = this.system.getPhases()[0].getComponent(i2).getx();
                    if (this.system.getPhase(0).getComponent(i2).getIonicCharge() != 0.0) {
                        this.system.getPhases()[0].getComponent(i2).setK(1.0E-40);
                    } else {
                        this.system.getPhases()[0].getComponent(i2).setK(Math.exp(Math.log(this.system.getPhases()[1].getComponent(i2).getFugacityCoefficient()) - Math.log(this.system.getPhases()[0].getComponent(i2).getFugacityCoefficient())));
                    }
                    this.system.getPhases()[1].getComponent(i2).setK(this.system.getPhases()[0].getComponent(i2).getK());
                    this.system.getPhases()[0].getComponent(i2).setx(this.system.getPhases()[0].getComponent(i2).getK() * this.system.getPhases()[1].getComponent(i2).getz());
                } while (Math.abs(this.system.getPhases()[0].getComponent(i2).getx() - yold) > 1.0E-4);
                ktot += Math.abs(this.system.getPhases()[1].getComponent(i2).getK() - 1.0);
            }
            ytotal = 0.0;
            for (i2 = 0; i2 < this.system.getPhases()[0].getNumberOfComponents(); ++i2) {
                ytotal += this.system.getPhases()[0].getComponent(i2).getx();
            }
            if (ytotal > 1.2) {
                ytotal = 1.2;
            }
            if (ytotal < 0.8) {
                ytotal = 0.8;
            }
            this.system.setTemperature(this.system.getTemperature() + 0.1 * this.system.getTemperature() * (1.0 - ytotal));
        } while ((Math.abs(ytotal) - 1.0 > 1.0E-9 || Math.abs(oldTemp - this.system.getTemperature()) / oldTemp > 1.0E-8) && iterations < maxNumberOfIterations);
        if (Math.abs(ytotal - 1.0) >= 1.0E-5 || ktot < 0.001 && this.system.getPhase(0).getNumberOfComponents() > 1) {
            this.setSuperCritical(true);
        }
        if (this.system.getPhase(0).getNumberOfComponents() == 1 && Math.abs(this.system.getPhases()[1].getComponent(0).getFugacityCoefficient() / this.system.getPhases()[0].getComponent(0).getFugacityCoefficient() - 1.0) < 1.0E-20) {
            this.setSuperCritical(true);
        }
    }

    @Override
    public void printToFile(String name) {
    }
}

